/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import org.jfree.util.ObjectUtils;

public class ObjectTable
implements Serializable {
    private int rows = 0;
    private int columns = 0;
    private transient Object[][] data = new Object[0][];

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.columns;
    }

    protected Object getObject(int n, int n2) {
        Object[] objectArray;
        Object object = null;
        if (n < this.data.length && n2 < (objectArray = this.data[n]).length) {
            object = objectArray[n2];
        }
        return object;
    }

    protected void setObject(int n, int n2, Object object) {
        Object[][] objectArrayArray;
        if (n >= this.data.length) {
            objectArrayArray = new Object[n + 1][];
            System.arraycopy(this.data, 0, objectArrayArray, 0, this.data.length);
            int n3 = this.data.length;
            while (n3 <= n) {
                objectArrayArray[n3] = new Object[0];
                ++n3;
            }
            this.data = objectArrayArray;
            this.rows = n + 1;
        }
        if (n2 >= (objectArrayArray = this.data[n]).length) {
            Object[] objectArray = new Object[n2 + 1];
            System.arraycopy(objectArrayArray, 0, objectArray, 0, objectArrayArray.length);
            objectArray[n2] = object;
            this.data[n] = objectArray;
            this.columns = n2 + 1;
        } else {
            objectArrayArray[n2] = object;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof ObjectTable) {
            ObjectTable objectTable = (ObjectTable)object;
            boolean bl = this.getRowCount() == objectTable.getRowCount();
            boolean bl2 = bl = bl && this.getColumnCount() == objectTable.getColumnCount();
            if (bl) {
                int n = 0;
                while (n < this.getRowCount()) {
                    int n2 = 0;
                    while (n2 < this.getColumnCount()) {
                        bl = bl && ObjectUtils.equal(this.getObject(n, n2), objectTable.getObject(n, n2));
                        ++n2;
                    }
                    ++n;
                }
            }
            return bl;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.data.length;
        objectOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray = this.data[n2];
            int n3 = objectArray.length;
            objectOutputStream.writeInt(n3);
            int n4 = 0;
            while (n4 < n3) {
                this.writeSerializedData(objectOutputStream, objectArray[n4]);
                ++n4;
            }
            ++n2;
        }
    }

    protected void writeSerializedData(ObjectOutputStream objectOutputStream, Object object) throws IOException {
        objectOutputStream.writeObject(object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.data = new Object[n][];
        int n2 = 0;
        while (n2 < n) {
            int n3 = objectInputStream.readInt();
            Object[] objectArray = new Object[n3];
            this.data[n2] = objectArray;
            int n4 = 0;
            while (n4 < n3) {
                objectArray[n4] = this.readSerializedData(objectInputStream);
                ++n4;
            }
            ++n2;
        }
    }

    protected Object readSerializedData(ObjectInputStream objectInputStream) throws OptionalDataException, ClassNotFoundException, IOException {
        return objectInputStream.readObject();
    }
}

