/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.python.core.Options;
import org.python.core.PackageManager;
import org.python.core.PollingInputStream;
import org.python.core.Py;
import org.python.core.PyEllipsis;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFrame;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PyModule;
import org.python.core.PyNone;
import org.python.core.PyNotImplemented;
import org.python.core.PyObject;
import org.python.core.PySingleton;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySyntaxError;
import org.python.core.PySystemStateFunctions;
import org.python.core.PyTuple;
import org.python.core.PythonTraceFunction;
import org.python.core.StderrWrapper;
import org.python.core.StdoutWrapper;
import org.python.core.SysPackageManager;
import org.python.core.TraceFunction;
import org.python.core.codecs;
import org.python.modules.Setup;

public class PySystemState
extends PyObject {
    public static String version = "2.1";
    private static int PY_MAJOR_VERSION = 2;
    private static int PY_MINOR_VERSION = 1;
    private static int PY_MICRO_VERSION = 0;
    private static int PY_RELEASE_LEVEL = 15;
    private static int PY_RELEASE_SERIAL = 0;
    public static int hexversion = PY_MAJOR_VERSION << 24 | PY_MINOR_VERSION << 16 | PY_MICRO_VERSION << 8 | PY_RELEASE_LEVEL << 4 | PY_RELEASE_SERIAL;
    public static PyTuple version_info;
    public static String copyright;
    public static String platform;
    public static int maxint;
    public static int minint;
    public static PyList warnoptions;
    private static PyJavaClass __builtin__class;
    private static PyList defaultPath;
    private static PyList defaultArgv;
    public static Properties registry;
    public static String prefix;
    public static String exec_prefix;
    private static boolean initialized;
    public static PackageManager packageManager;
    public static File cachedir;
    private static Hashtable builtinNames;
    public static String[] builtin_module_names;
    public PyList argv = new PyList();
    public PyObject modules;
    public PyList path;
    public PyObject builtins;
    public PyObject ps1 = new PyString(">>> ");
    public PyObject ps2 = new PyString("... ");
    public PyObject executable = Py.None;
    private ClassLoader classLoader = null;
    public PyObject stdout;
    public PyObject stderr;
    public PyObject stdin;
    public PyObject __stdout__;
    public PyObject __stderr__;
    public PyObject __stdin__;
    public PyObject __displayhook__;
    public PyObject __excepthook__;
    public PyObject last_value = Py.None;
    public PyObject last_type = Py.None;
    public PyObject last_traceback = Py.None;
    public PyObject __dict__;
    public TraceFunction tracefunc = null;
    public TraceFunction profilefunc = null;
    private static /* synthetic */ Class class$Lorg$python$core$__builtin__;

    public static void exit(PyObject status) {
        throw new PyException(Py.SystemExit, status);
    }

    public static void exit() {
        PySystemState.exit(Py.None);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static PyTuple exc_info() {
        PyException exc = Py.getThreadState().exception;
        if (exc == null) {
            return new PyTuple(new PyObject[]{Py.None, Py.None, Py.None});
        }
        return new PyTuple(new PyObject[]{exc.type, exc.value, exc.traceback});
    }

    public static PyFrame _getframe() {
        return PySystemState._getframe(-1);
    }

    public static PyFrame _getframe(int depth) {
        PyFrame f = Py.getFrame();
        while (depth > 0 && f != null) {
            f = f.f_back;
            --depth;
        }
        if (f == null) {
            throw Py.ValueError("call stack is not deep enough");
        }
        return f;
    }

    public PyObject __findattr__(String name) {
        if (name == "exc_value") {
            PyException exc = Py.getThreadState().exception;
            if (exc == null) {
                return null;
            }
            return exc.value;
        }
        if (name == "exc_type") {
            PyException exc = Py.getThreadState().exception;
            if (exc == null) {
                return null;
            }
            return exc.type;
        }
        if (name == "exc_traceback") {
            PyException exc = Py.getThreadState().exception;
            if (exc == null) {
                return null;
            }
            return exc.traceback;
        }
        if (name == "warnoptions") {
            if (warnoptions == null) {
                warnoptions = new PyList();
            }
            return warnoptions;
        }
        PyObject ret = super.__findattr__(name);
        if (ret != null) {
            return ret;
        }
        return this.__dict__.__finditem__(name);
    }

    public void __setattr__(String name, PyObject value) {
        if (this.__class__ == null) {
            return;
        }
        PyObject ret = this.__class__.lookup(name, false);
        if (ret != null) {
            ret._doset(this, value);
            return;
        }
        if (this.__dict__ == null) {
            this.__dict__ = new PyStringMap();
        }
        this.__dict__.__setitem__(name, value);
    }

    public void __delattr__(String name) {
        if (this.__dict__ != null) {
            this.__dict__.__delitem__(name);
            return;
        }
        throw Py.AttributeError("del '" + name + "'");
    }

    public String safeRepr() throws PyIgnoreMethodTag {
        return "module 'sys'";
    }

    public String toString() {
        return "sys module";
    }

    private static final String findRoot(Properties preProperties, Properties postProperties) {
        String root = null;
        try {
            String lversion;
            String version;
            if (postProperties != null) {
                root = postProperties.getProperty("python.home");
            }
            if (root == null) {
                root = preProperties.getProperty("python.home");
            }
            if (root == null) {
                root = preProperties.getProperty("install.root");
            }
            if ((version = preProperties.getProperty("java.version")) == null) {
                version = "???";
            }
            if ((lversion = version.toLowerCase()).startsWith("java")) {
                version = version.substring(4, version.length());
            }
            if (lversion.startsWith("jdk") || lversion.startsWith("jre")) {
                version = version.substring(3, version.length());
            }
            if (version.equals("11")) {
                version = "1.1";
            }
            if (version.equals("12")) {
                version = "1.2";
            }
            if (version != null) {
                platform = "java" + version;
            }
        }
        catch (Exception exc) {
            return null;
        }
        if (root != null) {
            return root;
        }
        String classpath = preProperties.getProperty("java.class.path");
        if (classpath == null) {
            return null;
        }
        int jpy = classpath.toLowerCase().indexOf("jython.jar");
        if (jpy == -1) {
            return null;
        }
        int start = classpath.lastIndexOf(File.pathSeparator, jpy) + 1;
        return classpath.substring(start, jpy);
    }

    private static final void initRegistry(Properties preProperties, Properties postProperties) {
        if (registry != null) {
            Py.writeError("systemState", "trying to reinitialize registry");
            return;
        }
        registry = preProperties;
        exec_prefix = PySystemState.findRoot(preProperties, postProperties);
        prefix = exec_prefix;
        if (prefix != null) {
            if (prefix.length() == 0) {
                exec_prefix = ".";
                prefix = ".";
            }
            try {
                PySystemState.addRegistryFile(new File(prefix, "registry"));
                File homeFile = new File(registry.getProperty("user.home"), ".jython");
                PySystemState.addRegistryFile(homeFile);
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        if (postProperties != null) {
            Enumeration e = ((Hashtable)postProperties).keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = (String)((Hashtable)postProperties).get(key);
                ((Hashtable)registry).put(key, value);
            }
        }
        Options.setFromRegistry();
    }

    private static final void addRegistryFile(File file) {
        if (file.exists()) {
            registry = new Properties(registry);
            try {
                FileInputStream fp = new FileInputStream(file);
                try {
                    registry.load(fp);
                }
                finally {
                    Object var3_3 = null;
                    fp.close();
                }
            }
            catch (IOException e) {
                System.err.println("couldn't open registry file: " + file.toString());
            }
        }
    }

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        PySystemState.initialize(System.getProperties(), null, new String[]{""});
    }

    public static synchronized void initialize(Properties preProperties, Properties postProperties, String[] argv) {
        PySystemState.initialize(preProperties, postProperties, argv, null);
    }

    public static synchronized void initialize(Properties preProperties, Properties postProperties, String[] argv, ClassLoader classLoader) {
        if (initialized) {
            return;
        }
        initialized = true;
        PySystemState.initRegistry(preProperties, postProperties);
        PySystemState.initBuiltins(registry);
        PySystemState.initStaticFields();
        defaultPath = PySystemState.initPath(registry);
        defaultArgv = PySystemState.initArgv(argv);
        PySystemState.initPackages(registry);
        Py.defaultSystemState = new PySystemState();
        Py.setSystemState(Py.defaultSystemState);
        if (classLoader != null) {
            Py.defaultSystemState.setClassLoader(classLoader);
        }
        Py.initClassExceptions(__builtin__class.__getattr__("__dict__"));
        PySyntaxError pySyntaxError = new PySyntaxError("", 1, 1, "", "");
    }

    private static final void initStaticFields() {
        Py.None = new PyNone();
        Py.NotImplemented = new PyNotImplemented();
        Py.NoKeywords = new String[0];
        Py.EmptyObjects = new PyObject[0];
        Py.EmptyTuple = new PyTuple(Py.EmptyObjects);
        Py.NoConversion = new PySingleton("Error");
        Py.Ellipsis = new PyEllipsis();
        Py.Zero = new PyInteger(0);
        Py.One = new PyInteger(1);
        Py.EmptyString = new PyString("");
        Py.Newline = new PyString("\n");
        Py.Space = new PyString(" ");
        __builtin__class = PyJavaClass.lookup(class$Lorg$python$core$__builtin__ != null ? class$Lorg$python$core$__builtin__ : (class$Lorg$python$core$__builtin__ = PySystemState.class$("org.python.core.__builtin__")));
        Py.stderr = new StderrWrapper();
        Py.stdout = new StdoutWrapper();
        String s = null;
        if (PY_RELEASE_LEVEL == 10) {
            s = "alpha";
        } else if (PY_RELEASE_LEVEL == 11) {
            s = "beta";
        } else if (PY_RELEASE_LEVEL == 12) {
            s = "candidate";
        } else if (PY_RELEASE_LEVEL == 15) {
            s = "final";
        }
        version_info = new PyTuple(new PyObject[]{Py.newInteger(PY_MAJOR_VERSION), Py.newInteger(PY_MINOR_VERSION), Py.newInteger(PY_MICRO_VERSION), Py.newString(s), Py.newInteger(PY_RELEASE_SERIAL)});
    }

    private static final void initCacheDirectory(Properties props) {
        if (Py.frozen) {
            cachedir = null;
            return;
        }
        cachedir = new File(props.getProperty("python.cachedir", "cachedir"));
        if (!cachedir.isAbsolute()) {
            cachedir = new File(prefix, cachedir.getPath());
        }
    }

    private static final void initPackages(Properties props) {
        File pkgdir;
        PySystemState.initCacheDirectory(props);
        if (cachedir != null) {
            File file = new File(cachedir, "packages");
        } else {
            pkgdir = null;
        }
        packageManager = new SysPackageManager(pkgdir, props);
    }

    private static final PyList initArgv(String[] args) {
        PyList argv = new PyList();
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                argv.append(new PyString(args[i]));
                ++i;
            }
        }
        return argv;
    }

    private static final void addBuiltin(String name) {
        String classname;
        String modname;
        int colon = name.indexOf(58);
        if (colon != -1) {
            modname = name.substring(0, colon).trim();
            classname = name.substring(colon + 1, name.length()).trim();
            if (classname.equals("null")) {
                classname = null;
            }
        } else {
            modname = name.trim();
            classname = "org.python.modules." + modname;
        }
        if (classname != null) {
            builtinNames.put(modname, classname);
        } else {
            builtinNames.remove(modname);
        }
    }

    private static final void initBuiltins(Properties props) {
        builtinNames = new Hashtable();
        int i = 0;
        while (i < Setup.builtinModules.length) {
            PySystemState.addBuiltin(Setup.builtinModules[i]);
            ++i;
        }
        String builtinprop = props.getProperty("python.modules.builtin", "");
        StringTokenizer tok = new StringTokenizer(builtinprop, ",");
        while (tok.hasMoreTokens()) {
            PySystemState.addBuiltin(tok.nextToken());
        }
        int n = builtinNames.size();
        builtin_module_names = new String[n];
        Enumeration keys = builtinNames.keys();
        int i2 = 0;
        while (i2 < n) {
            PySystemState.builtin_module_names[i2] = (String)keys.nextElement();
            ++i2;
        }
    }

    static String getBuiltin(String name) {
        return (String)builtinNames.get(name);
    }

    private static final PyList initPath(Properties props) {
        PyList path = new PyList();
        if (!Py.frozen) {
            PySystemState.addPaths(path, props.getProperty("python.prepath", "."));
            if (prefix != null) {
                String libpath = new File(prefix, "Lib").toString();
                path.append(new PyString(libpath));
            }
            PySystemState.addPaths(path, props.getProperty("python.path", ""));
        }
        return path;
    }

    private static final void addPaths(PyList path, String pypath) {
        StringTokenizer tok = new StringTokenizer(pypath, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            path.append(new PyString(tok.nextToken().trim()));
        }
    }

    public static PyJavaPackage add_package(String n) {
        return PySystemState.add_package(n, null);
    }

    public static PyJavaPackage add_package(String n, String contents) {
        return packageManager.makeJavaPackage(n, contents, null);
    }

    public static void add_classdir(String directoryPath) {
        packageManager.addDirectory(new File(directoryPath));
    }

    public static void add_extdir(String directoryPath) {
        packageManager.addJarDir(directoryPath, false);
    }

    public static void add_extdir(String directoryPath, boolean cache) {
        packageManager.addJarDir(directoryPath, cache);
    }

    public void settrace(PyObject tracefunc) {
        this.tracefunc = tracefunc == Py.None ? null : new PythonTraceFunction(tracefunc);
    }

    public void setprofile(PyObject profilefunc) {
        this.profilefunc = profilefunc == Py.None ? null : new PythonTraceFunction(profilefunc);
    }

    private final InputStream getSystemIn() {
        if (Options.pollStandardIn) {
            return new PollingInputStream(System.in);
        }
        return System.in;
    }

    public String getdefaultencoding() {
        return codecs.getDefaultEncoding();
    }

    public void setdefaultencoding(String encoding) {
        codecs.setDefaultEncoding(encoding);
    }

    static void displayhook(PyObject o) {
        if (o == Py.None) {
            return;
        }
        PySystemState sys = Py.getThreadState().systemState;
        sys.builtins.__setitem__("_", Py.None);
        Py.stdout.println(o.__repr__());
        sys.builtins.__setitem__("_", o);
    }

    static void excepthook(PyObject type, PyObject val, PyObject tb) {
        Py.displayException(type, val, tb, null);
    }

    public void callExitFunc() throws PyIgnoreMethodTag {
        PyObject exitfunc = this.__findattr__("exitfunc");
        if (exitfunc != null) {
            try {
                exitfunc.__call__();
            }
            catch (PyException exc) {
                if (!Py.matchException(exc, Py.SystemExit)) {
                    Py.println(this.stderr, Py.newString("Error in sys.exitfunc:"));
                }
                Py.printException(exc);
            }
        }
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PySystemState() {
        PySystemState.initialize();
        this.modules = new PyStringMap();
        this.argv = (PyList)defaultArgv.repeat(1);
        this.path = (PyList)defaultPath.repeat(1);
        this.__stdout__ = this.stdout = new PyFile(System.out, "<stdout>");
        this.__stderr__ = this.stderr = new PyFile(System.err, "<stderr>");
        this.__stdin__ = this.stdin = new PyFile(this.getSystemIn(), "<stdin>");
        this.__displayhook__ = new PySystemStateFunctions("displayhook", 10, 1, 1);
        this.__excepthook__ = new PySystemStateFunctions("excepthook", 30, 3, 3);
        this.builtins = __builtin__class.__getattr__("__dict__");
        PyModule __builtin__2 = new PyModule("__builtin__", this.builtins);
        this.modules.__setitem__("__builtin__", (PyObject)__builtin__2);
        if (this.__class__ != null) {
            this.__dict__ = new PyStringMap();
            this.__dict__.invoke("update", this.__class__.__getattr__("__dict__"));
            this.__dict__.__setitem__("displayhook", this.__displayhook__);
            this.__dict__.__setitem__("excepthook", this.__excepthook__);
        }
    }

    static {
        copyright = "Copyright (c) 2000, Jython Developers\nAll rights reserved.\n\nCopyright (c) 2000 BeOpen.com.\nAll Rights Reserved.\n\nCopyright (c) 2000 The Apache Software Foundation.  All rights\nreserved.\n\nCopyright (c) 1995-2000 Corporation for National Research Initiatives.\nAll Rights Reserved.\n\nCopyright (c) 1991-1995 Stichting Mathematisch Centrum, Amsterdam.\nAll Rights Reserved.\n\n";
        platform = "java";
        maxint = Integer.MAX_VALUE;
        minint = Integer.MIN_VALUE;
        exec_prefix = "";
        initialized = false;
        builtin_module_names = null;
    }
}

