/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.PersistentObject;
import cern.colt.matrix.impl.AbstractMatrix1D;
import cern.colt.matrix.impl.AbstractMatrix2D;
import cern.colt.matrix.impl.AbstractMatrix3D;
import cern.colt.matrix.impl.Former;
import cern.colt.matrix.impl.FormerFactory;

public abstract class AbstractFormatter
extends PersistentObject {
    public static final String LEFT = "left";
    public static final String CENTER = "center";
    public static final String RIGHT = "right";
    public static final String DECIMAL = "decimal";
    public static final int DEFAULT_MIN_COLUMN_WIDTH = 1;
    public static final String DEFAULT_COLUMN_SEPARATOR = " ";
    public static final String DEFAULT_ROW_SEPARATOR = "\n";
    public static final String DEFAULT_SLICE_SEPARATOR = "\n\n";
    protected String alignment = "left";
    protected String format = "%G";
    protected int minColumnWidth = 1;
    protected String columnSeparator = " ";
    protected String rowSeparator = "\n";
    protected String sliceSeparator = "\n\n";
    protected boolean printShape = true;
    private static String[] blanksCache;
    protected static final FormerFactory factory;

    protected AbstractFormatter() {
    }

    protected void align(String[][] stringArray) {
        int n;
        int n2 = stringArray.length;
        int n3 = 0;
        if (n2 > 0) {
            n3 = stringArray[0].length;
        }
        int[] nArray = new int[n3];
        int[] nArray2 = null;
        boolean bl = this.alignment.equals(DECIMAL);
        if (bl) {
            nArray2 = new int[n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            n = this.minColumnWidth;
            int n5 = Integer.MIN_VALUE;
            int n6 = 0;
            while (n6 < n2) {
                String string2 = stringArray[n6][n4];
                n = Math.max(n, string2.length());
                if (bl) {
                    n5 = Math.max(n5, this.lead(string2));
                }
                ++n6;
            }
            nArray[n4] = n;
            if (bl) {
                nArray2[n4] = n5;
            }
            ++n4;
        }
        n = 0;
        while (n < n2) {
            this.alignRow(stringArray[n], nArray, nArray2);
            ++n;
        }
    }

    protected int alignmentCode(String string2) {
        if (string2.equals(LEFT)) {
            return -1;
        }
        if (string2.equals(CENTER)) {
            return 0;
        }
        if (string2.equals(RIGHT)) {
            return 1;
        }
        if (string2.equals(DECIMAL)) {
            return 2;
        }
        throw new IllegalArgumentException("unknown alignment: " + string2);
    }

    protected void alignRow(String[] stringArray, int[] nArray, int[] nArray2) {
        int n = this.alignmentCode(this.alignment);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.setLength(0);
            String string2 = stringArray[n3];
            if (this.alignment.equals(RIGHT)) {
                stringBuffer.append(this.blanks(nArray[n3] - stringBuffer.length()));
                stringBuffer.append(string2);
            } else if (this.alignment.equals(DECIMAL)) {
                stringBuffer.append(this.blanks(nArray2[n3] - this.lead(string2)));
                stringBuffer.append(string2);
                stringBuffer.append(this.blanks(nArray[n3] - stringBuffer.length()));
            } else if (this.alignment.equals(CENTER)) {
                stringBuffer.append(this.blanks((nArray[n3] - string2.length()) / 2));
                stringBuffer.append(string2);
                stringBuffer.append(this.blanks(nArray[n3] - stringBuffer.length()));
            } else if (this.alignment.equals(LEFT)) {
                stringBuffer.append(string2);
                stringBuffer.append(this.blanks(nArray[n3] - stringBuffer.length()));
            } else {
                throw new InternalError();
            }
            stringArray[n3] = stringBuffer.toString();
            ++n3;
        }
    }

    protected String blanks(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n < blanksCache.length) {
            return blanksCache[n];
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(' ');
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void demo1() {
    }

    public static void demo2() {
    }

    public static void demo3(int n, Object object) {
    }

    protected abstract String form(AbstractMatrix1D var1, int var2, Former var3);

    protected abstract String[][] format(AbstractMatrix2D var1);

    protected String[] formatRow(AbstractMatrix1D abstractMatrix1D) {
        Former former = null;
        former = factory.create(this.format);
        int n = abstractMatrix1D.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.form(abstractMatrix1D, n2, former);
            ++n2;
        }
        return stringArray;
    }

    protected int lead(String string2) {
        return string2.length();
    }

    protected String repeat(char c, int n) {
        if (c == ' ') {
            return this.blanks(n);
        }
        if (n < 0) {
            n = 0;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void setAlignment(String string2) {
        this.alignment = string2;
    }

    public void setColumnSeparator(String string2) {
        this.columnSeparator = string2;
    }

    public void setFormat(String string2) {
        this.format = string2;
    }

    public void setMinColumnWidth(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.minColumnWidth = n;
    }

    public void setPrintShape(boolean bl) {
        this.printShape = bl;
    }

    public void setRowSeparator(String string2) {
        this.rowSeparator = string2;
    }

    public void setSliceSeparator(String string2) {
        this.sliceSeparator = string2;
    }

    protected static void setupBlanksCache() {
        int n = 40;
        blanksCache = new String[n];
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = n;
        while (--n2 >= 0) {
            stringBuffer.append(' ');
        }
        String string2 = stringBuffer.toString();
        int n3 = n;
        while (--n3 >= 0) {
            AbstractFormatter.blanksCache[n3] = string2.substring(0, n3);
        }
    }

    public static String shape(AbstractMatrix1D abstractMatrix1D) {
        return abstractMatrix1D.size() + " matrix";
    }

    public static String shape(AbstractMatrix2D abstractMatrix2D) {
        return abstractMatrix2D.rows() + " x " + abstractMatrix2D.columns() + " matrix";
    }

    public static String shape(AbstractMatrix3D abstractMatrix3D) {
        return abstractMatrix3D.slices() + " x " + abstractMatrix3D.rows() + " x " + abstractMatrix3D.columns() + " matrix";
    }

    protected String toString(String[][] stringArray) {
        int n = stringArray.length;
        int n2 = stringArray.length <= 0 ? 0 : stringArray[0].length;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n3 = 0;
        while (n3 < n) {
            stringBuffer2.setLength(0);
            int n4 = 0;
            while (n4 < n2) {
                stringBuffer2.append(stringArray[n3][n4]);
                if (n4 < n2 - 1) {
                    stringBuffer2.append(this.columnSeparator);
                }
                ++n4;
            }
            stringBuffer.append((Object)stringBuffer2);
            if (n3 < n - 1) {
                stringBuffer.append(this.rowSeparator);
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    protected String toString(AbstractMatrix2D abstractMatrix2D) {
        String[][] stringArray = this.format(abstractMatrix2D);
        this.align(stringArray);
        StringBuffer stringBuffer = new StringBuffer(this.toString(stringArray));
        if (this.printShape) {
            stringBuffer.insert(0, AbstractFormatter.shape(abstractMatrix2D) + DEFAULT_ROW_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    static {
        factory = new FormerFactory();
        AbstractFormatter.setupBlanksCache();
    }
}

