/*
 * Decompiled with CFR 0.152.
 */
package com.lgc.wsh.inv;

import com.lgc.wsh.inv.LinearTransform;
import com.lgc.wsh.inv.LogMonitor;
import com.lgc.wsh.inv.Monitor;
import com.lgc.wsh.inv.PartialMonitor;
import com.lgc.wsh.inv.QuadraticSolver;
import com.lgc.wsh.inv.ScalarSolver;
import com.lgc.wsh.inv.Transform;
import com.lgc.wsh.inv.TransformQuadratic;
import com.lgc.wsh.inv.Vect;
import com.lgc.wsh.inv.VectConst;
import com.lgc.wsh.inv.VectUtil;
import com.lgc.wsh.util.Almost;
import java.util.logging.Logger;

public class GaussNewtonSolver {
    private static boolean s_expensiveDebug = false;
    private static final Logger LOG = Logger.getLogger("com.lgc.wsh.inv");

    public static Vect solve(VectConst data, VectConst referenceModel, VectConst perturbModel, Transform transform, boolean dampOnlyPerturbation, int conjugateGradIterations, int lineSearchIterations, int linearizationIterations, double lineSearchError, Monitor monitor) {
        if (s_expensiveDebug) {
            VectUtil.test(data);
            VectUtil.test(referenceModel);
            TransformQuadratic tq = new TransformQuadratic(data, referenceModel, perturbModel, transform, dampOnlyPerturbation);
            int precision = tq.getTransposePrecision();
            if (precision < 6) {
                throw new IllegalStateException("Bad transpose precision = " + precision);
            }
            tq.dispose();
        }
        if (monitor == null) {
            monitor = new LogMonitor(null, null);
        }
        monitor.report(0.0);
        Vect m0 = (Vect)referenceModel.clone();
        referenceModel = null;
        m0.constrain();
        if (linearizationIterations < 1) {
            linearizationIterations = 1;
        }
        for (int iter = 0; iter < linearizationIterations; ++iter) {
            double frac = 3.0 * (double)conjugateGradIterations / (3.0 * (double)conjugateGradIterations + (double)lineSearchIterations);
            double begin = (double)iter / (double)linearizationIterations;
            double mid = ((double)iter + frac) / (double)linearizationIterations;
            double end = ((double)iter + 1.0) / (double)linearizationIterations;
            monitor.report(begin);
            TransformQuadratic transformQuadratic = new TransformQuadratic(data, m0, perturbModel, transform, dampOnlyPerturbation);
            QuadraticSolver quadraticSolver = new QuadraticSolver(transformQuadratic);
            Vect perturbation = quadraticSolver.solve(conjugateGradIterations, new PartialMonitor(monitor, begin, mid));
            double pp = perturbation.dot(perturbation);
            if (Almost.FLOAT.zero(pp)) {
                perturbation.dispose();
                transformQuadratic.dispose();
                break;
            }
            double scalar = 1.0;
            if (lineSearchIterations > 0) {
                TransformFunction transformFunction = new TransformFunction(transform, data, m0, perturbation, dampOnlyPerturbation);
                ScalarSolver scalarSolver = new ScalarSolver(transformFunction);
                double scalarMin = 0.0;
                double scalarMax = 1.1;
                double okError = lineSearchError;
                double okFraction = lineSearchError;
                scalar = scalarSolver.solve(scalarMin, scalarMax, okError, okFraction, lineSearchIterations, new PartialMonitor(monitor, mid, end));
                transformFunction.dispose();
            }
            m0.project(1.0, scalar, perturbation);
            m0.constrain();
            perturbation.dispose();
            transformQuadratic.dispose();
            monitor.report(end);
        }
        monitor.report(1.0);
        return m0;
    }

    public static Vect solve(VectConst data, VectConst referenceModel, LinearTransform linearTransform, boolean dampOnlyPerturbation, int conjugateGradIterations, Monitor monitor) {
        boolean linearizationIterations = true;
        boolean lineSearchIterations = false;
        double lineSearchError = 0.0;
        LinearTransformWrapper transform = new LinearTransformWrapper(linearTransform);
        return GaussNewtonSolver.solve(data, referenceModel, null, transform, dampOnlyPerturbation, conjugateGradIterations, 0, 1, 0.0, monitor);
    }

    public static void setExpensiveDebug(boolean debug) {
        s_expensiveDebug = debug;
    }

    public static class LinearTransformWrapper
    implements Transform {
        private LinearTransform _linearTransform = null;

        public LinearTransformWrapper(LinearTransform linearTransform) {
            this._linearTransform = linearTransform;
        }

        public void forwardNonlinear(Vect data, VectConst model) {
            this._linearTransform.forward(data, model);
        }

        public void forwardLinearized(Vect data, VectConst model, VectConst modelReference) {
            this._linearTransform.forward(data, model);
        }

        public void addTranspose(VectConst data, Vect model, VectConst modelReference) {
            this._linearTransform.addTranspose(data, model);
        }

        public void inverseHessian(Vect model, VectConst modelReference) {
            this._linearTransform.inverseHessian(model);
        }

        public void adjustRobustErrors(Vect dataError) {
            this._linearTransform.adjustRobustErrors(dataError);
        }
    }

    private static class TransformFunction
    implements ScalarSolver.Function {
        Transform _transform;
        VectConst _data;
        VectConst _referenceModel;
        VectConst _perturbation;
        Vect _model;
        TransformQuadratic _transformQuadratic;

        public TransformFunction(Transform transform, VectConst data, VectConst referenceModel, VectConst perturbation, boolean dampOnlyPerturbation) {
            this._transform = transform;
            this._data = data;
            this._referenceModel = referenceModel;
            this._model = (Vect)this._referenceModel.clone();
            this._perturbation = perturbation;
            this._transformQuadratic = new TransformQuadratic(data, referenceModel, null, transform, dampOnlyPerturbation);
        }

        public double function(double scalar) {
            VectUtil.copy(this._model, this._referenceModel);
            this._model.project(1.0, scalar, this._perturbation);
            double result = this._transformQuadratic.evalFullObjectiveFunction(this._model);
            return result;
        }

        public void dispose() {
            this._model.dispose();
        }
    }
}

