/*
 * Decompiled with CFR 0.152.
 */
package com.lgc.wsh.inv;

import com.lgc.wsh.inv.Monitor;
import java.util.Date;
import java.util.logging.Logger;

public class LogMonitor
implements Monitor {
    private double _lastFraction = -1.0;
    private Logger _log = null;
    private String _prefix = "";
    private long _time = 0L;
    private long _lastTime = 0L;
    private static final Logger LOG = Logger.getLogger(LogMonitor.class.getPackage().getName());

    public LogMonitor(String prefix, Logger logger) {
        this._log = logger;
        if (prefix != null) {
            this._prefix = prefix;
        }
    }

    public void report(double fraction) {
        if (fraction < this._lastFraction - 0.001) {
            throw new IllegalStateException("Progress cannot decrease from " + this._lastFraction + " to " + fraction);
        }
        if (this._time == 0L) {
            this._time = System.currentTimeMillis();
        }
        long time2 = 0L;
        if (fraction > this._lastFraction + 0.02 && (time2 = System.currentTimeMillis()) > this._lastTime + 10000L || fraction == 1.0 && fraction > this._lastFraction && (time2 = System.currentTimeMillis()) > 0L) {
            String progress = "";
            if (this._lastFraction >= 0.0 && fraction > 0.01) {
                long secSoFar = (long)((double)(time2 - this._time) / 1000.0);
                long secRemaining = (long)((1.0 / fraction - 1.0) * ((double)(time2 - this._time) / 1000.0));
                long total = secSoFar + secRemaining;
                progress = LogMonitor.time(secSoFar);
                if (progress.length() > 0) {
                    progress = progress + " so far";
                }
                if (secRemaining > 0L) {
                    String remaining = LogMonitor.time(secRemaining) + " remaining";
                    progress = progress.length() > 0 ? remaining + ", " + progress : remaining;
                }
                if (progress.length() > 0) {
                    progress = "\n  " + progress + ", " + LogMonitor.time(total) + " total";
                }
                if (fraction >= 1.0) {
                    progress = "\n  Finished in " + LogMonitor.time(total) + " total";
                }
            }
            if (this._log != null) {
                this._log.info(this._prefix + " progress: " + (int)(100.0 * fraction + 0.49) + "% complete at " + new Date() + progress);
            }
            this._lastFraction = fraction;
            this._lastTime = time2;
        }
    }

    private static String time(long seconds) {
        if (seconds == 0L) {
            return "";
        }
        String result = "";
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        if ((seconds %= 60L) != 0L) {
            result = " " + seconds + " second" + (seconds > 1L ? "s" : "") + result;
        }
        if (minutes != 0L) {
            result = " " + minutes + " minute" + (minutes > 1L ? "s" : "") + result;
        }
        if (hours != 0L) {
            result = " " + hours + " hour" + (hours > 1L ? "s" : "") + result;
        }
        return result.trim();
    }

    public static void main(String[] a) throws Exception {
        LogMonitor monitor = new LogMonitor("Test", LOG);
        int n = 300;
        for (int i = 0; i < n; ++i) {
            monitor.report((double)i / ((double)n - 1.0));
            Thread.sleep(25L);
        }
    }
}

