/*
 * Decompiled with CFR 0.152.
 */
package com.lgc.wsh.inv;

import com.lgc.wsh.inv.Transform;
import com.lgc.wsh.inv.TransformQuadratic;
import com.lgc.wsh.inv.Vect;
import com.lgc.wsh.inv.VectConst;
import com.lgc.wsh.util.Almost;
import com.lgc.wsh.util.LoggerStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VectUtil {
    private static final Logger LOG = Logger.getLogger(VectUtil.class.getPackage().getName());
    static final Almost ALMOST_DOT = new Almost(1.5E-5);

    public static void scale(Vect v, double scalar) {
        v.add(scalar, 0.0, v);
    }

    public static void zero(Vect v) {
        VectUtil.scale(v, 0.0);
    }

    public static void copy(Vect to, VectConst from) {
        to.add(0.0, 1.0, from);
    }

    public static Vect cloneZero(VectConst v) {
        Vect result = (Vect)v.clone();
        VectUtil.zero(result);
        return result;
    }

    public static boolean areSame(VectConst v1, VectConst v2) {
        double aa = v1.dot(v1);
        double ab = v1.dot(v2);
        double bb = v2.dot(v2);
        return ALMOST_DOT.equal(aa, bb) && ALMOST_DOT.equal(aa, ab) && ALMOST_DOT.equal(ab, bb);
    }

    public static void test(VectConst vect) {
        double originalDot = vect.dot(vect);
        VectUtil.ass(!Almost.FLOAT.zero(originalDot), "cannot test a zero vector");
        Vect t = VectUtil.cloneZero(vect);
        VectUtil.ass(Almost.FLOAT.zero(t.dot(t)), "cloneZero() did not work");
        VectUtil.copy(t, vect);
        double check = t.dot(vect) / vect.dot(vect);
        VectUtil.ass(Almost.FLOAT.equal(check, 1.0), "not 1. check=" + check);
        VectUtil.scale(t, 0.5);
        check = t.dot(vect) / vect.dot(vect);
        VectUtil.ass(Almost.FLOAT.equal(check, 0.5), "not 0.5 check=" + check);
        t.add(1.0, 1.0, vect);
        check = t.dot(vect) / vect.dot(vect);
        VectUtil.ass(Almost.FLOAT.equal(check, 1.5), "not 1.5 check=" + check);
        t.add(2.0, -5.0, vect);
        check = t.dot(vect) / vect.dot(vect);
        VectUtil.ass(Almost.FLOAT.equal(check, -2.0), "not -2, check=" + check);
        t.project(0.0, 1.0, vect);
        t.project(1.75, -0.75, vect);
        VectUtil.ass(VectUtil.areSame(t, vect), "project failed");
        t.dispose();
        VectUtil.ass(Almost.FLOAT.equal(originalDot, vect.dot(vect)), "exercise of clone damaged original");
        t = (Vect)vect.clone();
        t.multiplyInverseCovariance();
        double mag1 = vect.dot(t);
        double mag2 = vect.magnitude();
        VectUtil.ass(Almost.FLOAT.equal(mag1, mag2), "magnitude() inconsistent with multiplyInverseCovariance() and dot(): " + mag1 + "!=" + mag2);
        VectUtil.ass(mag1 > 0.0, "inverse covariance gave zero magnitude");
        VectUtil.ass(mag2 > 0.0, "magnitude was zero when dot product was not zero");
        t.dispose();
        byte[] data = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            t = (Vect)vect.clone();
            oos.writeObject(t);
            oos.flush();
            oos.close();
            t.dispose();
            t = null;
            data = baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace(new LoggerStream(LOG, Level.SEVERE));
            VectUtil.ass(false, "writing serialization failed " + e.getMessage());
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ObjectInputStream ois = new ObjectInputStream(bais);
            t = (Vect)ois.readObject();
            VectUtil.ass(VectUtil.areSame(t, vect), "Serialization did not preserve Vect " + t.dot(t) + "==" + t.dot(vect) + "==" + vect.dot(vect));
            VectUtil.scale(t, 0.5);
            double tt = t.dot(t);
            double tv = t.dot(vect);
            double vv = vect.dot(vect);
            VectUtil.ass(tt > 0.0, "Scaling set serialized vect to zero magnitude");
            VectUtil.ass(Almost.FLOAT.equal(tt * 2.0, tv), "Serialized vector does not have independent magnitude tt=" + tt + " tv=" + tv);
            VectUtil.ass(Almost.FLOAT.equal(tv * 2.0, vv), "serialized vector does not have independent magnitude tv=" + tv + " vv=" + vv);
            t.dispose();
        }
        catch (IOException e) {
            e.printStackTrace(new LoggerStream(LOG, Level.SEVERE));
            VectUtil.ass(false, "reading serialization failed " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace(new LoggerStream(LOG, Level.SEVERE));
            VectUtil.ass(false, "Can't find class just written " + e.getMessage());
        }
    }

    public static int getTransposePrecision(VectConst data, VectConst model, Transform transform) {
        int precision = 200;
        boolean dampOnlyPerturbation = true;
        VectUtil.test(data);
        VectUtil.test(model);
        TransformQuadratic tq = new TransformQuadratic(data, model, null, transform, dampOnlyPerturbation);
        precision = Math.min(precision, tq.getTransposePrecision());
        return precision;
    }

    private static void ass(boolean condition, String requirement) {
        if (!condition) {
            throw new IllegalStateException(requirement);
        }
    }
}

