/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss.lookup;

import com.wcohen.ss.BasicDistanceInstanceIterator;
import com.wcohen.ss.BasicStringWrapper;
import com.wcohen.ss.BasicStringWrapperIterator;
import com.wcohen.ss.JaroWinklerTFIDF;
import com.wcohen.ss.api.DistanceInstance;
import com.wcohen.ss.api.DistanceInstanceIterator;
import com.wcohen.ss.api.StringDistance;
import com.wcohen.ss.api.StringDistanceLearner;
import com.wcohen.ss.api.StringDistanceTeacher;
import com.wcohen.ss.api.StringWrapper;
import com.wcohen.ss.api.StringWrapperIterator;
import com.wcohen.ss.api.Token;
import com.wcohen.ss.api.Tokenizer;
import com.wcohen.ss.tokens.NGramTokenizer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class SoftDictionary {
    private static final boolean DEBUG = false;
    private StringDistanceLearner distanceLearner;
    private StringDistance distance;
    private Tokenizer tokenizer;
    private Map index;
    private Map map;
    private Map idMap;
    private int totalEntries;
    private double maxFraction = 1.0;
    private HashSet closeMatches;
    private MyWrapper closestMatch;
    private double distanceToClosestMatch;
    private StringWrapper lastLookup;

    public SoftDictionary() {
        this(new JaroWinklerTFIDF(), NGramTokenizer.DEFAULT_TOKENIZER);
    }

    public SoftDictionary(StringDistanceLearner distanceLearner) {
        this(distanceLearner, NGramTokenizer.DEFAULT_TOKENIZER);
    }

    public SoftDictionary(Tokenizer tokenizer) {
        this(new JaroWinklerTFIDF(), tokenizer);
    }

    public SoftDictionary(StringDistanceLearner distanceLearner, Tokenizer tokenizer) {
        this.distanceLearner = distanceLearner;
        this.distance = null;
        this.tokenizer = tokenizer;
        this.index = new HashMap();
        this.map = new HashMap();
        this.idMap = new HashMap();
        this.totalEntries = 0;
    }

    public int size() {
        return this.totalEntries;
    }

    public StringWrapper prepare(String s) {
        return new MyWrapper(s);
    }

    public void load(File file) throws IOException, FileNotFoundException {
        this.load(file, false);
    }

    public void load(File file, boolean ids) throws IOException, FileNotFoundException {
        String line;
        LineNumberReader in = new LineNumberReader(new FileReader(file));
        while ((line = in.readLine()) != null) {
            if (ids) {
                this.put(Integer.toString(in.getLineNumber()), line, (Object)line);
                continue;
            }
            this.put(line, line);
        }
        in.close();
    }

    public void loadAliases(File file) throws IOException, FileNotFoundException {
        String line;
        LineNumberReader in = new LineNumberReader(new FileReader(file));
        while ((line = in.readLine()) != null) {
            String[] parts = line.split("\\t");
            for (int j = 1; j < parts.length; ++j) {
                this.put(parts[j], parts[j], (Object)parts[0]);
            }
        }
        in.close();
    }

    public void put(String id, String string2, Object value) {
        this.put(id, new MyWrapper(string2), value);
    }

    public void put(String string2, Object value) {
        this.put((String)null, new MyWrapper(string2), value);
    }

    public void put(String id, StringWrapper toInsert, Object value) {
        MyWrapper wrapper = this.asMyWrapper(toInsert);
        Token[] tokens = wrapper.getTokens();
        for (int i = 0; i < tokens.length; ++i) {
            ArrayList<MyWrapper> stringsWithToken = (ArrayList<MyWrapper>)this.index.get(tokens[i]);
            if (stringsWithToken == null) {
                stringsWithToken = new ArrayList<MyWrapper>();
                this.index.put(tokens[i], stringsWithToken);
            }
            stringsWithToken.add(wrapper);
        }
        this.map.put(wrapper, value);
        if (id != null) {
            this.idMap.put(wrapper, id);
        }
        this.distance = null;
        ++this.totalEntries;
    }

    private void doLookup(String id, StringWrapper toFind) {
        if (this.distance == null) {
            this.distance = new MyTeacher().train(this.distanceLearner);
        }
        if (this.lastLookup == toFind) {
            return;
        }
        this.closeMatches = new HashSet();
        this.closestMatch = null;
        this.distanceToClosestMatch = -1.7976931348623157E308;
        MyWrapper wrapper = this.asMyWrapper(toFind);
        Token[] tokens = wrapper.getTokens();
        for (int i = 0; i < tokens.length; ++i) {
            ArrayList stringsWithToken = (ArrayList)this.index.get(tokens[i]);
            if (stringsWithToken == null || !((double)stringsWithToken.size() / (double)this.totalEntries < this.maxFraction)) continue;
            for (MyWrapper wj : stringsWithToken) {
                String wjId = (String)this.idMap.get(wj);
                if (this.closeMatches.contains(wj) || wjId != null && wjId.equals(id)) continue;
                double score = this.distance.score(wrapper.getDistanceWrapper(), wj.getDistanceWrapper());
                this.closeMatches.add(wj);
                if (!(score >= this.distanceToClosestMatch)) continue;
                this.distanceToClosestMatch = score;
                this.closestMatch = wj;
            }
        }
        this.lastLookup = toFind;
    }

    public Object lookup(String id, String toFind) {
        return this.lookup(id, new MyWrapper(toFind));
    }

    public Object lookup(String id, StringWrapper toFind) {
        this.doLookup(id, toFind);
        return this.closestMatch;
    }

    public double lookupDistance(String id, String toFind) {
        return this.lookupDistance(id, new MyWrapper(toFind));
    }

    public double lookupDistance(String id, StringWrapper toFind) {
        this.doLookup(id, toFind);
        return this.distanceToClosestMatch;
    }

    public Object lookup(String toFind) {
        return this.lookup(null, new MyWrapper(toFind));
    }

    public Object lookup(StringWrapper toFind) {
        this.doLookup(null, toFind);
        return this.closestMatch;
    }

    public double lookupDistance(String toFind) {
        return this.lookupDistance(null, new MyWrapper(toFind));
    }

    public double lookupDistance(StringWrapper toFind) {
        this.doLookup(null, toFind);
        return this.distanceToClosestMatch;
    }

    public StringDistanceTeacher getTeacher() {
        return new MyTeacher();
    }

    private MyWrapper asMyWrapper(StringWrapper w) {
        if (w instanceof MyWrapper) {
            return (MyWrapper)w;
        }
        return new MyWrapper(w.unwrap());
    }

    public static void main(String[] argv) throws IOException, FileNotFoundException {
        SoftDictionary m = new SoftDictionary();
        System.out.println("loading...");
        m.loadAliases(new File(argv[0]));
        System.out.println("loaded...");
        for (int i = 1; i < argv.length; ++i) {
            System.out.println("lookup: " + argv[i]);
            String[] f = argv[i].split(":");
            if (f.length == 1) {
                System.out.println(argv[i] + " => " + m.lookup(argv[i]) + " at " + m.lookupDistance(argv[i]));
                continue;
            }
            System.out.println(f[1] + " => " + m.lookup(f[0], f[1]) + " at " + m.lookupDistance(f[0], f[1]));
        }
    }

    private class MyTeacher
    extends StringDistanceTeacher {
        private MyTeacher() {
        }

        protected StringWrapperIterator stringWrapperIterator() {
            return new BasicStringWrapperIterator(SoftDictionary.this.map.keySet().iterator());
        }

        protected DistanceInstanceIterator distanceInstancePool() {
            return new BasicDistanceInstanceIterator(Collections.EMPTY_SET.iterator());
        }

        protected DistanceInstanceIterator distanceExamplePool() {
            return new BasicDistanceInstanceIterator(Collections.EMPTY_SET.iterator());
        }

        protected DistanceInstance labelInstance(DistanceInstance distanceInstance) {
            return null;
        }

        protected boolean hasAnswers() {
            return false;
        }
    }

    private class MyWrapper
    implements StringWrapper {
        private StringWrapper w;
        private Token[] tokens;

        public MyWrapper(String s) {
            this.w = this.prepare(s);
            this.tokens = SoftDictionary.this.tokenizer.tokenize(s);
        }

        public String unwrap() {
            return this.w.unwrap();
        }

        public char charAt(int i) {
            return this.w.charAt(i);
        }

        public int length() {
            return this.w.length();
        }

        public Token[] getTokens() {
            return this.tokens;
        }

        public StringWrapper getDistanceWrapper() {
            return this.w;
        }

        public int hashCode() {
            return this.unwrap().hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof MyWrapper)) {
                return false;
            }
            return ((MyWrapper)o).unwrap().equals(this.unwrap());
        }

        private StringWrapper prepare(String s) {
            StringWrapperIterator i = SoftDictionary.this.distanceLearner.prepare(new BasicStringWrapperIterator(Collections.singleton(new BasicStringWrapper(s)).iterator()));
            return i.nextStringWrapper();
        }

        public String toString() {
            return "[SoftDictionaryWrapper '" + this.unwrap() + "']";
        }
    }
}

