/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify;

import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.DatasetLoader;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.FeatureFactory;
import edu.cmu.minorthird.classify.GUI;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.SampleDatasets;
import edu.cmu.minorthird.classify.Splitter;
import edu.cmu.minorthird.util.Saveable;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import edu.cmu.minorthird.util.gui.Visible;
import edu.cmu.minorthird.util.gui.ZoomedViewer;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDataset
implements Dataset,
Serializable,
Visible,
Saveable {
    static final long serialVersionUID = 20080118L;
    protected FeatureFactory featureFactory;
    protected List<Example> examples;
    protected List<Instance> unlabeledExamples;
    protected Set<String> classNameSet;
    private static final String FORMAT_NAME = "Minorthird Dataset";

    public BasicDataset(FeatureFactory featureFactory) {
        this.featureFactory = featureFactory;
        this.examples = new ArrayList<Example>();
        this.unlabeledExamples = new ArrayList<Instance>();
        this.classNameSet = new TreeSet<String>();
    }

    public BasicDataset() {
        this(new FeatureFactory());
    }

    @Override
    public ExampleSchema getSchema() {
        ExampleSchema schema = new ExampleSchema(this.classNameSet.toArray(new String[this.classNameSet.size()]));
        if (schema.equals(ExampleSchema.BINARY_EXAMPLE_SCHEMA)) {
            return ExampleSchema.BINARY_EXAMPLE_SCHEMA;
        }
        return schema;
    }

    public void addUnlabeled(Instance instance) {
        this.unlabeledExamples.add(this.featureFactory.compress(instance));
    }

    public Iterator<Instance> iteratorOverUnlabeled() {
        return this.unlabeledExamples.iterator();
    }

    public int sizeUnlabeled() {
        return this.unlabeledExamples.size();
    }

    public boolean hasUnlabeled() {
        return this.unlabeledExamples.size() > 0;
    }

    @Override
    public FeatureFactory getFeatureFactory() {
        return this.featureFactory;
    }

    @Override
    public void add(Example example) {
        this.add(example, true);
    }

    @Override
    public void add(Example example, boolean compress) {
        if (compress) {
            this.examples.add(this.featureFactory.compress(example));
        } else {
            this.examples.add(example);
        }
        this.classNameSet.addAll(example.getLabel().possibleLabels());
    }

    @Override
    public Iterator<Example> iterator() {
        return this.examples.iterator();
    }

    @Override
    public int size() {
        return this.examples.size();
    }

    @Override
    public void shuffle(Random r) {
        Collections.shuffle(this.examples, r);
    }

    @Override
    public void shuffle() {
        this.shuffle(new Random());
    }

    @Override
    public Dataset shallowCopy() {
        BasicDataset copy2 = new BasicDataset();
        Iterator<Example> i = this.iterator();
        while (i.hasNext()) {
            copy2.add(i.next());
        }
        return copy2;
    }

    @Override
    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    @Override
    public String getExtensionFor(String s) {
        return ".data";
    }

    @Override
    public void saveAs(File file, String format) throws IOException {
        if (!format.equals(FORMAT_NAME)) {
            throw new IllegalArgumentException("illegal format: " + format);
        }
        DatasetLoader.save(this, file);
    }

    @Override
    public Object restore(File file) throws IOException {
        try {
            return DatasetLoader.loadFile(file);
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException("error loading from " + file + ": " + ex);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("");
        Iterator<Example> i = this.iterator();
        while (i.hasNext()) {
            Example ex = i.next();
            buf.append(ex.toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    @Override
    public Viewer toGUI() {
        SimpleDatasetViewer dbGui = new SimpleDatasetViewer();
        dbGui.setContent(this);
        Viewer instGui = GUI.newSourcedExampleViewer();
        return new ZoomedViewer(dbGui, instGui);
    }

    @Override
    public Dataset.Split split(final Splitter<Example> splitter) {
        splitter.split(this.examples.iterator());
        return new Dataset.Split(){

            public int getNumPartitions() {
                return splitter.getNumPartitions();
            }

            public Dataset getTrain(int k) {
                return BasicDataset.this.invertIteration(splitter.getTrain(k));
            }

            public Dataset getTest(int k) {
                return BasicDataset.this.invertIteration(splitter.getTest(k));
            }
        };
    }

    private Dataset invertIteration(Iterator<Example> i) {
        BasicDataset copy2 = new BasicDataset();
        while (i.hasNext()) {
            copy2.add(i.next());
        }
        return copy2;
    }

    public static void main(String[] args) {
        try {
            BasicDataset data = (BasicDataset)SampleDatasets.sampleData("toy", false);
            new ViewerFrame("Toy Dataset", data.toGUI());
            System.out.println(data.getSchema());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class SimpleDatasetViewer
    extends ComponentViewer {
        static final long serialVersionUID = 20071015L;

        public boolean canReceive(Object o) {
            return o instanceof Dataset;
        }

        public JComponent componentFor(Object o) {
            Dataset d = (Dataset)o;
            final Example[] tmp = new Example[d.size()];
            int k = 0;
            Iterator<Example> i = d.iterator();
            while (i.hasNext()) {
                tmp[k++] = i.next();
            }
            JList<Example> jList = new JList<Example>(tmp);
            jList.setCellRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList el, Object v, int index, boolean sel, boolean focus) {
                    return GUI.conciseExampleRendererComponent(tmp[index], 60, sel);
                }
            });
            this.monitorSelections(jList);
            return new JScrollPane(jList);
        }
    }
}

