/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Example;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class ExampleSchema
implements Serializable {
    static final long serialVersionUID = 20071015L;
    public static final String POS_CLASS_NAME = "POS";
    public static final String NEG_CLASS_NAME = "NEG";
    public static final ExampleSchema BINARY_EXAMPLE_SCHEMA = new ExampleSchema(new String[]{"POS", "NEG"});
    private String[] validClassNames;
    private Set<String> validClassNameSet;

    public ExampleSchema(String[] validClassNames) {
        this.validClassNames = validClassNames;
        this.validClassNameSet = new HashSet<String>();
        for (int i = 0; i < validClassNames.length; ++i) {
            this.validClassNameSet.add(validClassNames[i]);
        }
    }

    public void extend(String newClassName) {
        String[] newValidClassNames = new String[this.validClassNames.length + 1];
        for (int i = 0; i < this.validClassNames.length; ++i) {
            newValidClassNames[i] = this.validClassNames[i];
        }
        newValidClassNames[this.validClassNames.length] = newClassName;
        this.validClassNames = newValidClassNames;
        this.validClassNameSet.add(newClassName);
    }

    public String[] validClassNames() {
        return this.validClassNames;
    }

    public int getNumberOfClasses() {
        return this.validClassNames.length;
    }

    public String getClassName(int i) {
        return this.validClassNames[i];
    }

    public int getClassIndex(String name) {
        for (int i = 0; i < this.validClassNames.length; ++i) {
            if (!this.validClassNames[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    public boolean isValid(ClassLabel label) {
        for (String l : label.possibleLabels()) {
            if (this.validClassNameSet.contains(l)) continue;
            return false;
        }
        return true;
    }

    public boolean isValid(Example e) {
        return this.isValid(e.getLabel());
    }

    public boolean equals(Object o) {
        if (o instanceof ExampleSchema) {
            ExampleSchema b = (ExampleSchema)o;
            return ((Object)this.validClassNameSet).equals(b.validClassNameSet);
        }
        return false;
    }

    public String toString() {
        return "[ExampleSchema: " + this.validClassNameSet + "]";
    }
}

