/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify;

import edu.cmu.minorthird.classify.AbstractInstance;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.WeightedSet;
import edu.cmu.minorthird.util.UnionIterator;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableInstance
extends AbstractInstance {
    private Set<Feature> binarySet = new TreeSet<Feature>();
    private WeightedSet<Feature> numericSet = new WeightedSet();

    public MutableInstance(Object source, String subpopulationId) {
        this.source = source;
        this.subpopulationId = subpopulationId;
    }

    public MutableInstance(Object source) {
        this(source, null);
    }

    public MutableInstance() {
        this("_unknownSource_");
    }

    public void addNumeric(Feature feature, double value) {
        this.binarySet.remove(feature);
        this.numericSet.add(feature, value);
    }

    public void addBinary(Feature feature) {
        this.binarySet.add(feature);
    }

    @Override
    public double getWeight(Feature feature) {
        if (this.binarySet.contains(feature)) {
            return 1.0;
        }
        return this.numericSet.getWeight(feature);
    }

    @Override
    public Iterator<Feature> binaryFeatureIterator() {
        return this.binarySet.iterator();
    }

    @Override
    public Iterator<Feature> numericFeatureIterator() {
        return this.numericSet.iterator();
    }

    @Override
    public Iterator<Feature> featureIterator() {
        return new UnionIterator<Feature>(this.binaryFeatureIterator(), this.numericFeatureIterator());
    }

    @Override
    public int numFeatures() {
        return this.binarySet.size() + this.numericSet.size();
    }

    public static void main(String[] args) {
        try {
            MutableInstance instance = new MutableInstance("William Cohen");
            instance.addBinary(new Feature("token lc william"));
            instance.addBinary(new Feature("token lc cohen"));
            instance.addNumeric(new Feature("iq"), 250.0);
            instance.addNumeric(new Feature("office"), 5317.0);
            System.out.println(instance);
            new ViewerFrame("TestInstance Viewer", instance.toGUI());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

