/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.linear;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Explanation;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.MutableInstance;
import edu.cmu.minorthird.classify.OnlineBinaryClassifierLearner;
import edu.cmu.minorthird.classify.algorithms.linear.Hyperplane;
import edu.cmu.minorthird.classify.algorithms.linear.Winnow;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.TransformedViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.Visible;
import java.io.Serializable;
import java.util.Iterator;

public class BalancedWinnow
extends OnlineBinaryClassifierLearner
implements Serializable {
    static final long serialVersionUID = 20080128L;
    private Hyperplane pos_t;
    private Hyperplane neg_t;
    private Hyperplane vpos_t;
    private Hyperplane vneg_t;
    private double theta = 1.0;
    private double alpha;
    private double beta;
    private int excount;
    private int votedCount;
    private double margin = 0.0;
    private boolean voted = false;
    private double W_MAX = Math.pow(2.0, 200.0);
    private double W_MIN = 1.0 / Math.pow(2.0, 200.0);

    public BalancedWinnow() {
        this(1.5, 0.5, false);
    }

    public BalancedWinnow(boolean voted) {
        this(1.5, 0.5, voted);
    }

    public BalancedWinnow(double a, double b, boolean voted) {
        if (a < 1.0 || b < 0.0 || b > 1.0) {
            System.out.println("Error in BalancedWinnow initial parameters");
            System.out.println("This should never happen: (theta<0)||(alpha < 1)||(beta<0)||(beta>1)");
            System.exit(0);
        }
        this.alpha = a;
        this.beta = b;
        this.voted = voted;
        this.reset();
    }

    public void reset() {
        this.pos_t = new Hyperplane();
        this.neg_t = new Hyperplane();
        this.excount = 0;
        if (this.voted) {
            this.votedCount = 0;
            this.vpos_t = new Hyperplane();
            this.vneg_t = new Hyperplane();
        }
    }

    public void addExample(Example example2) {
        double y_t_hat;
        ++this.excount;
        Example example = Winnow.normalizeWeights(example2, true);
        Iterator<Feature> j = example.asInstance().featureIterator();
        while (j.hasNext()) {
            Feature f = j.next();
            if (this.pos_t.hasFeature(f)) continue;
            this.pos_t.increment(f, 2.0);
            this.neg_t.increment(f, 1.0);
        }
        double y_t = example.getLabel().numericLabel();
        if (y_t * (y_t_hat = this.localscore(example.asInstance())) <= this.margin) {
            if (this.voted) {
                if (this.votedCount == 0) {
                    this.updateVotedHyperplane(1.0);
                } else {
                    this.updateVotedHyperplane(this.votedCount);
                }
                this.votedCount = 1;
            }
            if (example.getLabel().isPositive()) {
                Iterator<Feature> j2 = example.featureIterator();
                while (j2.hasNext()) {
                    Feature f = j2.next();
                    if (this.pos_t.featureScore(f) < this.W_MAX) {
                        this.pos_t.multiply(f, this.alpha);
                    }
                    if (!(this.neg_t.featureScore(f) > this.W_MIN)) continue;
                    this.neg_t.multiply(f, this.beta);
                }
            } else {
                Iterator<Feature> j3 = example.featureIterator();
                while (j3.hasNext()) {
                    Feature f = j3.next();
                    if (this.pos_t.featureScore(f) > this.W_MIN) {
                        this.pos_t.multiply(f, this.beta);
                    }
                    if (!(this.neg_t.featureScore(f) < this.W_MAX)) continue;
                    this.neg_t.multiply(f, this.alpha);
                }
            }
        } else {
            ++this.votedCount;
        }
    }

    public void updateVotedHyperplane(double count) {
        this.vpos_t.increment(this.pos_t, count);
        this.vneg_t.increment(this.neg_t, count);
        this.votedCount = 0;
    }

    public Classifier getClassifier() {
        if (this.voted) {
            this.updateVotedHyperplane(this.votedCount);
            Hyperplane zpos = new Hyperplane();
            Hyperplane zneg = new Hyperplane();
            zpos.increment(this.vpos_t, 1.0 / (double)this.excount);
            zneg.increment(this.vneg_t, 1.0 / (double)this.excount);
            return new MyClassifier(zpos, zneg, this.theta);
        }
        return new MyClassifier(this.pos_t, this.neg_t, this.theta);
    }

    public double localscore(Instance ins) {
        return this.pos_t.score(ins) - this.neg_t.score(ins) - this.theta;
    }

    public String toString() {
        return "BalancedWinnow, voted=" + this.voted;
    }

    public static void main(String[] args) {
        BalancedWinnow mywinnow = new BalancedWinnow();
        ClassLabel c = ClassLabel.positiveLabel(1.0);
        MutableInstance instance = new MutableInstance();
        instance.addNumeric(new Feature("f2"), 2.0);
        instance.addNumeric(new Feature("f3"), 3.0);
        instance.addNumeric(new Feature("f4"), 4.0);
        Example ex = new Example(instance, c);
        mywinnow.addExample(ex);
        Classifier hp = mywinnow.getClassifier();
        System.out.println("BWinnow Hyperplane = " + hp.toString());
        ClassLabel c1 = ClassLabel.negativeLabel(-1.0);
        MutableInstance instance1 = new MutableInstance();
        instance1.addNumeric(new Feature("f3"), 1.0);
        instance1.addNumeric(new Feature("f4"), 2.0);
        instance1.addNumeric(new Feature("f5"), 3.0);
        Example ex1 = new Example(instance1, c1);
        mywinnow.addExample(ex1);
        hp = mywinnow.getClassifier();
        System.out.println("BalancedWinnow Hyperplane = " + hp.toString());
        ClassLabel c2 = ClassLabel.positiveLabel(1.0);
        MutableInstance instance2 = new MutableInstance();
        instance2.addNumeric(new Feature("f3"), -5.0);
        instance2.addNumeric(new Feature("f4"), -12.0);
        instance2.addNumeric(new Feature("f5"), -34.0);
        Example ex2 = new Example(instance2, c2);
        mywinnow.addExample(ex2);
        hp = mywinnow.getClassifier();
        System.out.println("BalancedWinnow Hyperplane = " + hp.toString());
        ClassLabel c3 = ClassLabel.positiveLabel(1.0);
        MutableInstance instance3 = new MutableInstance();
        instance3.addNumeric(new Feature("f3"), -5.0);
        instance3.addNumeric(new Feature("f4"), -12.0);
        instance3.addNumeric(new Feature("f5"), -34.0);
        instance.addNumeric(new Feature("f2"), -2.0);
        Example ex3 = new Example(instance3, c3);
        mywinnow.addExample(ex3);
        hp = mywinnow.getClassifier();
        System.out.println("BWinnow Hyperplane = " + hp.toString());
    }

    public class MyClassifier
    implements Classifier,
    Serializable,
    Visible {
        private static final long serialVersionUID = 20080128L;
        private Hyperplane pos_h;
        private Hyperplane neg_h;
        private double mytheta;

        public MyClassifier(Hyperplane pos_h, Hyperplane neg_h, double mytheta) {
            this.pos_h = pos_h;
            this.neg_h = neg_h;
            this.mytheta = mytheta;
        }

        public ClassLabel classification(Instance instance1) {
            Example a1 = new Example(instance1, new ClassLabel("POS"));
            Example aa = this.filterFeat(a1);
            Example example1 = Winnow.normalizeWeights(aa, true);
            Instance instance = example1.asInstance();
            double dec = this.pos_h.score(instance) - this.neg_h.score(instance) - this.mytheta;
            return dec >= 0.0 ? ClassLabel.positiveLabel(dec) : ClassLabel.negativeLabel(dec);
        }

        public Example filterFeat(Example ex) {
            MutableInstance ins = new MutableInstance();
            Iterator<Feature> i = ex.asInstance().featureIterator();
            while (i.hasNext()) {
                Feature f = i.next();
                if (!this.pos_h.hasFeature(f)) continue;
                ins.addNumeric(f, ex.getWeight(f));
            }
            return new Example(ins, ex.getLabel());
        }

        public String toString() {
            return "POS = " + this.pos_h.toString() + "\nNEG = " + this.neg_h.toString();
        }

        public String explain(Instance instance) {
            return "BalancedWinnow: Not implemented yet";
        }

        public Explanation getExplanation(Instance instance) {
            Explanation.Node top = new Explanation.Node("BalancedWinnow Explanation");
            Explanation ex = new Explanation(top);
            return ex;
        }

        public Viewer toGUI() {
            TransformedViewer v = new TransformedViewer(new SmartVanillaViewer()){
                static final long serialVersionUID = 20080128L;

                public Object transform(Object o) {
                    MyClassifier mycl = (MyClassifier)o;
                    return mycl.pos_h;
                }
            };
            v.setContent(this);
            return v;
        }
    }
}

