/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.linear;

import edu.cmu.minorthird.classify.BinaryClassifier;
import edu.cmu.minorthird.classify.Explanation;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.algorithms.linear.Hyperplane;
import edu.cmu.minorthird.util.MathUtil;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.Controllable;
import edu.cmu.minorthird.util.gui.ControlledViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.ViewerControls;
import edu.cmu.minorthird.util.gui.Visible;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class PoissonClassifier
extends BinaryClassifier
implements Visible,
Serializable {
    static final long serialVersionUID = 20080130L;
    private static final boolean LOG = true;
    private Hyperplane linear = new Hyperplane();
    private Hyperplane loglinear = new Hyperplane();

    public double score(Instance instance) {
        double score = 0.0;
        double scoreLog = 0.0;
        double total = 0.0;
        Iterator<Feature> j = instance.featureIterator();
        while (j.hasNext()) {
            Feature f = j.next();
            total += instance.getWeight(f);
            score += this.featureScore(f);
            scoreLog += instance.getWeight(f) * this.featureScore(f, true);
        }
        score = score * total / this.featureScore(Hyperplane.BIAS_TERM, true) + scoreLog + this.featureScore(Hyperplane.BIAS_TERM);
        return score;
    }

    public String explain(Instance instance) {
        Feature f;
        StringBuffer buf = new StringBuffer("");
        double total = 0.0;
        Iterator<Feature> j = instance.featureIterator();
        while (j.hasNext()) {
            f = j.next();
            total += instance.getWeight(f);
        }
        total /= this.featureScore(Hyperplane.BIAS_TERM, true);
        j = instance.featureIterator();
        while (j.hasNext()) {
            f = j.next();
            if (buf.length() > 0) {
                buf.append(" + ");
            }
            buf.append(f + "<" + instance.getWeight(f) + "*" + this.featureScore(f, true) + "+" + total + "*" + this.featureScore(f) + ">");
        }
        buf.append(" + bias<" + this.featureScore(Hyperplane.BIAS_TERM) + ">");
        buf.append(" = " + this.score(instance));
        return buf.toString();
    }

    public Explanation getExplanation(Instance instance) {
        Explanation.Node top = new Explanation.Node("PoisionClassifier Explanation");
        double total = 0.0;
        Iterator<Feature> j = instance.featureIterator();
        while (j.hasNext()) {
            Feature f = j.next();
            total += instance.getWeight(f);
        }
        total /= this.featureScore(Hyperplane.BIAS_TERM, true);
        Explanation.Node features = new Explanation.Node("Features");
        Iterator<Feature> j2 = instance.featureIterator();
        while (j2.hasNext()) {
            Feature f = j2.next();
            Explanation.Node fEx = new Explanation.Node(f + "<" + instance.getWeight(f) + "*" + this.featureScore(f, true) + "+" + total + "*" + this.featureScore(f) + ">");
            features.add(fEx);
        }
        Explanation.Node bias = new Explanation.Node(" + bias<" + this.featureScore(Hyperplane.BIAS_TERM) + ">");
        features.add(bias);
        top.add(features);
        Explanation.Node score = new Explanation.Node(" = " + this.score(instance));
        top.add(score);
        Explanation ex = new Explanation(top);
        return ex;
    }

    public void increment(Feature f, double delta) {
        this.linear.increment(f, delta);
    }

    public void increment(Feature f, double delta, boolean log) {
        this.loglinear.increment(f, delta);
    }

    public void incrementBias(double delta) {
        this.linear.incrementBias(delta);
    }

    public void setScale(double delta) {
        this.loglinear.setBias(delta);
    }

    public double getScale() {
        return this.featureScore(Hyperplane.BIAS_TERM, true);
    }

    public void increment(Instance instance, double delta, double log_delta) {
        Iterator<Feature> i = instance.featureIterator();
        while (i.hasNext()) {
            Feature f = i.next();
            this.increment(f, delta);
            this.increment(f, log_delta, true);
        }
        this.incrementBias(delta);
    }

    public double featureScore(Feature feature) {
        return this.linear.featureScore(feature);
    }

    public double featureScore(Feature feature, boolean log) {
        return this.loglinear.featureScore(feature);
    }

    public Viewer toGUI() {
        ControlledViewer gui = new ControlledViewer(new MyViewer(), new PoissonControls());
        gui.setContent(this);
        return gui;
    }

    public String toString() {
        String a = this.linear.toString();
        String b = this.loglinear.toString();
        return a + "\n" + b;
    }

    private static class MyViewer
    extends ComponentViewer
    implements Controllable {
        static final long serialVersionUID = 20080130L;
        private PoissonControls controls = null;
        private PoissonClassifier h = null;

        private MyViewer() {
        }

        public void applyControls(ViewerControls controls) {
            this.controls = (PoissonControls)controls;
            this.setContent(this.h, true);
            this.revalidate();
        }

        public boolean canReceive(Object o) {
            return o instanceof Hyperplane;
        }

        public JComponent componentFor(Object o) {
            this.h = (PoissonClassifier)o;
            Object[] keys = ((PoissonClassifier)this.h).linear.hyperplaneWeights.keys();
            Object[][] tableData = new Object[keys.length][2];
            int k = 0;
            Iterator<Feature> i = this.h.linear.featureIterator();
            while (i.hasNext()) {
                Feature f = i.next();
                tableData[k][0] = f;
                tableData[k][1] = new Double(this.h.featureScore(f));
                ++k;
            }
            if (this.controls != null) {
                Arrays.sort(tableData, new Comparator<Object[]>(){

                    @Override
                    public int compare(Object[] ra, Object[] rb) {
                        if (MyViewer.this.controls.nameButton.isSelected()) {
                            return ra[0].toString().compareTo(rb[0].toString());
                        }
                        Double da = (Double)ra[1];
                        Double db = (Double)rb[1];
                        if (MyViewer.this.controls.valueButton.isSelected()) {
                            return MathUtil.sign(db - da);
                        }
                        return MathUtil.sign(Math.abs(db) - Math.abs(da));
                    }
                });
            }
            Object[] columnNames = new String[]{"Feature Name", "Weight"};
            JTable table = new JTable(tableData, columnNames);
            this.monitorSelections(table, 0);
            return new JScrollPane(table);
        }
    }

    private static class PoissonControls
    extends ViewerControls {
        static final long serialVersionUID = 20080130L;
        private JRadioButton valueButton;
        private JRadioButton nameButton;

        private PoissonControls() {
        }

        public void initialize() {
            this.add(new JLabel("Sort by"));
            ButtonGroup group = new ButtonGroup();
            this.nameButton = this.addButton("name", group, true);
            this.valueButton = this.addButton("weight", group, false);
        }

        private JRadioButton addButton(String s, ButtonGroup group, boolean selected) {
            JRadioButton button = new JRadioButton(s, selected);
            group.add(button);
            this.add(button);
            button.addActionListener(this);
            return button;
        }
    }
}

