/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.linear;

import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.OnlineBinaryClassifierLearner;
import edu.cmu.minorthird.classify.algorithms.linear.Hyperplane;
import java.io.Serializable;

public class VotedPerceptron
extends OnlineBinaryClassifierLearner
implements Serializable {
    static final long serialVersionUID = 20080130L;
    private Hyperplane s_t;
    private Hyperplane w_t;
    private boolean ignoreWeights = false;

    public VotedPerceptron() {
        this(false);
    }

    public VotedPerceptron(boolean ignoreWeights) {
        this.ignoreWeights = ignoreWeights;
        this.reset();
    }

    public void reset() {
        this.s_t = new Hyperplane();
        this.w_t = new Hyperplane();
        if (this.ignoreWeights) {
            this.s_t.startIgnoringWeights();
            this.w_t.startIgnoringWeights();
        }
    }

    public void addExample(Example example) {
        double y_t = example.getLabel().numericLabel();
        if (this.w_t.score(example.asInstance()) * y_t <= 0.0) {
            this.w_t.increment(example, y_t);
        }
        this.s_t.increment(this.w_t, 1.0);
    }

    public Classifier getClassifier() {
        return this.s_t;
    }

    public String toString() {
        return "VotedPerceptron";
    }
}

