/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.random;

import edu.cmu.minorthird.classify.algorithms.random.Arithmetic;
import edu.cmu.minorthird.classify.algorithms.random.RWrapper;

public class ProbabilityFactory {
    private static int FLAG = 0;
    private static RWrapper rw;
    private static Object rwShadow;

    public ProbabilityFactory() {
        if (FLAG == 0) {
            try {
                rwShadow = Class.forName("eairoldi.random.BasicRWrapper");
                rw = (RWrapper)((Class)rwShadow).newInstance();
                ++FLAG;
            }
            catch (Exception x) {
                System.out.println("error: R in Minorthird is not properly installed!");
                System.out.println("       See R_quickstart.txt in apps/edo/doc/ for more information.");
                System.exit(-99);
            }
        }
    }

    public static double[] rnorm(int n, double mu, double sd) {
        return rw.rnorm(n, mu, sd);
    }

    public static double[] runif(int n, double min, double max) {
        return rw.runif(n, min, max);
    }

    public static double ProbTauGivenSigmaX(double tau, double sig, double[] vlow, double[] vup, double xr, double xp, double wr, double wp, double[] vbeta) {
        double prob = 0.0;
        double b1 = vbeta[0];
        double b2 = vbeta[1];
        prob = tau < vlow[0] | sig < vlow[1] | tau > vup[0] | sig > vup[1] ? Double.NEGATIVE_INFINITY : -wr * tau * sig - wp * (1.0 - tau) * sig + xr * Math.log(wr * tau * sig) + xp * Math.log(wp * (1.0 - tau) * sig) + (b1 + b2 * sig - 1.0) * Math.log(tau * (1.0 - tau));
        return prob;
    }

    public static double AlphaTau(double tau, double sig, double[] vlow, double[] vup, double xr, double xp, double wr, double wp, double[] vbeta, double p1, double p2, double candidate) {
        double prob = 0.0;
        prob = Math.exp(ProbabilityFactory.ProbTauGivenSigmaX(candidate, sig, vlow, vup, xr, xp, wr, wp, vbeta) - ProbabilityFactory.ProbTauGivenSigmaX(tau, sig, vlow, vup, xr, xp, wr, wp, vbeta) + rw.dnorm(tau, candidate, p2, "TRUE") - rw.dnorm(candidate, tau, p2, "TRUE"));
        if (new Double(prob).isNaN()) {
            prob = 0.0;
        }
        double alpha = Math.min(1.0, prob);
        return alpha;
    }

    public static double ProbSigmaGivenTauX(double sig, double tau, double[] vlow, double[] vup, double xr, double xp, double wr, double wp, double[] vbeta) {
        double prob = 0.0;
        double b1 = vbeta[0];
        double b2 = vbeta[1];
        prob = tau < vlow[0] | sig < vlow[1] | tau > vup[0] | sig > vup[1] ? Double.NEGATIVE_INFINITY : -wr * tau * sig - wp * (1.0 - tau) * sig + xr * Math.log(wr * tau * sig) + xp * Math.log(wp * (1.0 - tau) * sig) + (b1 + b2 * sig - 1.0) * Math.log(tau * (1.0 - tau)) + Arithmetic.logGamma(2.0 * (b1 + b2 * sig)) - 2.0 * Arithmetic.logGamma(b1 + b2 * sig);
        return prob;
    }

    public static double AlphaSigma(double sig, double tau, double[] vlow, double[] vup, double xr, double xp, double wr, double wp, double[] vbeta, double p1, double p2, double candidate) {
        double prob = 0.0;
        prob = Math.exp(ProbabilityFactory.ProbSigmaGivenTauX(candidate, tau, vlow, vup, xr, xp, wr, wp, vbeta) - ProbabilityFactory.ProbSigmaGivenTauX(sig, tau, vlow, vup, xr, xp, wr, wp, vbeta) + rw.dnorm(sig, candidate, p2, "TRUE") - rw.dnorm(candidate, sig, p2, "TRUE"));
        if (new Double(prob).isNaN()) {
            prob = 0.0;
        }
        double alpha = Math.min(1.0, prob);
        return alpha;
    }
}

