/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.svm;

import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.FeatureFactory;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.MutableInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import libsvm.svm_node;
import libsvm.svm_problem;
import org.apache.log4j.Logger;

public class SVMUtils {
    static Logger logger = Logger.getLogger(SVMUtils.class);
    private static final Comparator<svm_node> NODE_COMPARATOR = new Comparator<svm_node>(){

        @Override
        public int compare(svm_node n1, svm_node n2) {
            return n1.index - n2.index;
        }
    };

    public static String toString(svm_node node) {
        StringBuilder b = new StringBuilder();
        b.append(node.index).append("=").append(node.value);
        return b.toString();
    }

    public static String toString(svm_node[] nodes) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < nodes.length; ++i) {
            b.append(nodes[i].index).append("=").append(nodes[i].value);
            if (i >= nodes.length - 1) continue;
            b.append(" ");
        }
        return b.toString();
    }

    public static String toString(svm_problem problem) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < problem.y.length; ++i) {
            b.append(problem.y[i]).append(" : ").append(SVMUtils.toString(problem.x[i])).append("\n");
        }
        return b.toString();
    }

    public static svm_node featureToNode(Feature feature, Instance instance) {
        svm_node svm_node2 = new svm_node();
        svm_node2.index = feature.getID() + 1;
        svm_node2.value = instance.getWeight(feature);
        return svm_node2;
    }

    public static svm_node[] instanceToNodeArray(Instance instance) {
        ArrayList<svm_node> nodes = new ArrayList<svm_node>();
        Iterator<Feature> it = instance.featureIterator();
        while (it.hasNext()) {
            Feature feature = it.next();
            nodes.add(SVMUtils.featureToNode(feature, instance));
        }
        Collections.sort(nodes, NODE_COMPARATOR);
        return nodes.toArray(new svm_node[nodes.size()]);
    }

    public static svm_problem convertToSVMProblem(Dataset dataset) {
        svm_problem problem = new svm_problem();
        problem.l = dataset.size();
        problem.y = new double[problem.l];
        problem.x = new svm_node[problem.l][];
        Iterator<Example> it = dataset.iterator();
        int i = 0;
        while (it.hasNext()) {
            Example example = it.next();
            problem.y[i] = dataset.getSchema().equals(ExampleSchema.BINARY_EXAMPLE_SCHEMA) ? example.getLabel().numericLabel() : (double)dataset.getSchema().getClassIndex(example.getLabel().bestClassName());
            problem.x[i] = SVMUtils.instanceToNodeArray(example);
            ++i;
        }
        return problem;
    }

    public static Feature nodeToFeature(svm_node node, FeatureFactory featureFactory) {
        return featureFactory.getFeature(node.index - 1);
    }

    public static Instance nodeArrayToInstance(svm_node[] nodes, FeatureFactory featureFactory) {
        MutableInstance instance = new MutableInstance();
        for (int i = 0; i < nodes.length; ++i) {
            Feature feature = SVMUtils.nodeToFeature(nodes[i], featureFactory);
            if (feature == null) {
                return null;
            }
            instance.addNumeric(feature, nodes[i].value);
        }
        return instance;
    }
}

