/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.experiments;

import edu.cmu.minorthird.classify.Splitter;
import edu.cmu.minorthird.classify.experiments.CrossValSplitter;
import edu.cmu.minorthird.classify.experiments.RandomSplitter;
import java.util.Iterator;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubsamplingCrossValSplitter<T>
implements Splitter<T> {
    private Random random;
    private int folds;
    private double subsampleFraction;
    private Iterator<T>[] trainIt;
    private Iterator<T>[] testIt;
    private CrossValSplitter<T> cvs;
    private RandomSplitter<T> rs;

    public SubsamplingCrossValSplitter(Random random2, int folds, double subsampleFraction) {
        this.random = random2;
        this.folds = folds;
        this.subsampleFraction = subsampleFraction;
    }

    public SubsamplingCrossValSplitter(int folds, double subsampleFraction) {
        this(new Random(), folds, subsampleFraction);
    }

    public SubsamplingCrossValSplitter() {
        this(5, 0.5);
    }

    public int getNumberOfFolds() {
        return this.folds;
    }

    public void setNumberOfFolds(int k) {
        this.folds = k;
    }

    public double getSubsampleFraction() {
        return this.subsampleFraction;
    }

    public void setSubsampleFraction(double d) {
        this.subsampleFraction = d;
    }

    @Override
    public void split(Iterator<T> i) {
        this.cvs = new CrossValSplitter(this.random, this.folds);
        this.rs = new RandomSplitter(this.random, this.subsampleFraction);
        this.cvs.split(i);
        this.testIt = new Iterator[this.folds];
        this.trainIt = new Iterator[this.folds];
        for (int k = 0; k < this.folds; ++k) {
            this.testIt[k] = this.cvs.getTest(k);
            this.rs.split(this.cvs.getTrain(k));
            this.trainIt[k] = this.rs.getTrain(0);
        }
    }

    @Override
    public int getNumPartitions() {
        return this.folds;
    }

    @Override
    public Iterator<T> getTrain(int k) {
        return this.trainIt[k];
    }

    @Override
    public Iterator<T> getTest(int k) {
        return this.cvs.getTest(k);
    }

    public String toString() {
        return "[SubCV " + this.folds + ";" + this.subsampleFraction + "]";
    }
}

