/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.experiments;

import edu.cmu.minorthird.classify.HasSubpopulationId;
import edu.cmu.minorthird.classify.Splitter;
import edu.cmu.minorthird.classify.experiments.RandomSplitter;
import edu.cmu.minorthird.util.StringUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebmasterSplitter<T>
implements Splitter<T> {
    private static Logger log = Logger.getLogger(WebmasterSplitter.class);
    private int folds = 3;
    private double fraction = 0.7;
    private Map<String, String> userMap = new HashMap<String, String>();
    private Map<String, String> requestMap = new HashMap<String, String>();
    private Map<String, String> profileMap = new HashMap<String, String>();
    private Map<String, String> req2ProfileMap = new HashMap<String, String>();
    private List<T>[] trainList = null;
    private List<T>[] testList = null;

    public WebmasterSplitter(String constraintFileName, double fraction, int folds) {
        this.folds = folds;
        this.fraction = fraction;
        this.loadFile(constraintFileName);
    }

    private void loadFile(String constraintFileName) {
        try {
            LineNumberReader in = new LineNumberReader(new FileReader(new File(constraintFileName)));
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] f = line.split(" ");
                if (f.length != 4) {
                    this.badInput(line, constraintFileName, in);
                }
                this.requestMap.put(f[0], f[2]);
                this.profileMap.put(f[0], f[3]);
                String oldProfForRequest = this.req2ProfileMap.get(f[2]);
                if (oldProfForRequest != null && !oldProfForRequest.equals(f[3])) {
                    log.error("request " + f[2] + " associated with two profiles: " + oldProfForRequest + " and " + f[3]);
                    this.badInput(line, constraintFileName, in);
                }
                this.req2ProfileMap.put(f[2], f[3]);
            }
            in.close();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("can't load from " + constraintFileName + ": " + ex.toString());
        }
    }

    private void badInput(String line, String fileName, LineNumberReader in) {
        throw new IllegalStateException("Bad input at " + fileName + " line " + in.getLineNumber() + ": " + line);
    }

    @Override
    public void split(Iterator<T> it) {
        int k;
        List<T> inputList = this.asList(it);
        HashSet<String> users = new HashSet<String>();
        HashSet<String> requests = new HashSet<String>();
        for (T example : inputList) {
            HasSubpopulationId hsi;
            String subpop;
            String userId;
            if (!(example instanceof HasSubpopulationId)) {
                this.badExample(example, "doesn't have a subpopulationId");
            }
            if ((userId = this.userMap.get(subpop = (hsi = (HasSubpopulationId)example).getSubpopulationId())) == null) {
                this.badExample(example, "no userId for " + subpop + " in the constraint file");
            }
            users.add(userId);
            String reqId = this.requestMap.get(subpop);
            requests.add(reqId);
        }
        RandomSplitter userSplitter = new RandomSplitter(this.fraction);
        userSplitter.split(users.iterator());
        Set<String> testUsers = this.asSet(userSplitter.getTest(0));
        if (log.isDebugEnabled()) {
            log.debug("testUsers = " + testUsers);
        }
        ArrayList<String> requestList = new ArrayList<String>(requests.size());
        requestList.addAll(requests);
        Comparator<String> byProfile = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                String prof1 = (String)WebmasterSplitter.this.req2ProfileMap.get(s1);
                String prof2 = (String)WebmasterSplitter.this.req2ProfileMap.get(s2);
                return prof1.compareTo(prof2);
            }
        };
        Collections.shuffle(requestList);
        Collections.sort(requestList, byProfile);
        Set[] partition = new Set[this.folds];
        for (k = 0; k < this.folds; ++k) {
            partition[k] = new HashSet();
        }
        for (int i = 0; i < requestList.size(); ++i) {
            partition[i % this.folds].add(requestList.get(i));
        }
        if (log.isDebugEnabled()) {
            for (k = 0; k < this.folds; ++k) {
                TreeSet<String> profilesForPartition = new TreeSet<String>();
                Iterator j = partition[k].iterator();
                while (j.hasNext()) {
                    profilesForPartition.add(this.req2ProfileMap.get(j.next()));
                }
                log.debug("partition " + k + ": " + partition[k] + " profiles: " + profilesForPartition);
            }
        }
        this.trainList = new List[this.folds];
        this.testList = new List[this.folds];
        for (k = 0; k < this.folds; ++k) {
            this.trainList[k] = new ArrayList<T>();
            this.testList[k] = new ArrayList<T>();
        }
        for (HasSubpopulationId hsi : inputList) {
            String subpop = hsi.getSubpopulationId();
            String userId = this.userMap.get(subpop);
            String reqId = this.requestMap.get(subpop);
            int k2 = this.partitionContaining(partition, reqId);
            if (testUsers.contains(userId)) {
                this.testList[k2].add(hsi);
                continue;
            }
            for (int j = 0; j < this.folds; ++j) {
                if (j == k2) continue;
                this.trainList[j].add(hsi);
            }
        }
        this.verifySplit();
    }

    private void badExample(Object o, String msg) {
        throw new IllegalArgumentException(msg + " on input " + o);
    }

    private int partitionContaining(Set<String>[] partition, String req) {
        for (int i = 0; i < partition.length; ++i) {
            if (!partition[i].contains(req)) continue;
            return i;
        }
        throw new IllegalStateException("request id " + req + " not found in partition???");
    }

    private void verifySplit() {
        for (int k = 0; k < this.folds; ++k) {
            for (int i = 0; i < this.trainList[k].size(); ++i) {
                T oi = this.trainList[k].get(i);
                for (int j = 0; j < this.testList[k].size(); ++j) {
                    T oj = this.testList[k].get(j);
                    if (!this.similarTo(oi, oj)) continue;
                    throw new IllegalStateException("bad split for train/test " + oi + "/" + oj);
                }
            }
        }
        for (int k1 = 0; k1 < this.folds; ++k1) {
            for (int k2 = 0; k2 < this.folds; ++k2) {
                if (k2 == k1) continue;
                for (int j1 = 0; j1 < this.testList[k1].size(); ++j1) {
                    for (int j2 = 0; j2 < this.testList[k2].size(); ++j2) {
                        if (this.testList[k1].get(j1) != this.testList[k2].get(j2)) continue;
                        throw new IllegalStateException("overlapping test cases for lists " + k1 + " and " + k2);
                    }
                }
            }
        }
    }

    private boolean similarTo(Object o1, Object o2) {
        String subpop1 = ((HasSubpopulationId)o1).getSubpopulationId();
        String subpop2 = ((HasSubpopulationId)o2).getSubpopulationId();
        if (this.userMap.get(subpop1).equals(this.userMap.get(subpop2))) {
            return true;
        }
        return this.requestMap.get(subpop1).equals(this.requestMap.get(subpop2));
    }

    @Override
    public int getNumPartitions() {
        return this.folds;
    }

    @Override
    public Iterator<T> getTrain(int k) {
        return this.trainList[k].iterator();
    }

    @Override
    public Iterator<T> getTest(int k) {
        return this.testList[k].iterator();
    }

    public String toString() {
        return "[WebmasterSplitter " + this.folds + "]";
    }

    public static void main(String[] args) {
        try {
            String file = args[0];
            WebmasterSplitter splitter = new WebmasterSplitter(file, 0.7, StringUtil.atoi(args[1]));
            ArrayList<2> list = new ArrayList<2>();
            LineNumberReader in = new LineNumberReader(new FileReader(new File(args[0])));
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] f = line.split(" ");
                final String subpop = f[0];
                list.add(new HasSubpopulationId(){

                    public String toString() {
                        return "[Ex " + subpop + "]";
                    }

                    public String getSubpopulationId() {
                        return subpop;
                    }
                });
            }
            splitter.split(list.iterator());
            int totTestSize = 0;
            int totTrainSize = 0;
            for (int k = 0; k < splitter.getNumPartitions(); ++k) {
                totTestSize += super.asList(splitter.getTest(k)).size();
                totTrainSize += super.asList(splitter.getTrain(k)).size();
                System.out.println("fold " + k + ":");
                System.out.println("test: " + splitter.testList[k]);
                System.out.println("train: " + splitter.trainList[k]);
            }
            System.out.println("data.size = " + list.size());
            System.out.println("total test size=" + totTestSize);
            System.out.println("total train size=" + totTrainSize);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("usage: WebmasterSplitter constraint-file #folds");
        }
    }

    private List<T> asList(Iterator<T> i) {
        ArrayList<T> accum = new ArrayList<T>();
        while (i.hasNext()) {
            accum.add(i.next());
        }
        return accum;
    }

    private Set<String> asSet(Iterator<String> i) {
        HashSet<String> accum = new HashSet<String>();
        while (i.hasNext()) {
            accum.add(i.next());
        }
        return accum;
    }
}

