/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.multi;

import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.multi.MultiExample;
import edu.cmu.minorthird.util.StringUtil;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.ParallelViewer;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.TransformedViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class GUI {
    public static JComponent conciseExampleRendererComponent(MultiExample e, int len, boolean emphasized) {
        if (e == null) {
            return new JTextField("[null example]");
        }
        String sourceString = e.getSource() == null ? "[null]" : StringUtil.truncate(len, e.getSource().toString());
        JTextField tf = new JTextField(e.getLabel() + " " + sourceString);
        Color c = emphasized ? Color.blue : Color.black;
        tf.setBorder(BorderFactory.createLineBorder(c, 2));
        return tf;
    }

    public static JComponent conciseMultiExampleRendererComponent(MultiExample e, int len, boolean emphasized) {
        if (e == null) {
            return new JTextField("[null example]");
        }
        String sourceString = e.getSource() == null ? "[null]" : StringUtil.truncate(len, e.getSource().toString());
        JTextField tf = new JTextField(e.getMultiLabel() + " " + sourceString);
        Color c = emphasized ? Color.blue : Color.black;
        tf.setBorder(BorderFactory.createLineBorder(c, 2));
        return tf;
    }

    public static Viewer newSourcedMultiExampleViewer() {
        ParallelViewer main = new ParallelViewer();
        main.addSubView("Features", new MultiExampleViewer());
        main.addSubView("Source", new TransformedViewer(new SmartVanillaViewer()){
            static final long serialVersionUID = 20080130L;

            public Object transform(Object o) {
                return ((MultiExample)o).getSource();
            }
        });
        main.addSubView("Subpopulation", new TransformedViewer(new SmartVanillaViewer()){
            static final long serialVersionUID = 20080130L;

            public Object transform(Object o) {
                return "Subpopulation ID='" + ((MultiExample)o).getSubpopulationId() + "'";
            }
        });
        return main;
    }

    private static JComponent instanceComponent(Instance instance) {
        int numRows = 0;
        Iterator<Feature> i = instance.featureIterator();
        while (i.hasNext()) {
            ++numRows;
            i.next();
        }
        Object[][] tableData = new Object[numRows][2];
        int k = 0;
        Iterator<Feature> i2 = instance.featureIterator();
        while (i2.hasNext()) {
            Feature f = i2.next();
            tableData[k][0] = f;
            tableData[k][1] = new Double(instance.getWeight(f));
            ++k;
        }
        Object[] columnNames = new String[]{"Feature Name", "Weight"};
        JTable table = new JTable(tableData, columnNames);
        return new JScrollPane(table);
    }

    public static class InstanceViewer
    extends ComponentViewer {
        static final long serialVersionUID = 20080130L;

        public InstanceViewer() {
        }

        public InstanceViewer(Instance instance) {
            super(instance);
        }

        public boolean canReceive(Object o) {
            return o instanceof Instance;
        }

        public JComponent componentFor(Object o) {
            return GUI.instanceComponent((Instance)o);
        }
    }

    public static class MultiExampleViewer
    extends ComponentViewer {
        static final long serialVersionUID = 20080130L;

        public MultiExampleViewer() {
        }

        public MultiExampleViewer(MultiExample instance) {
            super(instance);
        }

        public boolean canReceive(Object o) {
            return o instanceof MultiExample;
        }

        public JComponent componentFor(Object o) {
            MultiExample e = (MultiExample)o;
            JPanel p = new JPanel();
            p.setLayout(new GridBagLayout());
            GridBagConstraints gbc = MultiExampleViewer.fillerGBC();
            gbc.fill = 2;
            gbc = new GridBagConstraints();
            p.add((Component)new JLabel("Class label: " + e.getMultiLabel().toDetails()), gbc);
            gbc = MultiExampleViewer.fillerGBC();
            gbc.gridy = 1;
            p.add((Component)GUI.instanceComponent(e), gbc);
            return p;
        }
    }
}

