/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.multi;

import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.multi.GUI;
import edu.cmu.minorthird.util.UnionIterator;
import edu.cmu.minorthird.util.gui.Viewer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceFromPrediction
implements Instance {
    private Instance instance;
    private Set<Feature> history;

    public InstanceFromPrediction(Instance instance, String[] previousLabels) {
        this.instance = instance;
        this.history = new HashSet<Feature>();
        for (int i = 0; i < previousLabels.length; ++i) {
            this.history.add(new Feature(new String[]{"Predicted Label for Dimension: " + i, previousLabels[i]}));
        }
    }

    public Instance asPlainInstance() {
        return this.instance;
    }

    @Override
    public final Object getSource() {
        return this.instance.getSource();
    }

    @Override
    public final String getSubpopulationId() {
        return this.instance.getSubpopulationId();
    }

    @Override
    public final Iterator<Feature> numericFeatureIterator() {
        return this.instance.numericFeatureIterator();
    }

    @Override
    public final Iterator<Feature> binaryFeatureIterator() {
        return new UnionIterator<Feature>(this.history.iterator(), this.instance.binaryFeatureIterator());
    }

    @Override
    public final Iterator<Feature> featureIterator() {
        return new UnionIterator<Feature>(this.history.iterator(), this.instance.featureIterator());
    }

    @Override
    public final int numFeatures() {
        return this.history.size() + this.instance.numFeatures();
    }

    @Override
    public final double getWeight(Feature f) {
        if (this.history.contains(f)) {
            return 1.0;
        }
        return this.instance.getWeight(f);
    }

    public String toString() {
        return "[instFromPrediction " + this.history + " " + this.instance + "]";
    }

    @Override
    public final Viewer toGUI() {
        return new GUI.InstanceViewer(this);
    }
}

