/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.multi;

import edu.cmu.minorthird.classify.BasicDataset;
import edu.cmu.minorthird.classify.BatchVersion;
import edu.cmu.minorthird.classify.CascadingBinaryLearner;
import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.DatasetLoader;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.FeatureFactory;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.Splitter;
import edu.cmu.minorthird.classify.algorithms.linear.VotedPerceptron;
import edu.cmu.minorthird.classify.experiments.CrossValSplitter;
import edu.cmu.minorthird.classify.multi.GUI;
import edu.cmu.minorthird.classify.multi.InstanceFromPrediction;
import edu.cmu.minorthird.classify.multi.MultiClassLabel;
import edu.cmu.minorthird.classify.multi.MultiClassifier;
import edu.cmu.minorthird.classify.multi.MultiDatasetClassifierTeacher;
import edu.cmu.minorthird.classify.multi.MultiExample;
import edu.cmu.minorthird.classify.multi.MultiExampleSchema;
import edu.cmu.minorthird.util.Saveable;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.Visible;
import edu.cmu.minorthird.util.gui.ZoomedViewer;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiDataset
implements Dataset,
Visible,
Saveable {
    static final long serialVersionUID = 20080130L;
    protected List<MultiExample> examples = new ArrayList<MultiExample>();
    protected List<Instance> unlabeledExamples = new ArrayList<Instance>();
    protected FeatureFactory factory = new FeatureFactory();
    protected Set<String>[] classNameSets;
    public int numPosExamples = 0;
    private static final String FORMAT_NAME = "Minorthird MultiDataset";

    @Override
    public ExampleSchema getSchema() {
        ExampleSchema schema = new ExampleSchema(this.classNameSets[0].toArray(new String[this.classNameSets[0].size()]));
        if (schema.equals(ExampleSchema.BINARY_EXAMPLE_SCHEMA)) {
            return ExampleSchema.BINARY_EXAMPLE_SCHEMA;
        }
        return schema;
    }

    public MultiExampleSchema getMultiSchema() {
        ExampleSchema[] schemas = new ExampleSchema[this.classNameSets.length];
        for (int i = 0; i < schemas.length; ++i) {
            schemas[i] = new ExampleSchema(this.classNameSets[i].toArray(new String[this.classNameSets[i].size()]));
            if (!schemas.equals(ExampleSchema.BINARY_EXAMPLE_SCHEMA)) continue;
            schemas[i] = ExampleSchema.BINARY_EXAMPLE_SCHEMA;
        }
        MultiExampleSchema multiSchema = new MultiExampleSchema(schemas);
        return multiSchema;
    }

    public MultiExample getMultiExample(int i) {
        return this.examples.get(i);
    }

    @Override
    public FeatureFactory getFeatureFactory() {
        return this.factory;
    }

    public void addUnlabeled(Instance instance) {
        this.unlabeledExamples.add(this.factory.compress(instance));
    }

    public Iterator<Instance> iteratorOverUnlabeled() {
        return this.unlabeledExamples.iterator();
    }

    public int sizeUnlabeled() {
        return this.unlabeledExamples.size();
    }

    public boolean hasUnlabeled() {
        return this.unlabeledExamples.size() > 0;
    }

    @Override
    public void add(Example example) {
        throw new IllegalArgumentException("You must add a MultiExample to a MutiDataset");
    }

    @Override
    public void add(Example example, boolean compress) {
        throw new IllegalArgumentException("You must add a MultiExample to a MutiDataset");
    }

    public void addMulti(MultiExample example) {
        if (this.classNameSets == null) {
            this.classNameSets = new Set[example.getMultiLabel().numDimensions()];
            for (int i = 0; i < this.classNameSets.length; ++i) {
                this.classNameSets[i] = new TreeSet<String>();
            }
        }
        if (this.classNameSets.length != example.getMultiLabel().numDimensions()) {
            throw new IllegalArgumentException("This example does not have the same number of dimensions as previous examples");
        }
        this.examples.add(this.factory.compress(example));
        Set<String>[] possibleLabels = example.getMultiLabel().possibleLabels();
        for (int i = 0; i < this.classNameSets.length; ++i) {
            this.classNameSets[i].addAll(possibleLabels[i]);
        }
        ClassLabel cl = example.getLabel();
        if (cl.isPositive()) {
            ++this.numPosExamples;
        }
    }

    public Dataset[] separateDatasets() {
        int i;
        Example[] ex_one = this.examples.get(0).getExamples();
        Dataset[] d = new BasicDataset[ex_one.length];
        for (i = 0; i < d.length; ++i) {
            d[i] = new BasicDataset();
        }
        for (i = 0; i < this.examples.size(); ++i) {
            Example[] ex = this.examples.get(i).getExamples();
            for (int j = 0; j < ex.length; ++j) {
                d[j].add(ex[j]);
            }
        }
        return d;
    }

    public int getNumPosExamples() {
        return this.numPosExamples;
    }

    @Override
    public Iterator<Example> iterator() {
        throw new IllegalArgumentException("Must use multiIterator to iterate through MultiExamples");
    }

    public Iterator<MultiExample> multiIterator() {
        return this.examples.iterator();
    }

    @Override
    public int size() {
        return this.examples.size();
    }

    @Override
    public void shuffle(Random r) {
        Collections.shuffle(this.examples, r);
    }

    @Override
    public void shuffle() {
        this.shuffle(new Random(999L));
    }

    @Override
    public Dataset shallowCopy() {
        MultiDataset copy2 = new MultiDataset();
        Iterator<MultiExample> i = this.multiIterator();
        while (i.hasNext()) {
            copy2.addMulti(i.next());
        }
        return copy2;
    }

    @Override
    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    @Override
    public String getExtensionFor(String s) {
        return ".multidata";
    }

    @Override
    public void saveAs(File file, String format) throws IOException {
        if (!format.equals(FORMAT_NAME)) {
            throw new IllegalArgumentException("illegal format " + format);
        }
        DatasetLoader.save(this, file);
    }

    @Override
    public Object restore(File file) throws IOException {
        try {
            return DatasetLoader.loadFile(file);
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException("error loading from " + file + ": " + ex);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("");
        Iterator<MultiExample> i = this.multiIterator();
        while (i.hasNext()) {
            MultiExample ex = i.next();
            buf.append(ex.toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    public MultiDataset annotateData() {
        MultiDataset annotatedDataset = new MultiDataset();
        CrossValSplitter<MultiExample> splitter = new CrossValSplitter<MultiExample>(9);
        MultiSplit s = this.MultiSplit(splitter);
        for (int x = 0; x < 9; ++x) {
            MultiDatasetClassifierTeacher teacher = new MultiDatasetClassifierTeacher(s.getTrain(x));
            CascadingBinaryLearner lnr = new CascadingBinaryLearner(new BatchVersion(new VotedPerceptron()));
            MultiClassifier c = teacher.train(lnr);
            Iterator<MultiExample> i = s.getTest(x).multiIterator();
            while (i.hasNext()) {
                MultiExample ex = i.next();
                Instance instance = ex.asInstance();
                MultiClassLabel predicted = c.multiLabelClassification(instance);
                InstanceFromPrediction annotatedInstance = new InstanceFromPrediction(instance, predicted.bestClassName());
                MultiExample newEx = new MultiExample((Instance)annotatedInstance, ex.getMultiLabel(), ex.getWeight());
                annotatedDataset.addMulti(newEx);
            }
        }
        return annotatedDataset;
    }

    public MultiDataset annotateData(MultiClassifier multiClassifier) {
        MultiDataset annotatedDataset = new MultiDataset();
        Iterator<MultiExample> i = this.multiIterator();
        while (i.hasNext()) {
            MultiExample ex = i.next();
            Instance instance = ex.asInstance();
            MultiClassLabel predicted = multiClassifier.multiLabelClassification(instance);
            InstanceFromPrediction annotatedInstance = new InstanceFromPrediction(instance, predicted.bestClassName());
            MultiExample newEx = new MultiExample((Instance)annotatedInstance, ex.getMultiLabel(), ex.getWeight());
            annotatedDataset.addMulti(newEx);
        }
        return annotatedDataset;
    }

    @Override
    public Viewer toGUI() {
        SimpleDatasetViewer dbGui = new SimpleDatasetViewer();
        dbGui.setContent(this);
        Viewer instGui = GUI.newSourcedMultiExampleViewer();
        return new ZoomedViewer(dbGui, instGui);
    }

    @Override
    public Dataset.Split split(Splitter<Example> splitter) {
        System.err.println("Split split() not implemented.");
        return null;
    }

    public MultiSplit MultiSplit(Splitter<MultiExample> splitter) {
        splitter.split(this.examples.iterator());
        return new MultiSplit(splitter);
    }

    private MultiDataset invertMultiIteration(Iterator<MultiExample> i) {
        MultiDataset copy2 = new MultiDataset();
        while (i.hasNext()) {
            copy2.addMulti(i.next());
        }
        return copy2;
    }

    public static void main(String[] args) {
        System.out.println("Not working yet");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MultiSplit {
        Splitter<MultiExample> splitter;

        public MultiSplit(Splitter<MultiExample> splitter) {
            this.splitter = splitter;
        }

        public int getNumPartitions() {
            return this.splitter.getNumPartitions();
        }

        public MultiDataset getTrain(int k) {
            return MultiDataset.this.invertMultiIteration(this.splitter.getTrain(k));
        }

        public MultiDataset getTest(int k) {
            return MultiDataset.this.invertMultiIteration(this.splitter.getTest(k));
        }
    }

    public static class SimpleDatasetViewer
    extends ComponentViewer {
        static final long serialVersionUID = 20080130L;

        public boolean canReceive(Object o) {
            return o instanceof Dataset;
        }

        public JComponent componentFor(Object o) {
            MultiDataset d = (MultiDataset)o;
            final MultiExample[] tmp = new MultiExample[d.size()];
            int k = 0;
            Iterator<MultiExample> i = d.multiIterator();
            while (i.hasNext()) {
                tmp[k++] = i.next();
            }
            JList<MultiExample> jList = new JList<MultiExample>(tmp);
            jList.setCellRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList el, Object v, int index, boolean sel, boolean focus) {
                    return GUI.conciseMultiExampleRendererComponent(tmp[index], 60, sel);
                }
            });
            this.monitorSelections(jList);
            return new JScrollPane(jList);
        }
    }
}

