/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.multi;

import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.ClassifierLearner;
import edu.cmu.minorthird.classify.ClassifierLearnerFactory;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.algorithms.linear.MaxEntLearner;
import edu.cmu.minorthird.classify.multi.MultiClassifier;
import edu.cmu.minorthird.classify.multi.MultiExample;
import edu.cmu.minorthird.classify.multi.MultiExampleSchema;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiLearner
implements ClassifierLearner {
    protected ClassifierLearnerFactory learnerFactory;
    protected ClassifierLearner learner;
    protected String learnerName;
    protected List<ClassifierLearner> innerLearner;
    protected MultiExampleSchema multiSchema;

    public MultiLearner(ClassifierLearner learner) {
        this.learner = learner;
        this.learnerName = learner.toString();
    }

    public MultiLearner() {
        this(new MaxEntLearner());
    }

    @Override
    public ClassifierLearner copy() {
        MultiLearner learner = null;
        try {
            learner = (MultiLearner)this.clone();
            for (int i = 0; i < this.innerLearner.size(); ++i) {
                ClassifierLearner inner = this.innerLearner.get(i);
                learner.innerLearner.add(inner.copy());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return learner;
    }

    @Override
    public void setSchema(ExampleSchema schema) {
        System.err.println("Must use setMultiSchema(MultiExampleSchema schema)");
    }

    @Override
    public ExampleSchema getSchema() {
        return null;
    }

    public void setMultiSchema(MultiExampleSchema schema) {
        this.multiSchema = schema;
        this.innerLearner = new ArrayList<ClassifierLearner>();
        ExampleSchema[] schemas = this.multiSchema.getSchemas();
        for (int i = 0; i < schemas.length; ++i) {
            this.innerLearner.add(this.learner.copy());
            this.innerLearner.get(i).setSchema(schemas[i]);
        }
    }

    public MultiExampleSchema getMultiSchema() {
        return this.multiSchema;
    }

    @Override
    public void reset() {
        if (this.innerLearner != null) {
            for (int i = 0; i < this.innerLearner.size(); ++i) {
                this.innerLearner.get(i).reset();
            }
        }
    }

    @Override
    public void setInstancePool(Iterator<Instance> it) {
        ArrayList<Instance> list = new ArrayList<Instance>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        for (int i = 0; i < this.innerLearner.size(); ++i) {
            this.innerLearner.get(i).setInstancePool(list.iterator());
        }
    }

    @Override
    public boolean hasNextQuery() {
        for (int i = 0; i < this.innerLearner.size(); ++i) {
            if (!this.innerLearner.get(i).hasNextQuery()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Instance nextQuery() {
        for (int i = 0; i < this.innerLearner.size(); ++i) {
            if (!this.innerLearner.get(i).hasNextQuery()) continue;
            return this.innerLearner.get(i).nextQuery();
        }
        return null;
    }

    @Override
    public void addExample(Example answeredQuery) {
        System.err.println("Must use addMultiExample(MultiExample answeredQuery)");
    }

    public void addMultiExample(MultiExample answeredQuery) {
        Example[] examples = answeredQuery.getExamples();
        for (int i = 0; i < this.innerLearner.size(); ++i) {
            this.innerLearner.get(i).addExample(examples[i]);
        }
    }

    @Override
    public void completeTraining() {
        for (int i = 0; i < this.innerLearner.size(); ++i) {
            this.innerLearner.get(i).completeTraining();
        }
    }

    @Override
    public Classifier getClassifier() {
        if (this.innerLearner.get(0) == null) {
            return null;
        }
        return this.innerLearner.get(0).getClassifier();
    }

    public MultiClassifier getMultiClassifier() {
        Classifier[] classifiers = new Classifier[this.innerLearner.size()];
        for (int i = 0; i < this.innerLearner.size(); ++i) {
            classifiers[i] = this.innerLearner.get(i).getClassifier();
        }
        return new MultiClassifier(classifiers);
    }
}

