/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.sequential;

import com.wcohen.ss.DistanceLearnerFactory;
import com.wcohen.ss.api.StringDistance;
import com.wcohen.ss.api.StringDistanceLearner;
import com.wcohen.ss.lookup.SoftDictionary;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.sequential.BatchSegmenterLearner;
import edu.cmu.minorthird.classify.sequential.SegmentCRFLearner;
import edu.cmu.minorthird.classify.sequential.SegmentDataset;
import edu.cmu.minorthird.classify.sequential.SegmentTransform;
import edu.cmu.minorthird.classify.sequential.Segmenter;
import edu.cmu.minorthird.classify.sequential.TransformingSegmenter;
import edu.cmu.minorthird.classify.transform.DictionaryTransform;
import edu.cmu.minorthird.classify.transform.LeaveOneOutDictTransformLearner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DictVersion
implements BatchSegmenterLearner {
    private String[] featurePattern;
    private BatchSegmenterLearner innerLearner;
    private SoftDictionary softDictionary;
    private StringDistance[] distances;

    public DictVersion(BatchSegmenterLearner innerLearner, File dictFile, String distanceNames) throws IOException, FileNotFoundException {
        this(LeaveOneOutDictTransformLearner.DEFAULT_PATTERN, innerLearner, dictFile, distanceNames);
    }

    public DictVersion(String[] featurePattern, BatchSegmenterLearner innerLearner, File dictFile, String distanceNames) throws IOException, FileNotFoundException {
        this.featurePattern = featurePattern;
        this.innerLearner = innerLearner;
        this.softDictionary = new SoftDictionary();
        this.softDictionary.load(dictFile);
        this.init(distanceNames);
    }

    public DictVersion(String[] featurePattern, BatchSegmenterLearner innerLearner, SoftDictionary softDictionary, String distanceNames) {
        this.featurePattern = featurePattern;
        this.innerLearner = innerLearner;
        this.softDictionary = softDictionary;
        this.init(distanceNames);
    }

    private void init(String distanceNames) {
        this.distances = DistanceLearnerFactory.buildArray(distanceNames);
        for (int d = 0; d < this.distances.length; ++d) {
            if (!(this.distances[d] instanceof StringDistanceLearner)) continue;
            this.distances[d] = this.softDictionary.getTeacher().train((StringDistanceLearner)((Object)this.distances[d]));
        }
    }

    public void setSchema(ExampleSchema schema) {
    }

    public Segmenter batchTrain(SegmentDataset dataset) {
        ExampleSchema schema = dataset.getSchema();
        SoftDictionary[] dictPerClass = new SoftDictionary[schema.getNumberOfClasses()];
        for (int i = 0; i < schema.getNumberOfClasses(); ++i) {
            dictPerClass[i] = this.softDictionary;
        }
        StringDistance[][] distPerClass = new StringDistance[schema.getNumberOfClasses()][this.distances.length];
        for (int i = 0; i < schema.getNumberOfClasses(); ++i) {
            for (int j = 0; j < this.distances.length; ++j) {
                distPerClass[i][j] = this.distances[j];
            }
        }
        DictionaryTransform transform = new DictionaryTransform(schema, dictPerClass, this.featurePattern, distPerClass);
        SegmentTransform segmentTransform = new SegmentTransform(transform);
        SegmentDataset transformedDataset = segmentTransform.transform(dataset);
        Segmenter segmenter = this.innerLearner.batchTrain(transformedDataset);
        return new TransformingSegmenter(transform, segmenter);
    }

    public static void main(String[] args) throws IOException, FileNotFoundException {
        new DictVersion(new SegmentCRFLearner(), new File(args[0]), args[1]);
    }
}

