/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.sequential;

import edu.cmu.minorthird.classify.sequential.Backward;
import edu.cmu.minorthird.classify.sequential.Forward;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HMM {
    int nstate;
    String[] state;
    double[][] amat;
    double[][] loga;
    int nesym;
    Hashtable<String, String> esym = new Hashtable();
    Hashtable<String, String> esym_tok2idx;
    Hashtable<String, String> esym_idx2tok;
    double[][] emat;
    double[][] loge;
    private static DecimalFormat fmt = new DecimalFormat("0.000000 ");

    public HMM(String[] state, double[][] amat, Hashtable<String, String> esym, double[][] emat) {
        String key;
        if (state.length != amat.length) {
            throw new IllegalArgumentException("HMM: state and amat disagree");
        }
        if (amat.length != emat.length) {
            throw new IllegalArgumentException("HMM: amat and emat disagree");
        }
        for (int i = 0; i < amat.length; ++i) {
            if (state.length != amat[i].length) {
                throw new IllegalArgumentException("HMM: amat non-square");
            }
            if (esym.size() == emat[i].length) continue;
            throw new IllegalArgumentException("HMM: esym and emat disagree");
        }
        this.nstate = state.length + 1;
        this.state = new String[this.nstate];
        this.loga = new double[this.nstate][this.nstate];
        this.state[0] = "S";
        this.loga[0][0] = Double.NEGATIVE_INFINITY;
        double fromstart = Math.log(1.0 / (double)state.length);
        for (int j = 1; j < this.nstate; ++j) {
            this.loga[0][j] = fromstart;
        }
        for (int i = 1; i < this.nstate; ++i) {
            this.state[i] = new StringBuffer(state[i - 1]).reverse().toString();
            this.loga[i][0] = Double.NEGATIVE_INFINITY;
            for (int j = 1; j < this.nstate; ++j) {
                this.loga[i][j] = Math.log(amat[i - 1][j - 1]);
            }
        }
        this.esym = esym;
        this.esym_tok2idx = new Hashtable();
        this.esym_idx2tok = new Hashtable();
        int idx = 0;
        Enumeration<String> e_keys = esym.keys();
        while (e_keys.hasMoreElements()) {
            key = e_keys.nextElement();
            this.esym_tok2idx.put(key, String.valueOf(idx));
            this.esym_idx2tok.put(String.valueOf(idx), key);
            ++idx;
        }
        e_keys = this.esym_tok2idx.keys();
        while (e_keys.hasMoreElements()) {
            key = e_keys.nextElement();
            String val = this.esym_tok2idx.get(key);
            System.out.println("in esym_tok2idx: " + key + "<--->" + val);
        }
        this.nesym = esym.size();
        this.loge = new double[this.nstate][this.nesym];
        for (int b = 0; b < this.nesym; ++b) {
            this.loge[0][b] = Double.NEGATIVE_INFINITY;
            for (int k = 0; k < emat.length; ++k) {
                this.loge[k + 1][b] = Math.log(emat[k][b]);
            }
        }
    }

    public String[] convert_Ob_seq(String[] x) {
        String[] y = new String[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = this.esym_tok2idx.containsKey(x[i]) ? this.esym_tok2idx.get(x[i]) : this.esym_tok2idx.get("UNSEEN");
            System.out.println("string " + x[i] + " corresponds to state idx " + y[i]);
        }
        return y;
    }

    public static String fmtlog(double x) {
        if (x == Double.NEGATIVE_INFINITY) {
            return fmt.format(0L);
        }
        return fmt.format(Math.exp(x));
    }

    public static HMM baumwelch(ArrayList<String[]> xs, String[] state, Hashtable<String, String> esym, double threshold) {
        double oldloglikelihood;
        int nstate = state.length;
        int nseqs = xs.size();
        int nesym = esym.size();
        Forward[] fwds = new Forward[nseqs];
        Backward[] bwds = new Backward[nseqs];
        double[] logP = new double[nseqs];
        double[][] amat = new double[nstate][];
        double[][] emat = new double[nstate][];
        for (int k = 0; k < nstate; ++k) {
            amat[k] = HMM.randomdiscrete(nstate);
            emat[k] = HMM.randomdiscrete(nesym);
        }
        HMM hmm = new HMM(state, amat, esym, emat);
        double loglikelihood = HMM.fwdbwd(hmm, xs, fwds, bwds, logP);
        System.out.println("log likelihood = " + loglikelihood);
        do {
            oldloglikelihood = loglikelihood;
            double[][] A = new double[nstate][nstate];
            double[][] E = new double[nstate][nesym];
            for (int s = 0; s < nseqs; ++s) {
                int k;
                int i;
                String[] x = xs.get(s);
                Forward fwd = fwds[s];
                Backward bwd = bwds[s];
                int L2 = x.length;
                double P = logP[s];
                for (i = 0; i < L2; ++i) {
                    for (k = 0; k < nstate; ++k) {
                        double[] dArray = E[k];
                        int n = Integer.parseInt(x[i]);
                        dArray[n] = dArray[n] + HMM.exp(fwd.f[i + 1][k + 1] + bwd.b[i + 1][k + 1] - P);
                    }
                }
                for (i = 0; i < L2 - 1; ++i) {
                    for (k = 0; k < nstate; ++k) {
                        for (int ell = 0; ell < nstate; ++ell) {
                            double[] dArray = A[k];
                            int n = ell;
                            dArray[n] = dArray[n] + HMM.exp(fwd.f[i + 1][k + 1] + hmm.loga[k + 1][ell + 1] + hmm.loge[ell + 1][Integer.parseInt(x[i + 1])] + bwd.b[i + 2][ell + 1] - P);
                        }
                    }
                }
            }
            for (int k = 0; k < nstate; ++k) {
                int b;
                int ell;
                double Aksum = 0.0;
                for (ell = 0; ell < nstate; ++ell) {
                    Aksum += A[k][ell];
                }
                for (ell = 0; ell < nstate; ++ell) {
                    amat[k][ell] = A[k][ell] / Aksum;
                }
                double Eksum = 0.0;
                for (b = 0; b < nesym; ++b) {
                    Eksum += E[k][b];
                }
                for (b = 0; b < nesym; ++b) {
                    emat[k][b] = E[k][b] / Eksum;
                }
            }
            hmm = new HMM(state, amat, esym, emat);
            loglikelihood = HMM.fwdbwd(hmm, xs, fwds, bwds, logP);
            System.out.println("log likelihood = " + loglikelihood);
        } while (Math.abs(oldloglikelihood - loglikelihood) > threshold);
        return hmm;
    }

    private static double fwdbwd(HMM hmm, ArrayList<String[]> xs, Forward[] fwds, Backward[] bwds, double[] logP) {
        double loglikelihood = 0.0;
        for (int s = 0; s < xs.size(); ++s) {
            fwds[s] = new Forward(hmm, xs.get(s));
            bwds[s] = new Backward(hmm, xs.get(s));
            logP[s] = fwds[s].logprob();
            loglikelihood += logP[s];
        }
        return loglikelihood;
    }

    public static double exp(double x) {
        if (x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        return Math.exp(x);
    }

    private static double[] randomdiscrete(int n) {
        int i;
        double[] ps = new double[n];
        double sum = 0.0;
        for (i = 0; i < n; ++i) {
            ps[i] = Math.random();
            sum += ps[i];
        }
        i = 0;
        while (i < n) {
            int n2 = i++;
            ps[n2] = ps[n2] / sum;
        }
        return ps;
    }
}

