/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.sequential;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.sequential.BatchSegmenterLearner;
import edu.cmu.minorthird.classify.sequential.CRFLearner;
import edu.cmu.minorthird.classify.sequential.CandidateSegmentGroup;
import edu.cmu.minorthird.classify.sequential.SegmentDataset;
import edu.cmu.minorthird.classify.sequential.Segmentation;
import edu.cmu.minorthird.classify.sequential.Segmenter;
import edu.cmu.minorthird.classify.sequential.SequenceConstants;
import iitb.CRF.DataIter;
import iitb.CRF.DataSequence;
import iitb.CRF.FeatureGeneratorNested;
import iitb.CRF.NestedCRF;
import iitb.Model.EdgeFeatures;
import iitb.Model.NestedFeatureGenImpl;
import iitb.Model.StartFeatures;
import java.util.Iterator;
import java.util.Properties;

public class SegmentCRFLearner
extends CRFLearner
implements BatchSegmenterLearner,
SequenceConstants,
Segmenter {
    static final long serialVersionUID = 20080207L;
    static int negativeClass = 0;
    int maxMemory;
    NestedCRF nestedCrfModel;

    public SegmentCRFLearner() {
        this("");
    }

    public SegmentCRFLearner(String args) {
        super(args);
    }

    DataIter allocModel(SegmentDataset dataset) throws Exception {
        this.maxMemory = dataset.getMaxWindowSize();
        this.options.setProperty("MaxMemory", "" + this.maxMemory);
        negativeClass = this.schema.getClassIndex("NEG");
        this.featureGen = new SemiMTFeatureGenImpl(this.schema.getNumberOfClasses(), this.schema.validClassNames(), this.options);
        this.nestedCrfModel = new NestedCRF(this.featureGen.numStates(), (FeatureGeneratorNested)this.featureGen, this.options);
        this.crfModel = this.nestedCrfModel;
        return new CRFSegmentDataIter(dataset);
    }

    public Segmenter batchTrain(SegmentDataset dataset) {
        try {
            this.schema = dataset.getSchema();
            this.doTrain(this.allocModel(dataset));
            return this;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("error in CRF: " + e);
        }
    }

    public Segmentation segmentation(CandidateSegmentGroup g) {
        SegmentDataSequence seq = new SegmentDataSequence(g);
        this.nestedCrfModel.apply(seq);
        return seq.getSegments();
    }

    public String explain(CandidateSegmentGroup g) {
        return "not supported";
    }

    public class SemiMTFeatureGenImpl
    extends NestedFeatureGenImpl {
        static final long serialVersionUID = 20080207L;

        public SemiMTFeatureGenImpl(int numLabels, String[] labelNames, Properties options) throws Exception {
            super(numLabels, options, false);
            Object[] features = new Feature[labelNames.length];
            for (int i = 0; i < labelNames.length; ++i) {
                features[i] = new Feature(new String[]{"previousLabel", "1", labelNames[i]});
            }
            this.addFeature(new EdgeFeatures(this, features));
            this.addFeature(new StartFeatures(this, new Feature(new String[]{"previousLabel", "1", "null"})));
            this.addFeature(new NestedMTFeatureTypes(this));
        }
    }

    class NestedMTFeatureTypes
    extends CRFLearner.MTFeatureTypes {
        static final long serialVersionUID = 20080207L;

        NestedMTFeatureTypes(NestedFeatureGenImpl gen) {
            super(gen);
        }

        public boolean startScanFeaturesAt(DataSequence data, int prevPos, int pos) {
            SegmentDataSequence segData = (SegmentDataSequence)data;
            this.example = segData.segs.getSubsequenceInstance(prevPos + 1, pos + 1);
            this.featureLooper = this.example.featureIterator();
            return this.startScan();
        }
    }

    class CRFSegmentDataIter
    implements DataIter {
        Iterator<CandidateSegmentGroup> iter;
        SegmentDataset dataset;
        SegmentDataSequence segData;

        CRFSegmentDataIter(SegmentDataset ds) {
            this.dataset = ds;
            this.segData = new SegmentDataSequence();
        }

        public void startScan() {
            this.iter = this.dataset.candidateSegmentGroupIterator();
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public DataSequence next() {
            this.segData.init(this.iter.next());
            return this.segData;
        }
    }

    class SegmentDataSequence
    implements iitb.CRF.SegmentDataSequence {
        CandidateSegmentGroup segs;
        int[] labels = null;
        int[] segLengths;

        SegmentDataSequence(CandidateSegmentGroup tokens) {
            this.segs = tokens;
            this.alloc();
        }

        SegmentDataSequence() {
        }

        void alloc() {
            if (this.labels == null || this.length() > this.labels.length) {
                this.labels = new int[this.length()];
                this.segLengths = new int[this.length()];
            }
        }

        public int length() {
            return this.segs.getSequenceLength();
        }

        void init(CandidateSegmentGroup tokens) {
            this.segs = tokens;
            this.alloc();
            block0: for (int pos = 0; pos < this.length(); ++pos) {
                this.labels[pos] = negativeClass;
                this.segLengths[pos] = 1;
                for (int len = 1; len <= tokens.getMaxWindowSize(); ++len) {
                    Instance inst = tokens.getSubsequenceInstance(pos, pos + len);
                    ClassLabel label = tokens.getSubsequenceLabel(pos, pos + len);
                    if (inst == null || label.isNegative()) continue;
                    int k = pos;
                    while (k < pos + len) {
                        this.segLengths[k] = -1;
                        this.labels[k++] = SegmentCRFLearner.this.schema.getClassIndex(label.bestClassName());
                    }
                    this.segLengths[pos] = len;
                    pos += len - 1;
                    continue block0;
                }
            }
        }

        public int y(int i) {
            return this.labels[i];
        }

        public Object x(int i) {
            return null;
        }

        public void set_y(int i, int label) {
            this.labels[i] = label;
        }

        Segmentation getSegments() {
            Segmentation segs = new Segmentation(SegmentCRFLearner.this.schema);
            for (int i = 0; i < this.length(); i += this.segLengths[i]) {
                segs.add(new Segmentation.Segment(i, i + this.segLengths[i], this.labels[i]));
            }
            return segs;
        }

        public int getSegmentEnd(int segmentStart) {
            return this.segLengths[segmentStart] + segmentStart - 1;
        }

        public void setSegment(int segmentStart, int segmentEnd, int y) {
            for (int pos = segmentStart; pos <= segmentEnd; ++pos) {
                this.labels[pos] = y;
                this.segLengths[pos] = -1;
            }
            this.segLengths[segmentStart] = segmentEnd - segmentStart + 1;
        }
    }
}

