/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.transform;

import edu.cmu.minorthird.classify.BasicFeatureIndex;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.DatasetLoader;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.WeightedSet;
import edu.cmu.minorthird.classify.algorithms.random.Estimate;
import edu.cmu.minorthird.classify.algorithms.random.Estimators;
import edu.cmu.minorthird.classify.algorithms.random.NegativeBinomial;
import edu.cmu.minorthird.classify.algorithms.random.Poisson;
import edu.cmu.minorthird.classify.transform.AbstractInstanceTransform;
import edu.cmu.minorthird.classify.transform.InstanceTransform;
import edu.cmu.minorthird.classify.transform.InstanceTransformLearner;
import edu.cmu.minorthird.classify.transform.MaskedInstance;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class D2TransformLearner
implements InstanceTransformLearner {
    private ExampleSchema schema;
    private Map<Feature, Double> T1values;
    private Map<Feature, Double> muPosExamples;
    private Map<Feature, String> featurePdf;
    private Map<Feature, Double[][]> T1valuesMany;
    private List<Double> classParameters;
    private List<Object> featureGivenClassParameters;
    private double ALPHA = 0.05;
    private int MIN_WORDS = 5;
    private int MAX_WORDS = Integer.MAX_VALUE;
    private int SAMPLE = 2500;
    private double REF_LENGTH = 100.0;
    private String PDF = "Poisson";
    private String WHAT_IF_MANY_CLASSES = "max";
    private String APPROX = "sample";

    @Override
    public void setSchema(ExampleSchema schema) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public InstanceTransform batchTrain(Dataset dataset) {
        ArrayList<Pair> pValue;
        block29: {
            Feature f;
            Iterator<Feature> i;
            BasicFeatureIndex index;
            BasicFeatureIndex index2;
            this.InitReset();
            this.schema = dataset.getSchema();
            int numberOfClasses = this.schema.getNumberOfClasses();
            if (ExampleSchema.BINARY_EXAMPLE_SCHEMA.equals(this.schema)) {
                index2 = new BasicFeatureIndex(dataset);
                double featurePrior = 1.0 / (double)index2.numberOfFeatures();
                Iterator<Feature> i2 = index2.featureIterator();
                while (i2.hasNext()) {
                    Feature f2 = i2.next();
                    double[] x = new double[dataset.size()];
                    double[] omega = new double[dataset.size()];
                    int position = 0;
                    Iterator<Example> j = dataset.iterator();
                    while (j.hasNext()) {
                        Example e = j.next();
                        x[position] = e.getWeight(f2);
                        omega[position] = this.getLength(e);
                        ++position;
                    }
                    this.setT1(f2, this.T1((int)index2.getCounts(f2, "POS"), (int)index2.getCounts(f2, "NEG")));
                    if (this.PDF.equals("Poisson")) {
                        Estimate est = Estimators.estimatePoissonWeightedLambda(x, omega, featurePrior, this.REF_LENGTH);
                        double mu = (Double)est.getPms().get("lambda");
                        this.setPosMu(f2, mu);
                        this.setFeaturePdf(f2, "Poisson");
                        continue;
                    }
                    if (!this.PDF.equals("Negative-Binomial")) continue;
                    throw new UnsupportedOperationException("error: PDF \"" + this.PDF + "\" is not implemented!");
                }
            } else {
                index2 = new BasicFeatureIndex(dataset);
                ArrayList<double[]> featureMatrix = new ArrayList<double[]>();
                ArrayList<double[]> exampleWeightMatrix = new ArrayList<double[]>();
                String[] classLabels = new String[numberOfClasses];
                int[] classSizes = new int[numberOfClasses];
                for (int i3 = 0; i3 < numberOfClasses; ++i3) {
                    classLabels[i3] = this.schema.getClassName(i3);
                    classSizes[i3] = index2.size(classLabels[i3]);
                    double[] featureCounts = new double[classSizes[i3]];
                    double[] exampleWeights = new double[classSizes[i3]];
                    featureMatrix.add(featureCounts);
                    exampleWeightMatrix.add(exampleWeights);
                }
                double numberOfExamples = dataset.size();
                double[] countsGivenClass = new double[numberOfClasses];
                double[] examplesGivenClass = new double[numberOfClasses];
                int[] excounter = new int[numberOfClasses];
                Iterator<Example> i4 = dataset.iterator();
                while (i4.hasNext()) {
                    int idx;
                    Example ex = i4.next();
                    int n = idx = this.schema.getClassIndex(ex.getLabel().bestClassName().toString());
                    examplesGivenClass[n] = examplesGivenClass[n] + 1.0;
                    Iterator<Feature> j = index2.featureIterator();
                    while (j.hasNext()) {
                        Feature f3 = j.next();
                        int n2 = idx;
                        countsGivenClass[n2] = countsGivenClass[n2] + ex.getWeight(f3);
                        double[] dArray = (double[])exampleWeightMatrix.get(idx);
                        int n3 = excounter[idx];
                        dArray[n3] = dArray[n3] + ex.getWeight(f3);
                    }
                    int n4 = idx;
                    excounter[n4] = excounter[n4] + 1;
                }
                Iterator<Feature> floo = index2.featureIterator();
                while (floo.hasNext()) {
                    double[] countsGivenExample;
                    double[] countsFeatureGivenClass;
                    double probabilityOfOccurrence;
                    Estimate est;
                    int j;
                    int[] counter = new int[numberOfClasses];
                    double[] sums = new double[numberOfClasses];
                    Feature ft = floo.next();
                    Iterator<Example> eloo = dataset.iterator();
                    while (eloo.hasNext()) {
                        int idx;
                        Example ex = eloo.next();
                        int n = idx = this.schema.getClassIndex(ex.getLabel().bestClassName().toString());
                        int n5 = counter[n];
                        counter[n] = n5 + 1;
                        ((double[])featureMatrix.get((int)idx))[n5] = ex.getWeight(ft);
                    }
                    if (this.PDF.equals("Poisson")) {
                        double featurePrior = 1.0 / (double)index2.numberOfFeatures();
                        for (j = 0; j < numberOfClasses; ++j) {
                            est = Estimators.estimateNaiveBayesMean(1.0, numberOfClasses, examplesGivenClass[j], numberOfExamples);
                            probabilityOfOccurrence = (Double)est.getPms().get("mean");
                            this.setClassParameter(j, probabilityOfOccurrence);
                            countsFeatureGivenClass = (double[])featureMatrix.get(j);
                            sums[j] = Estimators.Sum(countsFeatureGivenClass);
                            countsGivenExample = (double[])exampleWeightMatrix.get(j);
                            Estimate lambda = Estimators.estimatePoissonWeightedLambda(countsFeatureGivenClass, countsGivenExample, featurePrior, this.REF_LENGTH);
                            this.setFeatureGivenClassParameter(ft, j, lambda);
                        }
                        this.setFeaturePdf(ft, "Poisson");
                    } else if (this.PDF.equals("Negative-Binomial")) {
                        double featurePrior = 1.0 / (double)index2.numberOfFeatures();
                        for (j = 0; j < numberOfClasses; ++j) {
                            est = Estimators.estimateNaiveBayesMean(1.0, numberOfClasses, examplesGivenClass[j], numberOfExamples);
                            probabilityOfOccurrence = (Double)est.getPms().get("mean");
                            this.setClassParameter(j, probabilityOfOccurrence);
                            countsFeatureGivenClass = (double[])featureMatrix.get(j);
                            sums[j] = Estimators.Sum(countsFeatureGivenClass);
                            countsGivenExample = (double[])exampleWeightMatrix.get(j);
                            Estimate mudelta = Estimators.estimateNegativeBinomialMuDelta(countsFeatureGivenClass, countsGivenExample, featurePrior, this.REF_LENGTH);
                            this.setFeatureGivenClassParameter(ft, j, mudelta);
                        }
                        this.setFeaturePdf(ft, "Negative-Binomial");
                    }
                    for (int ci = 0; ci < numberOfClasses; ++ci) {
                        for (int cj = ci + 1; cj < numberOfClasses; ++cj) {
                            double t1 = this.T1((int)sums[ci], (int)sums[cj]);
                            this.setT1many(ft, t1, ci, cj);
                        }
                    }
                }
            }
            pValue = new ArrayList<Pair>();
            if (ExampleSchema.BINARY_EXAMPLE_SCHEMA.equals(this.schema)) {
                if (this.APPROX.equals("sample")) {
                    index = new BasicFeatureIndex(dataset);
                    i = index.featureIterator();
                    while (i.hasNext()) {
                        f = i.next();
                        double[] T1array = this.sampleT1Values(f);
                        Pair p = this.computePValue(T1array, f);
                        pValue.add(p);
                    }
                    break block29;
                } else {
                    if (this.APPROX.equals("delta-method")) {
                        throw new UnsupportedOperationException("error: Approximation \"" + this.APPROX + "\" is not implemented!");
                    }
                    if (this.APPROX.equals("saddle-point")) {
                        throw new UnsupportedOperationException("error: Approximation \"" + this.APPROX + "\" is not implemented!");
                    }
                    throw new UnsupportedOperationException("error: Approximation \"" + this.APPROX + "\" is not recognized!");
                }
            }
            if (this.WHAT_IF_MANY_CLASSES.equals("max") & this.APPROX.equals("sample")) {
                index = new BasicFeatureIndex(dataset);
                i = index.featureIterator();
            } else {
                if (this.WHAT_IF_MANY_CLASSES.equals("sum")) {
                    throw new UnsupportedOperationException("error: D^2 extension \"" + this.WHAT_IF_MANY_CLASSES + "\" is not implemented!");
                }
                throw new UnsupportedOperationException("error: D^2 extension \"" + this.WHAT_IF_MANY_CLASSES + "\" is not recognized!");
            }
            while (i.hasNext()) {
                f = i.next();
                Pair maxPair = new Pair(1.0, f);
                for (int ci = 0; ci < numberOfClasses; ++ci) {
                    for (int cj = ci + 1; cj < numberOfClasses; ++cj) {
                        double[] T1array = this.sampleT1Values(f, ci, cj);
                        Pair p = this.computePValue(T1array, f, ci, cj);
                        if (!(p.value < maxPair.value)) continue;
                        maxPair = p;
                    }
                }
                pValue.add(maxPair);
            }
        }
        Comparator<Pair> VAL_COMPARATOR = new Comparator<Pair>(){

            @Override
            public int compare(Pair p1, Pair p2) {
                if (p1.value < p2.value) {
                    return -1;
                }
                if (p1.value > p2.value) {
                    return 1;
                }
                return p1.feature.compareTo(p2.feature);
            }
        };
        final SortedMap<Feature, Integer> availableFeatures = this.selectFeaturesViaFDR(pValue, VAL_COMPARATOR);
        return new AbstractInstanceTransform(){

            public Instance transform(Instance instance) {
                return new MaskedInstance(instance, availableFeatures);
            }

            public String toString() {
                return "[InstanceTransform: model = " + D2TransformLearner.this.PDF + " by D^2]";
            }
        };
    }

    public void setFeaturePdf(Feature f, String pdf) {
        this.featurePdf.put(f, new String(pdf));
    }

    private void setT1(Feature f, double delta) {
        Double d = this.T1values.get(f);
        if (d == null) {
            this.T1values.put(f, new Double(delta));
        } else {
            System.out.println("Warning: T1 value already set for feature " + f.toString() + "!");
        }
    }

    private void setPosMu(Feature f, double delta) {
        Double d = this.muPosExamples.get(f);
        if (d == null) {
            this.muPosExamples.put(f, new Double(delta));
        } else {
            this.muPosExamples.put(f, new Double(d + delta));
        }
    }

    private double getPosMu(Feature f) {
        Double d = this.muPosExamples.get(f);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    private void setT1many(Feature f, double delta, int i, int j) {
        Double[][] d = this.T1valuesMany.get(f);
        if (d == null) {
            int N = this.schema.getNumberOfClasses();
            d = new Double[N][N];
            d[i][j] = new Double(delta);
            this.T1valuesMany.put(f, d);
        } else if (d[i][j] == null) {
            d[i][j] = new Double(delta);
        } else {
            System.out.println("Warning: T1 value already set for feature " + f.toString() + "!");
        }
    }

    public void setClassParameter(int j, double d) {
        try {
            this.classParameters.get(j);
        }
        catch (Exception x) {
            this.classParameters.add(j, new Double(d));
        }
    }

    public void setFeatureGivenClassParameter(Feature f, int j, Estimate pms) {
        try {
            Map hmap = (Map)this.featureGivenClassParameters.get(j);
            hmap.put(f, pms);
            this.featureGivenClassParameters.set(j, hmap);
        }
        catch (Exception NoHashMapforClassJ) {
            HashMap<Feature, Estimate> hmap = null;
            hmap = new HashMap<Feature, Estimate>();
            hmap.put(f, pms);
            this.featureGivenClassParameters.add(j, hmap);
        }
    }

    private void InitReset() {
        this.T1values = new TreeMap<Feature, Double>();
        this.muPosExamples = new TreeMap<Feature, Double>();
        this.featurePdf = new TreeMap<Feature, String>();
        this.classParameters = new ArrayList<Double>();
        this.T1valuesMany = new TreeMap<Feature, Double[][]>();
        this.featureGivenClassParameters = new ArrayList<Object>();
        this.featureGivenClassParameters.add(new WeightedSet());
    }

    private SortedMap<Feature, Integer> selectFeaturesViaFDR(List<Pair> pValue, Comparator<Pair> VAL_COMPARATOR) {
        int j;
        TreeMap<Feature, Integer> availableFeatures = new TreeMap<Feature, Integer>();
        Collections.sort(pValue, VAL_COMPARATOR);
        int greatestIndexBeforeAccept = -1;
        for (j = 1; j <= pValue.size(); ++j) {
            double line = (double)j * this.ALPHA / (double)pValue.size();
            if (!(line > pValue.get((int)(j - 1)).value)) continue;
            greatestIndexBeforeAccept = j - 1;
        }
        greatestIndexBeforeAccept = Math.min(this.MAX_WORDS, Math.min(pValue.size() - 1, Math.max(greatestIndexBeforeAccept, this.MIN_WORDS)));
        System.out.println("Retained " + (greatestIndexBeforeAccept + 1) + " fetures, out of " + pValue.size());
        for (j = 0; j <= greatestIndexBeforeAccept; ++j) {
            availableFeatures.put(pValue.get((int)j).feature, new Integer(1));
        }
        return availableFeatures;
    }

    private double[] sampleT1Values(Feature f) {
        double[] T1array = new double[this.SAMPLE];
        String s = this.featurePdf.get(f);
        if (s.equals("Poisson")) {
            Poisson Xp = new Poisson(this.getPosMu(f));
            Poisson Xn = new Poisson(this.getPosMu(f));
            for (int cnt = 0; cnt < this.SAMPLE; ++cnt) {
                T1array[cnt] = this.T1(Xp.nextInt(), Xn.nextInt());
            }
        } else {
            if (s.equals("Negative-Binomial")) {
                throw new UnsupportedOperationException("error: PDF \"" + this.PDF + "\" is not implemented!");
            }
            throw new IllegalStateException("Error: PDF not recognized!");
        }
        return T1array;
    }

    private double[] sampleT1Values(Feature f, int ci, int cj) {
        double[] T1array = new double[this.SAMPLE];
        String s = this.featurePdf.get(f);
        if (s.equals("Poisson")) {
            Estimate esti = (Estimate)((Map)this.featureGivenClassParameters.get(ci)).get(f);
            Estimate estj = (Estimate)((Map)this.featureGivenClassParameters.get(cj)).get(f);
            SortedMap<String, Double> pmi = esti.getPms();
            SortedMap<String, Double> pmj = estj.getPms();
            double lambdai = (Double)pmi.get("lambda");
            double lambdaj = (Double)pmj.get("lambda");
            double pci = this.classParameters.get(ci);
            double pcj = this.classParameters.get(cj);
            double lambda = pci / (pci + pcj) * lambdai + pcj / (pci + pcj) * lambdaj;
            Poisson Xi = new Poisson(lambda);
            Poisson Xj = new Poisson(lambda);
            for (int cnt = 0; cnt < this.SAMPLE; ++cnt) {
                T1array[cnt] = this.T1(Xi.nextInt(), Xj.nextInt());
            }
        } else if (s.equals("Negative-Binomial")) {
            Estimate esti = (Estimate)((Map)this.featureGivenClassParameters.get(ci)).get(f);
            Estimate estj = (Estimate)((Map)this.featureGivenClassParameters.get(cj)).get(f);
            SortedMap<String, Double> pmi = esti.getPms();
            SortedMap<String, Double> pmj = estj.getPms();
            TreeMap<String, Number> npi = this.mudelta2np((Double)pmi.get("mu"), (Double)pmi.get("delta"), 1.0);
            TreeMap<String, Number> npj = this.mudelta2np((Double)pmj.get("mu"), (Double)pmj.get("delta"), 1.0);
            NegativeBinomial Xi = new NegativeBinomial((Integer)npi.get("n"), (Double)npi.get("p"));
            NegativeBinomial Xj = new NegativeBinomial((Integer)npj.get("n"), (Double)npj.get("p"));
            for (int cnt = 0; cnt < this.SAMPLE; ++cnt) {
                T1array[cnt] = this.T1(Xi.nextInt(), Xj.nextInt());
            }
        } else {
            throw new IllegalStateException("Error: PDF not implemented!");
        }
        return T1array;
    }

    private Pair computePValue(double[] t1array, Feature f) {
        Arrays.sort(t1array);
        int newLength = 0;
        for (int j = 0; j < t1array.length; ++j) {
            if (new Double(t1array[j]).isNaN()) {
                newLength = j;
                break;
            }
            newLength = t1array.length;
        }
        int greatestIndexBeforeT1Observed = 0;
        for (int j = 0; j < t1array.length; ++j) {
            if (!(t1array[j] < this.T1values.get(f))) continue;
            greatestIndexBeforeT1Observed = j;
        }
        Pair p = new Pair((double)(newLength - greatestIndexBeforeT1Observed) / (double)newLength, f);
        return p;
    }

    private Pair computePValue(double[] t1array, Feature f, int ci, int cj) {
        Arrays.sort(t1array);
        int newLength = 0;
        for (int j = 0; j < t1array.length; ++j) {
            if (new Double(t1array[j]).isNaN()) {
                newLength = j;
                break;
            }
            newLength = t1array.length;
        }
        int greatestIndexBeforeT1Observed = 0;
        for (int j = 0; j < t1array.length; ++j) {
            Double[][] observedT1 = this.T1valuesMany.get(f);
            if (!(t1array[j] < observedT1[ci][cj])) continue;
            greatestIndexBeforeT1Observed = j;
        }
        Pair p = new Pair((double)(newLength - greatestIndexBeforeT1Observed) / (double)newLength, f);
        return p;
    }

    public TreeMap<String, Number> mudelta2np(double mu, double delta, double omega) {
        TreeMap<String, Number> np = new TreeMap<String, Number>();
        int n = (int)Math.ceil(new Double(mu / delta));
        np.put("n", new Integer(n));
        double p = omega * delta;
        np.put("p", new Double(p));
        return np;
    }

    public double getLength(Example e) {
        double len = 0.0;
        Iterator<Feature> i = e.featureIterator();
        while (i.hasNext()) {
            Feature f = i.next();
            len += e.getWeight(f);
        }
        return len;
    }

    public double T1(int x1, int x2) {
        double dx1 = new Integer(x1).doubleValue();
        double dx2 = new Integer(x2).doubleValue();
        double t = Math.pow(dx1 - dx2, 2.0) / (dx1 + dx2);
        return t;
    }

    public void setREF_LENGTH(double desiredLength) {
        this.REF_LENGTH = desiredLength;
    }

    public void setPDF(String pdf) {
        this.PDF = pdf;
    }

    public void setMIN_WORDS(int number) {
        this.MIN_WORDS = number;
    }

    public void setMAX_WORDS(int number) {
        this.MAX_WORDS = number;
    }

    public void setSAMPLE(int size) {
        this.SAMPLE = size;
    }

    public void setALPHA(double desiredLevel) {
        this.ALPHA = desiredLevel;
    }

    public static void main(String[] args) {
        String path = "/Users/eairoldi/cmu.research/8.Text.Learning.Group/src.MISC/";
        String fout = "eda-test2.txt";
        try {
            File outFile = new File(path + fout);
            new PrintStream(new FileOutputStream(outFile));
            File dataFile = new File(path + "webmaster.3rd");
            Dataset data = DatasetLoader.loadFile(dataFile);
            D2TransformLearner f = new D2TransformLearner();
            f.setREF_LENGTH(100.0);
            f.setSAMPLE(10000);
            f.setALPHA(0.01);
            f.setMIN_WORDS(14);
            f.setMAX_WORDS(14);
            InstanceTransform d2 = f.batchTrain(data);
            data = d2.transform(data);
            BasicFeatureIndex idx = new BasicFeatureIndex(data);
            Iterator<Feature> i = idx.featureIterator();
            while (i.hasNext()) {
                Feature ft = i.next();
                System.out.println(ft);
            }
        }
        catch (Exception x) {
            System.out.println("error:\n" + x);
        }
    }

    private class Pair {
        double value;
        Feature feature;

        public Pair(double v, Feature f) {
            this.value = v;
            this.feature = f;
        }

        public String toString() {
            return "[ " + this.value + "," + this.feature + " ]";
        }
    }
}

