/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.transform;

import com.wcohen.ss.DistanceLearnerFactory;
import com.wcohen.ss.api.StringDistance;
import com.wcohen.ss.api.StringDistanceLearner;
import com.wcohen.ss.lookup.SoftDictionary;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.transform.DictionaryTransform;
import edu.cmu.minorthird.classify.transform.InstanceTransform;
import java.util.Iterator;

public class LeaveOneOutDictTransformLearner {
    public static final String[] DEFAULT_PATTERN = new String[]{"eq", "lc"};
    private String[] featurePattern;
    private boolean buildDictionaryForNegativeClass = false;
    private StringDistance[][] distances;
    String distanceNames;

    public LeaveOneOutDictTransformLearner() {
        this("SoftTFIDF");
    }

    public LeaveOneOutDictTransformLearner(String distanceNames) {
        this(DEFAULT_PATTERN, distanceNames);
    }

    public LeaveOneOutDictTransformLearner(String[] featurePattern) {
        this(featurePattern, "SoftTFIDF");
    }

    public LeaveOneOutDictTransformLearner(String[] featurePattern, String distanceNames) {
        this.featurePattern = featurePattern;
        this.distanceNames = distanceNames;
    }

    public void setSchema(ExampleSchema schema) {
    }

    public void trainDistances(ExampleSchema schema, SoftDictionary[] softDict) {
        int i;
        this.distances = new StringDistance[schema.getNumberOfClasses()][0];
        for (i = 0; i < schema.getNumberOfClasses(); ++i) {
            this.distances[i] = DistanceLearnerFactory.buildArray(this.distanceNames);
        }
        for (i = 0; i < schema.getNumberOfClasses(); ++i) {
            for (int d = 0; d < this.distances[i].length; ++d) {
                if (!(this.distances[i][d] instanceof StringDistanceLearner)) continue;
                this.distances[i][d] = softDict[i].getTeacher().train((StringDistanceLearner)((Object)this.distances[i][d]));
            }
        }
    }

    public InstanceTransform batchTrain(Dataset dataset) {
        ExampleSchema schema = dataset.getSchema();
        int yNeg = schema.getClassIndex("NEG");
        SoftDictionary[] softDict = new SoftDictionary[schema.getNumberOfClasses()];
        for (int i = 0; i < schema.getNumberOfClasses(); ++i) {
            softDict[i] = new SoftDictionary();
        }
        Iterator<Example> i = dataset.iterator();
        while (i.hasNext()) {
            Example ex = i.next();
            String text = DictionaryTransform.getFeatureValue(ex, this.featurePattern);
            if (text == null) continue;
            int y = schema.getClassIndex(ex.getLabel().bestClassName());
            if (!this.buildDictionaryForNegativeClass && y == yNeg) continue;
            softDict[y].put(ex.getSubpopulationId(), text, (Object)ex);
        }
        this.trainDistances(schema, softDict);
        return new DictionaryTransform(schema, softDict, this.featurePattern, this.distances);
    }
}

