/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.transform;

import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.DatasetIndex;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.SampleDatasets;
import edu.cmu.minorthird.classify.transform.InstanceTransform;
import edu.cmu.minorthird.classify.transform.InstanceTransformLearner;
import edu.cmu.minorthird.classify.transform.OrderBasedInstanceTransform;
import java.util.Iterator;

public class OrderBasedTransformLearner
implements InstanceTransformLearner {
    private String frequencyModel;

    public OrderBasedTransformLearner() {
        this.frequencyModel = "document";
    }

    public OrderBasedTransformLearner(String model) {
        this.frequencyModel = model;
    }

    public void setSchema(ExampleSchema schema) {
        if (!ExampleSchema.BINARY_EXAMPLE_SCHEMA.equals(schema)) {
            throw new IllegalStateException("can only learn binary example data");
        }
    }

    public InstanceTransform batchTrain(Dataset dataset) {
        OrderBasedInstanceTransform filter = new OrderBasedInstanceTransform();
        DatasetIndex index = new DatasetIndex(dataset);
        if (this.frequencyModel.equals("document")) {
            Iterator<Feature> i = index.featureIterator();
            while (i.hasNext()) {
                Feature f = i.next();
                double value = index.size(f);
                filter.addFeatureVal(value, f);
            }
        } else if (this.frequencyModel.equals("word")) {
            Iterator<Feature> i = index.featureIterator();
            while (i.hasNext()) {
                Feature f = i.next();
                double value = 0.0;
                for (int j = 0; j < index.size(f); ++j) {
                    value += index.getExample(f, j).getWeight(f);
                }
                filter.addFeatureVal(value, f);
            }
        } else {
            System.out.println("warning: " + this.frequencyModel + " is an unknown model for frequency!");
            System.exit(1);
        }
        return filter;
    }

    public static void main(String[] args) {
        Dataset dataset = SampleDatasets.sampleData("toy", false);
        System.out.println("old data:\n" + dataset);
        OrderBasedTransformLearner learner = new OrderBasedTransformLearner("word");
        OrderBasedInstanceTransform filter = (OrderBasedInstanceTransform)learner.batchTrain(dataset);
        filter.setNumberOfFeatures(2);
        dataset = filter.transform(dataset);
        System.out.println("new data:\n" + dataset);
    }
}

