/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.transform;

import edu.cmu.minorthird.classify.BatchClassifierLearner;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.algorithms.linear.MaxEntLearner;
import edu.cmu.minorthird.classify.transform.FrequencyBasedTransformLearner;
import edu.cmu.minorthird.classify.transform.InstanceTransform;
import edu.cmu.minorthird.classify.transform.InstanceTransformLearner;
import edu.cmu.minorthird.classify.transform.TransformingClassifier;

public class TransformingBatchLearner
extends BatchClassifierLearner {
    private InstanceTransformLearner transformLearner;
    private BatchClassifierLearner classifierLearner;

    public TransformingBatchLearner() {
        this(new FrequencyBasedTransformLearner(3), new MaxEntLearner());
    }

    public void setTransformLearner(InstanceTransformLearner learner) {
        this.transformLearner = learner;
    }

    public InstanceTransformLearner getTransformLearner() {
        return this.transformLearner;
    }

    public void setClassifierLearner(BatchClassifierLearner learner) {
        this.classifierLearner = learner;
    }

    public BatchClassifierLearner getClassifierLearner() {
        return this.classifierLearner;
    }

    public void setSchema(ExampleSchema schema) {
        this.classifierLearner.setSchema(schema);
    }

    public ExampleSchema getSchema() {
        return this.classifierLearner.getSchema();
    }

    public TransformingBatchLearner(InstanceTransformLearner transformLearner, BatchClassifierLearner classifierLearner) {
        this.transformLearner = transformLearner;
        this.classifierLearner = classifierLearner;
    }

    public Classifier batchTrain(Dataset dataset) {
        InstanceTransform transformer = this.transformLearner.batchTrain(dataset);
        Classifier classifier = this.classifierLearner.batchTrain(transformer.transform(dataset));
        return new TransformingClassifier(classifier, transformer);
    }
}

