/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.text.BasicSpan;
import edu.cmu.minorthird.text.Document;
import edu.cmu.minorthird.text.MutableTextBase;
import edu.cmu.minorthird.text.RegexTokenizer;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextToken;
import edu.cmu.minorthird.text.Tokenizer;
import java.io.Serializable;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicTextBase
extends MutableTextBase
implements Serializable {
    static Logger log = Logger.getLogger(BasicTextBase.class);
    private static final long serialVersionUID = 20080202L;
    private SortedMap<String, Document> documentMap = new TreeMap<String, Document>();
    private SortedMap<String, String> documentGroupMap = new TreeMap<String, String>();

    public BasicTextBase() {
        super(new RegexTokenizer());
    }

    public BasicTextBase(Tokenizer t) {
        super(t);
    }

    @Override
    public void loadDocument(String documentId, String documentString) {
        Document document = new Document(documentId, documentString);
        TextToken[] tokenArray = this.getTokenizer().splitIntoTokens(document);
        document.setTokens(tokenArray);
        this.documentMap.put(documentId, document);
    }

    @Override
    public void loadDocument(String documentId, String documentString, int charOffset) {
        Document document = new Document(documentId, documentString, charOffset);
        TextToken[] tokenArray = this.getTokenizer().splitIntoTokens(document);
        document.setTokens(tokenArray);
        this.documentMap.put(documentId, document);
    }

    @Override
    public void setDocumentGroupId(String documentId, String documentGroupId) {
        this.documentGroupMap.put(documentId, documentGroupId);
    }

    @Override
    public int size() {
        return this.documentMap.size();
    }

    @Override
    public Document getDocument(String documentId) {
        return (Document)this.documentMap.get(documentId);
    }

    @Override
    public Span documentSpan(String documentId) {
        TextToken[] textTokens = this.getTokenArray(documentId);
        if (textTokens == null) {
            return null;
        }
        return new BasicSpan(documentId, textTokens, 0, textTokens.length, (String)this.documentGroupMap.get(documentId));
    }

    @Override
    public Iterator<Span> documentSpanIterator() {
        return new MyDocumentSpanIterator();
    }

    private int getOffset(String documentId) {
        Document document = (Document)this.documentMap.get(documentId);
        if (document != null) {
            return document.charOffset;
        }
        return -1;
    }

    private TextToken[] getTokenArray(String documentId) {
        Document document = (Document)this.documentMap.get(documentId);
        if (document != null) {
            return document.getTokens();
        }
        return null;
    }

    public static void main(String[] args) {
        BasicTextBase b = new BasicTextBase();
        for (int i = 0; i < args.length; ++i) {
            b.loadDocument("arg_" + i, args[i]);
        }
        Iterator<Span> i = b.documentSpanIterator();
        while (i.hasNext()) {
            System.out.println(i.next());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyDocumentSpanIterator
    implements Iterator<Span> {
        private Iterator<String> k;

        private MyDocumentSpanIterator() {
            this.k = BasicTextBase.this.documentMap.keySet().iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove documents from a TextBase.");
        }

        @Override
        public boolean hasNext() {
            return this.k.hasNext();
        }

        @Override
        public Span next() {
            String documentId = this.k.next();
            TextToken[] textTokens = BasicTextBase.this.getTokenArray(documentId);
            BasicSpan s = new BasicSpan(documentId, textTokens, 0, textTokens.length, (String)BasicTextBase.this.documentGroupMap.get(documentId));
            s.setCharOffset(BasicTextBase.this.getOffset(documentId));
            return s;
        }

        public int estimatedSize() {
            return BasicTextBase.this.documentMap.keySet().size();
        }
    }
}

