/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.text.Annotator;
import edu.cmu.minorthird.text.AnnotatorLoader;
import edu.cmu.minorthird.text.BasicTextBase;
import edu.cmu.minorthird.text.DefaultAnnotatorLoader;
import edu.cmu.minorthird.text.Details;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.MutableTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.TextLabelsLoader;
import edu.cmu.minorthird.text.Token;
import edu.cmu.minorthird.text.Tokenizer;
import edu.cmu.minorthird.text.Trie;
import edu.cmu.minorthird.text.gui.ZoomingTextLabelsViewer;
import edu.cmu.minorthird.util.Saveable;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.Visible;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicTextLabels
implements MutableTextLabels,
Serializable,
Visible,
Saveable {
    private static final long serialVersionUID = 20080303L;
    private static Logger log = Logger.getLogger(BasicTextLabels.class);
    private Map<Token, SortedMap<String, String>> textTokenPropertyMap = new HashMap<Token, SortedMap<String, String>>();
    private Set<String> textTokenPropertySet = new HashSet<String>();
    private Map<Span, SortedMap<String, String>> spanPropertyMap = new HashMap<Span, SortedMap<String, String>>();
    private Map<String, SortedSet<Span>> spansWithSomePropertyByDocId = new HashMap<String, SortedSet<Span>>();
    private Set<String> spanPropertySet = new HashSet<String>();
    private Map<String, SortedMap<String, SortedSet<Span>>> typeDocumentSetMap = new TreeMap<String, SortedMap<String, SortedSet<Span>>>();
    private Map<String, SortedMap<String, SortedSet<Span>>> closureDocumentSetMap = new HashMap<String, SortedMap<String, SortedSet<Span>>>();
    private Map<String, Set<String>> textTokenDictMap = new HashMap<String, Set<String>>();
    private Set<String> annotatedBySet = new HashSet<String>();
    private Map<ObjectStringKey<?>, Details> detailMap = new TreeMap();
    private AnnotatorLoader loader = new DefaultAnnotatorLoader();
    public Trie trie = null;
    private transient TextBase textBase = null;
    private static final String FORMAT_NAME = "Minorthird TextLabels";

    public BasicTextLabels() {
        this.textBase = null;
    }

    public BasicTextLabels(TextBase textBase) {
        this.textBase = textBase;
    }

    @Override
    public TextBase getTextBase() {
        return this.textBase;
    }

    @Override
    public boolean hasDictionary(String dictionary) {
        return this.textTokenDictMap.containsKey(dictionary);
    }

    @Override
    public void setTextBase(TextBase textBase) {
        if (this.textBase != null) {
            throw new IllegalStateException("textBase already set");
        }
        this.textBase = textBase;
    }

    public BasicTextLabels(String s) {
        this(new BasicTextBase());
        ((BasicTextBase)this.getTextBase()).loadDocument("nullId", s);
    }

    @Override
    public boolean isAnnotatedBy(String s) {
        return this.annotatedBySet.contains(s);
    }

    @Override
    public void setAnnotatedBy(String s) {
        this.annotatedBySet.add(s);
    }

    @Override
    public void setAnnotatorLoader(AnnotatorLoader newLoader) {
        this.loader = newLoader;
    }

    @Override
    public AnnotatorLoader getAnnotatorLoader() {
        return this.loader;
    }

    @Override
    public void require(String annotationType, String fileToLoad) {
        this.require(annotationType, fileToLoad, this.loader);
    }

    @Override
    public void require(String annotationType, String fileToLoad, AnnotatorLoader theLoader) {
        BasicTextLabels.doRequire(this, annotationType, fileToLoad, theLoader);
    }

    public static void doRequire(MonotonicTextLabels labels, String annotationType, String fileToLoad, AnnotatorLoader theLoader) {
        if (annotationType != null && !labels.isAnnotatedBy(annotationType)) {
            Annotator annotator;
            if (theLoader == null) {
                theLoader = labels.getAnnotatorLoader();
            }
            if ((annotator = theLoader.findAnnotator(annotationType, fileToLoad)) == null) {
                throw new IllegalArgumentException("can't find annotator " + annotationType + " (file: " + fileToLoad + ")");
            }
            AnnotatorLoader savedLoader = labels.getAnnotatorLoader();
            labels.setAnnotatorLoader(theLoader);
            annotator.annotate(labels);
            labels.setAnnotatorLoader(savedLoader);
            if (!labels.isAnnotatedBy(annotationType)) {
                throw new IllegalStateException("didn't provide annotation type: " + annotationType);
            }
        }
    }

    @Override
    public void annotateWith(String annotationType, String fileToLoad) {
        BasicTextLabels.annotateWith(this, annotationType, fileToLoad);
    }

    public static void annotateWith(MonotonicTextLabels labels, String annotationType, String fileToLoad) {
        AnnotatorLoader theLoader = labels.getAnnotatorLoader();
        Annotator annotator = theLoader.findAnnotator(annotationType, fileToLoad);
        annotator.annotate(labels);
    }

    @Override
    public boolean inDict(Token token, String dictName) {
        if (token.getValue() == null) {
            throw new IllegalArgumentException("null token.value?");
        }
        Set<String> set = this.textTokenDictMap.get(dictName);
        if (set == null) {
            throw new IllegalArgumentException("undefined dictionary " + dictName);
        }
        return set.contains(token.getValue());
    }

    @Override
    public void defineDictionary(String dictName, Set<String> dictionary) {
        this.textTokenDictMap.put(dictName, dictionary);
        if (log.isDebugEnabled()) {
            log.debug("added to token dictionary: " + dictName + " values " + this.textTokenDictMap.get(dictName));
        }
    }

    @Override
    public void defineDictionary(String dictName, List<String> fileNames, boolean ignoreCase) {
        HashSet<String> wordSet = new HashSet<String>();
        AnnotatorLoader theLoader = this.getAnnotatorLoader();
        Tokenizer tok = this.getTextBase().getTokenizer();
        for (int i = 0; i < fileNames.size(); ++i) {
            String fileName = fileNames.get(i);
            InputStream stream = theLoader.findFileResource(fileName);
            try {
                LineNumberReader bReader = new LineNumberReader(new BufferedReader(new InputStreamReader(stream)));
                String s = null;
                while ((s = bReader.readLine()) != null) {
                    String[] currentEntryTokens = tok.splitIntoTokens(s = s.trim());
                    if (currentEntryTokens.length > 1) {
                        log.warn("Ignoring entry: '" + s + "' because it contains more than 1 token.  Use a Trie to match against sequences of tokens.");
                        continue;
                    }
                    if (ignoreCase) {
                        s = s.toLowerCase();
                    }
                    wordSet.add(s);
                }
                bReader.close();
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        this.defineDictionary(dictName, wordSet);
    }

    @Override
    public Trie getTrie() {
        return this.trie;
    }

    @Override
    public void defineTrie(List<String> phraseList) {
        this.trie = new Trie();
        Tokenizer tokenizer = this.getTextBase().getTokenizer();
        for (int i = 0; i < phraseList.size(); ++i) {
            String[] toks = tokenizer.splitIntoTokens(phraseList.get(i));
            if (toks.length <= 2 || !"\"".equals(toks[0]) || !"\"".equals(toks[toks.length - 1])) {
                this.trie.addWords("phrase#" + i, toks);
                continue;
            }
            StringBuffer defFile = new StringBuffer("");
            for (int j = 1; j < toks.length - 1; ++j) {
                defFile.append(toks[j]);
            }
            AnnotatorLoader theLoader = this.getAnnotatorLoader();
            InputStream stream = theLoader.findFileResource(defFile.toString());
            try {
                LineNumberReader bReader = new LineNumberReader(new BufferedReader(new InputStreamReader(stream)));
                String s = null;
                int line = 0;
                while ((s = bReader.readLine()) != null) {
                    String[] words = tokenizer.splitIntoTokens(s);
                    this.trie.addWords(defFile + ".line." + ++line, words);
                }
                bReader.close();
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    @Override
    public String getProperty(Token token, String prop) {
        return (String)this.getPropMap(token).get(prop);
    }

    @Override
    public Set<String> getTokenProperties() {
        return this.textTokenPropertySet;
    }

    @Override
    public void setProperty(Token textToken, String prop, String value) {
        this.getPropMap(textToken).put(prop, value);
        this.textTokenPropertySet.add(prop);
    }

    @Override
    public void setProperty(Token textToken, String prop, String value, Details details) {
        this.setProperty(textToken, prop, value);
        if (details != null) {
            this.detailMap.put(new TokenPropKey(textToken, prop), details);
        }
    }

    private SortedMap<String, String> getPropMap(Token textToken) {
        SortedMap<String, String> map = this.textTokenPropertyMap.get(textToken);
        if (map == null) {
            map = new TreeMap<String, String>();
            this.textTokenPropertyMap.put(textToken, map);
        }
        return map;
    }

    @Override
    public String getProperty(Span span, String prop) {
        return (String)this.getPropMap(span).get(prop);
    }

    @Override
    public Set<String> getSpanProperties() {
        return this.spanPropertySet;
    }

    @Override
    public Iterator<Span> getSpansWithProperty(String prop) {
        TreeSet<Span> accum = new TreeSet<Span>();
        for (Span s : this.spanPropertyMap.keySet()) {
            if (this.getProperty(s, prop) == null) continue;
            accum.add(s);
        }
        return accum.iterator();
    }

    @Override
    public Iterator<Span> getSpansWithProperty(String prop, String id) {
        SortedSet<Span> set = this.spansWithSomePropertyByDocId.get(id);
        if (set == null) {
            return Collections.EMPTY_SET.iterator();
        }
        TreeSet<Span> accum = new TreeSet<Span>();
        for (Span s : set) {
            if (this.getProperty(s, prop) == null) continue;
            accum.add(s);
        }
        return accum.iterator();
    }

    @Override
    public void setProperty(Span span, String prop, String value) {
        this.getPropMap(span).put(prop, value);
        this.spanPropertySet.add(prop);
        SortedSet<Span> set = this.spansWithSomePropertyByDocId.get(span.getDocumentId());
        if (set == null) {
            set = new TreeSet<Span>();
            this.spansWithSomePropertyByDocId.put(span.getDocumentId(), set);
        }
        set.add(span);
    }

    @Override
    public void setProperty(Span span, String prop, String value, Details details) {
        this.setProperty(span, prop, value);
        if (details != null) {
            this.detailMap.put(new SpanPropKey(span, prop), details);
        }
    }

    private SortedMap<String, String> getPropMap(Span span) {
        SortedMap<String, String> map = this.spanPropertyMap.get(span);
        if (map == null) {
            map = new TreeMap<String, String>();
            this.spanPropertyMap.put(span, map);
        }
        return map;
    }

    @Override
    public boolean hasType(Span span, String type) {
        return this.getTypeSet(type, span.getDocumentId()).contains(span);
    }

    @Override
    public void addToType(Span span, String type) {
        if (type == null) {
            throw new IllegalArgumentException("null type added");
        }
        this.lookupTypeSet(type, span.getDocumentId()).add(span);
    }

    @Override
    public void addToType(Span span, String type, Details details) {
        this.addToType(span, type);
        if (details != null) {
            this.detailMap.put(new SpanTypeKey(span, type), details);
        }
    }

    @Override
    public Set<String> getTypes() {
        return this.typeDocumentSetMap.keySet();
    }

    @Override
    public boolean isType(String type) {
        return this.typeDocumentSetMap.get(type) != null;
    }

    @Override
    public void declareType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("null type declared");
        }
        if (!this.isType(type)) {
            this.typeDocumentSetMap.put(type, new TreeMap());
        }
    }

    @Override
    public Iterator<Span> instanceIterator(String type) {
        return new MyNestedSpanLooper(type, false);
    }

    @Override
    public Iterator<Span> instanceIterator(String type, String documentId) {
        if (documentId != null) {
            return this.getTypeSet(type, documentId).iterator();
        }
        return this.instanceIterator(type);
    }

    @Override
    public void defineTypeInside(String type, Span s, Iterator<Span> i) {
        if (type == null || s.getDocumentId() == null) {
            throw new IllegalArgumentException("null type defined");
        }
        Set<Span> set = this.lookupTypeSet(type, s.getDocumentId());
        Iterator<Span> j = set.iterator();
        while (j.hasNext()) {
            Span t = j.next();
            if (!s.contains(t)) continue;
            j.remove();
        }
        while (i.hasNext()) {
            set.add(i.next());
        }
        this.closeTypeInside(type, s);
    }

    @Override
    public Details getDetails(Span span, String type) {
        SpanTypeKey key = new SpanTypeKey(span, type);
        Details details = this.detailMap.get(key);
        if (details != null) {
            return details;
        }
        return this.hasType(span, type) ? Details.DEFAULT : null;
    }

    protected Set<Span> lookupTypeSet(String type, String documentId) {
        TreeSet set;
        if (type == null || documentId == null) {
            throw new IllegalArgumentException("null type?");
        }
        SortedMap<String, SortedSet<Span>> documentsWithType = this.typeDocumentSetMap.get(type);
        if (documentsWithType == null) {
            documentsWithType = new TreeMap<String, SortedSet<Span>>();
            this.typeDocumentSetMap.put(type, documentsWithType);
        }
        if ((set = (TreeSet)documentsWithType.get(documentId)) == null) {
            set = new TreeSet();
            documentsWithType.put(documentId, set);
        }
        return set;
    }

    @Override
    public Set<Span> getTypeSet(String type, String documentId) {
        if (type == null || documentId == null) {
            throw new IllegalArgumentException("null type?");
        }
        SortedMap<String, SortedSet<Span>> documentsWithType = this.typeDocumentSetMap.get(type);
        if (documentsWithType == null) {
            return Collections.EMPTY_SET;
        }
        SortedSet set = (SortedSet)documentsWithType.get(documentId);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    @Override
    public Iterator<Span> closureIterator(String type) {
        return new MyNestedSpanLooper(type, true);
    }

    @Override
    public Iterator<Span> closureIterator(String type, String documentId) {
        if (documentId != null) {
            return this.getClosureSet(type, documentId).iterator();
        }
        return this.closureIterator(type);
    }

    @Override
    public void closeTypeInside(String type, Span s) {
        this.getClosureSet(type, s.getDocumentId()).add(s);
    }

    private Set<Span> getClosureSet(String type, String documentId) {
        TreeSet set;
        SortedMap<String, SortedSet<Span>> documentsWithClosure = this.closureDocumentSetMap.get(type);
        if (documentsWithClosure == null) {
            documentsWithClosure = new TreeMap<String, SortedSet<Span>>();
            this.closureDocumentSetMap.put(type, documentsWithClosure);
        }
        if ((set = (TreeSet)documentsWithClosure.get(documentId)) == null) {
            set = new TreeSet();
            documentsWithClosure.put(documentId, set);
        }
        return set;
    }

    public String toString() {
        return "[BasicTextLabels " + this.typeDocumentSetMap + "]";
    }

    @Override
    public String showTokenProp(TextBase base, String prop) {
        StringBuffer buf = new StringBuffer();
        Iterator<Span> i = base.documentSpanIterator();
        while (i.hasNext()) {
            Span span = i.next();
            for (int j = 0; j < span.size(); ++j) {
                Token textToken = span.getToken(j);
                if (j > 0) {
                    buf.append(" ");
                }
                buf.append(textToken.getValue());
                String val = this.getProperty(textToken, prop);
                if (val == null) continue;
                buf.append(":" + val);
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    @Override
    public Viewer toGUI() {
        return new ZoomingTextLabelsViewer(this);
    }

    @Override
    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    @Override
    public String getExtensionFor(String s) {
        return ".labels";
    }

    @Override
    public void saveAs(File file, String format) throws IOException {
        if (!format.equals(FORMAT_NAME)) {
            throw new IllegalArgumentException("illegal format " + format);
        }
        new TextLabelsLoader().saveTypesAsOps(this, file);
    }

    @Override
    public Object restore(File file) throws IOException {
        throw new UnsupportedOperationException("Cannot load TextLabels object");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyNestedSpanLooper
    implements Iterator<Span> {
        private Iterator<Map.Entry<String, SortedSet<Span>>> documentIterator;
        private Iterator<Span> spanIterator;
        private Span nextSpan;
        private int estimatedSize;

        public MyNestedSpanLooper(String type, boolean getClosures) {
            SortedMap documentMap;
            SortedMap sortedMap = documentMap = getClosures ? (SortedMap)BasicTextLabels.this.closureDocumentSetMap.get(type) : (SortedMap)BasicTextLabels.this.typeDocumentSetMap.get(type);
            if (documentMap == null) {
                this.nextSpan = null;
                this.estimatedSize = 0;
            } else {
                this.documentIterator = documentMap.entrySet().iterator();
                this.estimatedSize = documentMap.entrySet().size();
                this.spanIterator = null;
                this.advance();
            }
        }

        public int estimatedSize() {
            return this.estimatedSize;
        }

        @Override
        public boolean hasNext() {
            return this.nextSpan != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("can't remove");
        }

        @Override
        public Span next() {
            Span result = this.nextSpan;
            this.advance();
            return result;
        }

        public Span nextSpan() {
            return this.next();
        }

        private void advance() {
            if (this.spanIterator != null && this.spanIterator.hasNext()) {
                this.nextSpan = this.spanIterator.next();
            } else if (this.documentIterator.hasNext()) {
                Map.Entry<String, SortedSet<Span>> entry = this.documentIterator.next();
                this.spanIterator = entry.getValue().iterator();
                this.advance();
            } else {
                this.nextSpan = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TokenPropKey
    extends ObjectStringKey<String> {
        public TokenPropKey(Token token, String prop) {
            super(BasicTextLabels.this, (Comparable)((Object)token.getValue()), prop);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SpanPropKey
    extends ObjectStringKey<Span> {
        public SpanPropKey(Span span, String prop) {
            super(BasicTextLabels.this, (Comparable)span, "prop:" + prop);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SpanTypeKey
    extends ObjectStringKey<Span> {
        public SpanTypeKey(Span span, String type) {
            super(BasicTextLabels.this, (Comparable)span, "type:" + type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectStringKey<T extends Comparable<T>>
    implements Comparable<ObjectStringKey<T>> {
        T obj;
        String str;
        final /* synthetic */ BasicTextLabels this$0;

        public ObjectStringKey(T o, String s) {
            this.this$0 = var1_1;
            this.obj = o;
            this.str = s;
        }

        @Override
        public int compareTo(ObjectStringKey<T> b) {
            String bn = b.obj.getClass().toString();
            int tmp = this.obj.getClass().toString().compareTo(bn);
            if (tmp != 0) {
                return tmp;
            }
            tmp = this.obj.compareTo(b.obj);
            if (tmp != 0) {
                return tmp;
            }
            return this.str.compareTo(b.str);
        }
    }
}

