/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.text.AbstractAnnotator;
import edu.cmu.minorthird.text.AnnotatorLoader;
import edu.cmu.minorthird.text.EncapsulatingAnnotatorLoader;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.NestedTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;

public class EncapsulatedAnnotator
extends AbstractAnnotator
implements Serializable {
    static final long serialVersionUID = 20080303L;
    private String requiredAnnotation;
    private String[] exportedTypes = null;
    private AnnotatorLoader annotatorLoader = null;

    public EncapsulatedAnnotator(String requiredAnnotation, String path) {
        this(requiredAnnotation, path, (String[])null);
    }

    public EncapsulatedAnnotator(String requiredAnnotation, String path, String type) {
        this(requiredAnnotation, path, new String[]{type});
    }

    public EncapsulatedAnnotator(String requiredAnnotation, String path, String[] exportedTypes) {
        this.requiredAnnotation = requiredAnnotation;
        this.exportedTypes = exportedTypes;
        this.annotatorLoader = new EncapsulatingAnnotatorLoader(path);
        System.out.println("will export these types: " + (exportedTypes == null ? "all" : StringUtil.toString(exportedTypes)));
    }

    protected void doAnnotate(MonotonicTextLabels labels) {
        if (this.exportedTypes == null) {
            labels.require(this.requiredAnnotation, null, this.annotatorLoader);
        } else {
            NestedTextLabels tempLabels = new NestedTextLabels(labels);
            tempLabels.require(this.requiredAnnotation, null, this.annotatorLoader);
            for (int i = 0; i < this.exportedTypes.length; ++i) {
                Iterator<Span> j = tempLabels.instanceIterator(this.exportedTypes[i]);
                while (j.hasNext()) {
                    Span span = j.next();
                    labels.addToType(span, this.exportedTypes[i]);
                }
            }
        }
    }

    public String explainAnnotation(TextLabels labels, Span documentSpan) {
        return "annotated with '" + this.requiredAnnotation + "'";
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.out.println("usage: save-file requiredAnnotation path [exportedSpan1 ... ]");
        }
        EncapsulatedAnnotator ann = null;
        if (args.length == 3) {
            ann = new EncapsulatedAnnotator(args[1], args[2]);
        } else if (args.length > 3) {
            String[] exportedTypes = new String[args.length - 3];
            for (int i = 0; i < exportedTypes.length; ++i) {
                exportedTypes[i] = args[i + 3];
            }
            ann = new EncapsulatedAnnotator(args[1], args[2], exportedTypes);
        }
        IOUtil.saveSerialized(ann, new File(args[0]));
    }
}

