/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.text.Annotator;
import edu.cmu.minorthird.text.BasicTextBase;
import edu.cmu.minorthird.text.BasicTextLabels;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.TextLabelsLoader;
import edu.cmu.minorthird.util.BasicCommandLineProcessor;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.ProgressCounter;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LabeledDirectory
implements CommandLineProcessor.Configurable {
    private static final FileFilter TEXT_FILE_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().endsWith(".txt");
        }
    };
    private File dir;
    private List<Annotator> annotatorList = new ArrayList<Annotator>();
    private List<String> requireList = new ArrayList<String>();
    private boolean resetAll = false;
    private String nameOfFileToView = null;

    public CommandLineProcessor getCLP() {
        return new MyCLP();
    }

    public LabeledDirectory() {
    }

    public LabeledDirectory(String s) {
        this.dir = this.getDirectory(s);
    }

    public LabeledDirectory(File dir) {
        this.dir = dir;
    }

    public MonotonicTextLabels getTextLabels(File f) throws IOException {
        TextBase textBase = this.getTextBase(f);
        String stem = f.getName().substring(0, f.getName().length() - ".txt".length());
        File labelFile = new File(f.getParentFile(), stem + ".labels");
        if (labelFile.exists()) {
            return new TextLabelsLoader().loadOps(textBase, labelFile);
        }
        return new BasicTextLabels(textBase);
    }

    private TextBase getTextBase(File f) throws IOException {
        String contents = IOUtil.readFile(f);
        BasicTextBase base = new BasicTextBase();
        base.loadDocument("someFile", contents);
        return base;
    }

    public void reLabelText() throws IOException {
        File[] textFiles = this.dir.listFiles(TEXT_FILE_FILTER);
        if (textFiles == null) {
            throw new IllegalArgumentException("can't list directory " + this.dir);
        }
        ProgressCounter filePC = new ProgressCounter("labeling", "file", textFiles.length);
        TextLabelsLoader loader = new TextLabelsLoader();
        for (int j = 0; j < textFiles.length; ++j) {
            File fileJ = textFiles[j];
            MonotonicTextLabels labels = this.getTextLabels(fileJ);
            if (this.resetAll) {
                labels = new BasicTextLabels(labels.getTextBase());
            }
            for (Annotator ann : this.annotatorList) {
                ann.annotate(labels);
            }
            for (String req : this.requireList) {
                labels.require(req, null);
            }
            String stem = fileJ.getName().substring(0, fileJ.getName().length() - ".txt".length());
            File labelFile = new File(this.dir, stem + ".labels");
            loader.saveTypesAsOps(labels, labelFile);
            filePC.progress();
        }
        filePC.finished();
    }

    private File getDirectory(String dirName) {
        File dir = new File(dirName);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalArgumentException("not a directory: " + dirName);
        }
        return dir;
    }

    private Annotator getAnnotator(String annotatorName) {
        File annFile = new File(annotatorName);
        try {
            return (Annotator)((Object)IOUtil.loadSerialized(annFile));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("can't load annotator " + annotatorName + ": " + ex);
        }
    }

    public static void main(String[] args) throws IOException {
        LabeledDirectory ld = new LabeledDirectory();
        ld.getCLP().processArguments(args);
        if (ld.nameOfFileToView == null) {
            ld.reLabelText();
        } else {
            MonotonicTextLabels labels = ld.getTextLabels(new File(ld.nameOfFileToView));
            new ViewerFrame(ld.nameOfFileToView, new SmartVanillaViewer(labels));
        }
    }

    public class MyCLP
    extends BasicCommandLineProcessor {
        public void dir(String s) {
            LabeledDirectory.this.dir = LabeledDirectory.this.getDirectory(s);
        }

        public void annotate(String s) {
            LabeledDirectory.this.annotatorList.add(LabeledDirectory.this.getAnnotator(s));
        }

        public void require(String s) {
            LabeledDirectory.this.requireList.add(s);
        }

        public void reset() {
            LabeledDirectory.this.resetAll = true;
        }

        public void view(String s) {
            LabeledDirectory.this.nameOfFileToView = s;
        }
    }
}

