/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.text.CharAnnotation;
import edu.cmu.minorthird.text.MutableTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.StringAnnotator;
import edu.cmu.minorthird.text.TextBaseLoader;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.TextLabelsLoader;
import edu.cmu.minorthird.text.mixup.MixupInterpreter;
import edu.cmu.minorthird.text.mixup.MixupProgram;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import montylingua.JMontyLingua;
import org.apache.log4j.Logger;

public class MinorTagger
extends StringAnnotator {
    static Logger log = Logger.getLogger(MinorTagger.class);
    private static JMontyLingua montyLingua;
    private static final File NAMEMIXUP;
    private static final File DATEMIXUP;
    private static final int DEFAULT_PORT = 9998;

    public String explainAnnotation(TextLabels labels, Span documentSpan) {
        return "no idea";
    }

    public static void main(String[] args) {
        int port = 9998;
        System.out.println("Starting MinorTagger v0.02b...");
        if (args.length > 0 && args[0].matches("\\d+")) {
            port = Integer.parseInt(args[0]);
        } else {
            System.out.println("WARN: No listening port specified, using default port!");
            System.out.println("WARN: To specify, use the port number as the first argument.");
        }
        System.out.println("Loading Part-of-Speech Tagger...");
        montyLingua = new JMontyLingua();
        System.out.println("MinorTagger Started Successfully!");
        System.out.println("Waiting for connection on port " + port + "...");
        try {
            ServerSocket echoServer = new ServerSocket(port);
            while (true) {
                Socket clientSocket = echoServer.accept();
                System.out.println("[" + new Date() + "] Connected from " + clientSocket.getRemoteSocketAddress());
                new MinorTaggerThread(clientSocket).start();
            }
        }
        catch (IOException e) {
            System.out.println(e);
            return;
        }
    }

    public MinorTagger() {
        montyLingua = new JMontyLingua();
    }

    protected CharAnnotation[] annotateString(String text) {
        ArrayList charAnnList = new ArrayList();
        String tagged = montyLingua.tag_text(text);
        log.debug("Tagged: " + tagged);
        StringTokenizer tokeTagged = new StringTokenizer(tagged, "\n ", false);
        int index = 0;
        while (tokeTagged.hasMoreTokens()) {
            String strToken = tokeTagged.nextToken();
            int sep = strToken.lastIndexOf("/");
            String word = strToken.substring(0, sep);
            log.debug("word: " + word);
            String pos = strToken.substring(sep + 1);
            log.debug("POS: " + pos);
            if (pos.endsWith("$")) {
                pos = pos.replace('$', 'S');
            }
            if (!text.trim().toLowerCase().startsWith(word.toLowerCase())) {
                word = MinorTagger.findAlternative(text, word);
            }
            if (text.trim().toLowerCase().startsWith(word.toLowerCase())) {
                word = text.trim().substring(0, word.length());
            }
            CharAnnotation charAnn = MinorTagger.makeCharAnnotation(text, word, pos, index, false);
            index = charAnn.getOffset() + charAnn.getLength();
        }
        return charAnnList.toArray(new CharAnnotation[0]);
    }

    public static String POSTag(String text) {
        StringBuffer xmlTagged = new StringBuffer();
        text = text.replaceAll("<[^<>]+>", "");
        String tagged = montyLingua.tag_text(text);
        log.debug("Tagged: " + tagged);
        StringTokenizer tokeTagged = new StringTokenizer(tagged, "\n ", false);
        while (tokeTagged.hasMoreTokens()) {
            String strToken = tokeTagged.nextToken();
            int sep = strToken.lastIndexOf("/");
            String word = strToken.substring(0, sep);
            log.debug("word: " + word);
            String pos = strToken.substring(sep + 1);
            log.debug("POS: " + pos);
            if (pos.endsWith("$")) {
                pos = pos.replace('$', 'S');
            }
            if (!text.trim().toLowerCase().startsWith(word.toLowerCase())) {
                word = MinorTagger.findAlternative(text, word);
            }
            if (text.trim().toLowerCase().startsWith(word.toLowerCase())) {
                word = text.trim().substring(0, word.length());
            }
            text = MinorTagger.substFirst(text, word, "<" + pos + ">" + word + "</" + pos + ">", false);
            log.debug("WorkingString: " + text);
            int endPointer = text.lastIndexOf("</" + pos + ">");
            if (endPointer != -1) {
                endPointer += ("</" + pos + ">").length();
            }
            log.debug("EndPointer: " + endPointer);
            if (endPointer == -1) break;
            xmlTagged.append(text.substring(0, endPointer));
            text = text.substring(endPointer);
        }
        return xmlTagged.toString();
    }

    private static CharAnnotation makeCharAnnotation(String text, String word, String pos, int startIndex, boolean caseSensitive) {
        int index = 0;
        index = caseSensitive ? text.indexOf(word, startIndex) : text.toLowerCase().indexOf(word.toLowerCase(), startIndex);
        if (index < 0) {
            return null;
        }
        return new CharAnnotation(startIndex + index, word.length(), pos);
    }

    private static String substFirst(String in, String find, String newStr, boolean caseSensitive) {
        int currIndex;
        int i;
        char[] working = in.toCharArray();
        StringBuffer sb = new StringBuffer();
        int startIndex = 0;
        startIndex = caseSensitive ? in.indexOf(find) : in.toLowerCase().indexOf(find.toLowerCase());
        if (startIndex < 0) {
            return in;
        }
        for (i = currIndex = 0; i < startIndex; ++i) {
            sb.append(working[i]);
        }
        currIndex = startIndex;
        sb.append(newStr);
        for (i = currIndex += find.length(); i < working.length; ++i) {
            sb.append(working[i]);
        }
        return sb.toString();
    }

    private static String findAlternative(String in, String word) {
        String workingString = in.trim().toLowerCase();
        String workingWord = word.toLowerCase();
        String find = word;
        if (workingWord.equals("do")) {
            if (workingString.startsWith("dunno")) {
                find = "du";
            }
        } else if (workingWord.equals("not")) {
            if (workingString.startsWith("n't")) {
                find = "n't";
            } else if (workingString.startsWith("'t")) {
                find = "'t";
            } else if (workingString.startsWith("nno")) {
                find = "n";
            }
        } else if (workingWord.equals("know")) {
            if (workingString.startsWith("no")) {
                find = "no";
            }
        } else if (workingWord.equals("your")) {
            if (workingString.startsWith("ur")) {
                find = "ur";
            }
        } else if (workingWord.equals("am")) {
            if (workingString.startsWith("'m")) {
                find = "'m";
            }
        } else if (workingWord.equals("are")) {
            if (workingString.startsWith("'re")) {
                find = "'re";
            }
        } else if (workingWord.equals("is")) {
            if (workingString.startsWith("'s")) {
                find = "'s";
            }
        } else if (workingWord.equals("would")) {
            if (workingString.startsWith("'d")) {
                find = "'d";
            }
        } else if (workingWord.equals("had")) {
            if (workingString.startsWith("'d")) {
                find = "'d";
            }
        } else if (workingWord.equals("will")) {
            if (workingString.startsWith("'ll")) {
                find = "'ll";
            } else if (workingString.startsWith("wo")) {
                find = "wo";
            }
        } else if (workingWord.equals("come")) {
            if (workingString.startsWith("c'm")) {
                find = "c'm";
            }
        } else if (workingWord.equals("you")) {
            if (workingString.startsWith("y'")) {
                find = "y'";
            } else if (workingString.startsWith("ya")) {
                find = "ya";
            }
        } else if (workingWord.equals("it")) {
            if (workingString.startsWith("'t")) {
                find = "'t";
            }
        } else if (workingWord.equals("-")) {
            if (workingString.startsWith("/")) {
                find = "/";
            }
        } else if (workingWord.equals("want")) {
            if (workingString.startsWith("wan")) {
                find = "wan";
            }
        } else if (workingWord.equals("going")) {
            if (workingString.startsWith("gon")) {
                find = "gon";
            }
        } else if (workingWord.equals("have")) {
            if (workingString.startsWith("haf")) {
                find = "haf";
            } else if (workingString.startsWith("'ve")) {
                find = "'ve";
            }
        } else if (workingWord.equals("to")) {
            if (workingString.startsWith("na")) {
                find = "na";
            } else if (workingString.startsWith("ta")) {
                find = "ta";
            }
        } else if (workingWord.equals("give")) {
            if (workingString.startsWith("gim")) {
                find = "gim";
            }
        } else if (workingWord.equals("let")) {
            if (workingString.startsWith("lem")) {
                find = "lem";
            }
        } else {
            System.err.println("POS Tagging error!");
            System.err.println("Current word:" + word);
            System.err.println("Working string:" + in);
        }
        return find;
    }

    private static String tag(String in) {
        MixupProgram p;
        if (in.replaceAll("\\s+", "").length() == 0) {
            return "";
        }
        String tagged = MinorTagger.POSTag(in);
        TextBaseLoader baseLoader = new TextBaseLoader(1, true);
        File tempFile = MinorTagger.createFile(tagged);
        try {
            baseLoader.load(tempFile);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        MutableTextLabels labels = baseLoader.getLabels();
        try {
            p = new MixupProgram(NAMEMIXUP);
            new MixupInterpreter(p).eval(labels);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        try {
            p = new MixupProgram(DATEMIXUP);
            new MixupInterpreter(p).eval(labels);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        TextLabelsLoader labelsLoader = new TextLabelsLoader();
        tagged = MinorTagger.createXML(in, labelsLoader.saveTypesAsXML(labels));
        String[] keepXML = new String[]{"CC", "CD", "DT", "EX", "FW", "IN", "JJ", "JJR", "JJS", "LS", "MD", "NN", "NNS", "NNP", "NNPS", "PDT", "POS", "PRP", "PRPS", "RB", "RBR", "RBS", "RP", "TO", "UH", "VB", "VBD", "VBG", "VBN", "VBP", "VBZ", "WDT", "WP", "WPS", "WRB", "S", "NP", "name", "extracted_date", "extracted_time"};
        tagged = MinorTagger.filterXML(tagged, keepXML);
        return tagged;
    }

    private static String filterXML(String tagged, String[] keepXML) {
        Matcher m = Pattern.compile("</?([^<>]+)>").matcher(tagged);
        HashSet<String> delXML = new HashSet<String>();
        while (m.find()) {
            if (delXML.contains(m.group(1))) continue;
            boolean keep = false;
            for (int i = 0; i < keepXML.length; ++i) {
                if (!keepXML[i].equals(m.group(1))) continue;
                keep = true;
                break;
            }
            if (keep) continue;
            delXML.add(m.group(1));
        }
        for (String del : delXML) {
            tagged = tagged.replaceAll("</?\\Q" + del + "\\E>", "");
        }
        return tagged;
    }

    /*
     * WARNING - void declaration
     */
    private static String createXML(String in, String XMLIndex) {
        HashMap<Integer, String> hash = new HashMap<Integer, String>();
        ArrayList spanList = new ArrayList();
        StringBuffer buf = new StringBuffer(in);
        Matcher m = Pattern.compile("[\r\n]  <(\\S+) lo=(\\d+) hi=(\\d+)>").matcher(XMLIndex);
        while (m.find()) {
            ArrayList<Object> span = new ArrayList<Object>();
            span.add(m.group(1));
            span.add(new Integer(m.group(2)));
            span.add(new Integer(m.group(3)));
            spanList.add(span);
        }
        Collections.sort(spanList, new Comparator<List<Object>>(){

            @Override
            public int compare(List<Object> o1, List<Object> o2) {
                Integer lo1 = (Integer)o1.get(1);
                Integer lo2 = (Integer)o2.get(1);
                Integer hi1 = (Integer)o1.get(2);
                Integer hi2 = (Integer)o2.get(2);
                if (lo1.compareTo(lo2) == 0) {
                    return hi2.compareTo(hi1);
                }
                return lo1.compareTo(lo2);
            }
        });
        for (List list : spanList) {
            String xml = (String)list.get(0);
            String start = "<" + xml + ">";
            String end = "</" + xml + ">";
            Integer lo = (Integer)list.get(1);
            Integer hi = (Integer)list.get(2);
            String temp = (String)hash.get(lo);
            hash.put(lo, (temp == null ? "" : temp) + start);
            temp = (String)hash.get(hi);
            hash.put(hi, end + (temp == null ? "" : temp));
        }
        ArrayList al = new ArrayList(hash.keySet());
        Collections.sort(al);
        boolean bl = false;
        for (Integer index : al) {
            void var8_10;
            String tags = (String)hash.get(index);
            buf.insert(index + var8_10, tags);
            var8_10 += tags.length();
        }
        return buf.toString();
    }

    private static File createFile(String content) {
        File temp = null;
        try {
            temp = File.createTempFile("tmp", "");
            temp.deleteOnExit();
            BufferedWriter bWriter = new BufferedWriter(new FileWriter(temp));
            bWriter.write(content);
            bWriter.close();
        }
        catch (IOException ioe) {
            System.err.println("Error creating temp file: " + ioe);
        }
        return temp;
    }

    static {
        NAMEMIXUP = new File("rcwangName.mixup");
        DATEMIXUP = new File("date.mixup");
    }

    private static class MinorTaggerThread
    extends Thread {
        private Socket socket = null;

        public MinorTaggerThread(Socket socket) {
            super("MinorTaggerThread");
            this.socket = socket;
        }

        public void run() {
            StringBuffer buf = new StringBuffer();
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                PrintStream os2 = new PrintStream(this.socket.getOutputStream());
                while ((line = br.readLine()) != null) {
                    boolean end_close = false;
                    boolean end_continue = false;
                    if (line.endsWith("$$$")) {
                        end_close = true;
                        line = line.substring(0, line.length() - 3);
                    } else if (line.endsWith("$$")) {
                        end_continue = true;
                        line = line.substring(0, line.length() - 2);
                    }
                    buf.append(line + "\n");
                    if (end_close || end_continue) {
                        os2.println(MinorTagger.tag(buf.toString()));
                        buf.setLength(0);
                    }
                    if (!end_close) continue;
                    os2.close();
                    br.close();
                    this.socket.close();
                    break;
                }
                System.out.println("[" + new Date() + "] Disconnected from " + this.socket.getRemoteSocketAddress());
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }
}

