/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.text.BasicTextBase;
import edu.cmu.minorthird.text.BasicTextLabels;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.MutableTextLabels;
import edu.cmu.minorthird.text.NestedTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.mixup.Mixup;
import edu.cmu.minorthird.text.mixup.MixupInterpreter;
import edu.cmu.minorthird.text.mixup.MixupProgram;
import java.util.Iterator;

public class SampleTextBases {
    private static String[] testStrings = new String[]{"Zhone Technologies Acquires NEC eLUMINANT", "Reuters to Acquire Multex", "Tumbleweed and Valicert Announce Merger Agreement", "TruSecure Corporation Acquires Vigilinx"};
    private static String[] testProgram = new String[]{"defDict companyWord = Reuters, Multex, TruSecure, Vigilinx ", "defSpanType company =: ... [a(companyWord)] ... ", "defTokenProp vp:t =: ( ... ['to'? re('^Acquires?') ] ... || ... ['Announce'] ...)", "defSpanType subj =: [!vp:t+] vp:t ...", "defSpanType obj =: !vp:t+ vp:t+ [!vp:t+]", "defSpanType start =top: ( [any{5}] any+ || [any{,5}])"};
    private static BasicTextBase base;
    private static MutableTextLabels truthLabels;
    private static MonotonicTextLabels guessLabels;

    public static TextBase getTextBase() {
        return base;
    }

    public static MutableTextLabels getTruthLabels() {
        return truthLabels;
    }

    public static MonotonicTextLabels getGuessLabels() {
        return guessLabels;
    }

    public static void showLabels(TextLabels labels) {
        System.out.println("labels has " + labels.getTypes().size() + " types");
        for (String type : labels.getTypes()) {
            Iterator<Span> j = labels.instanceIterator(type);
            while (j.hasNext()) {
                System.out.println(type + ": " + j.next());
            }
        }
    }

    static {
        try {
            base = new BasicTextBase();
            for (int i = 0; i < testStrings.length; ++i) {
                base.loadDocument("testStrings[" + i + "]", testStrings[i]);
            }
            truthLabels = new BasicTextLabels(base);
            MixupProgram prog = new MixupProgram(testProgram);
            MixupInterpreter interp = new MixupInterpreter(prog);
            interp.eval(truthLabels);
            guessLabels = new NestedTextLabels(truthLabels);
            MixupProgram guessProg = new MixupProgram(new String[]{"defSpanType guess =: [ any{2} ] ..."});
            interp.setProgram(guessProg);
            interp.eval(guessLabels);
        }
        catch (Mixup.ParseException e) {
            e.printStackTrace();
        }
    }
}

