/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.text.BasicTextLabels;
import edu.cmu.minorthird.text.MutableTextLabels;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.TextBaseLoader;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.TextLabelsLoader;
import java.io.File;
import org.apache.log4j.Logger;

public class SimpleTextLoader {
    private static Logger log = Logger.getLogger(SimpleTextLoader.class);
    public boolean labelFile = true;

    public static TextLabels load(File file, boolean externalLabelFile) {
        TextBase base = null;
        MutableTextLabels tempLabels = null;
        MutableTextLabels labels = null;
        try {
            TextBaseLoader loader;
            if (!file.isDirectory()) {
                loader = new TextBaseLoader(0, false);
                base = loader.load(file);
            } else {
                loader = new TextBaseLoader(1, true);
                base = loader.load(file);
                tempLabels = loader.getLabels();
            }
            if (base == null) {
                base = tempLabels.getTextBase();
            }
            labels = new BasicTextLabels(base);
            if (externalLabelFile) {
                String fileName = file.getName();
                if (fileName.lastIndexOf(46) >= 0) {
                    fileName = fileName.substring(0, fileName.lastIndexOf(46));
                }
                fileName = fileName + ".labels";
                File dir = file.getParentFile();
                File labelsFile = new File(dir, fileName);
                new TextLabelsLoader().importOps(labels, base, labelsFile);
            } else if (tempLabels != null) {
                labels = tempLabels;
            }
        }
        catch (Exception e) {
            log.error(e, e);
        }
        return labels;
    }

    public static TextLabels load(String fileName, boolean externalLabelFile) {
        return SimpleTextLoader.load(new File(fileName), externalLabelFile);
    }

    public TextLabels load(File file) {
        return SimpleTextLoader.load(file, this.labelFile);
    }

    public TextLabels load(String fileName) {
        return SimpleTextLoader.load(fileName, this.labelFile);
    }

    public boolean isLabelFile() {
        return this.labelFile;
    }

    public void setLabelFile(boolean labelFile) {
        this.labelFile = labelFile;
    }
}

