/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.text.FancyLoader;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.util.BasicCommandLineProcessor;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpanDifference {
    public static Logger log = Logger.getLogger(SpanDifference.class);
    public static final int MAX_STATUS = 4;
    public static final int FALSE_POS = 1;
    public static final int FALSE_NEG = 2;
    public static final int TRUE_POS = 3;
    public static final int UNKNOWN_POS = 4;
    private static final int UNMARKED = 0;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int GUESS = 1;
    private static final int TRUTH = 2;
    private static final int CLOSURE = 3;
    private static final String[] strCode = new String[]{"?", "G", "T", "C"};
    private List<DiffedSpan> diffedSpans = null;
    private SortedSet<Span> guessSet;
    private SortedSet<Span> truthSet;
    private SortedMap<String, Set<Span>> closureMap;
    double tokenFalsePos;
    double tokenFalseNeg;
    double tokenTruePos;
    double spanFalsePos;
    double spanFalseNeg;
    double spanTruePos;
    boolean performanceCacheIsValid;

    public SpanDifference(SpanDifference[] spanDifferences) {
        TreeSet<DiffedSpan> accum = new TreeSet<DiffedSpan>();
        this.spanTruePos = 0.0;
        this.spanFalseNeg = 0.0;
        this.spanFalsePos = 0.0;
        this.tokenTruePos = 0.0;
        this.tokenFalseNeg = 0.0;
        this.tokenFalsePos = 0.0;
        for (int i = 0; i < spanDifferences.length; ++i) {
            SpanDifference sd = spanDifferences[i];
            Iterator<DiffedSpan> j = sd.diffedSpans.iterator();
            while (j.hasNext()) {
                accum.add(j.next());
            }
            this.tokenFalsePos += sd.tokenFalsePos;
            this.tokenFalseNeg += sd.tokenFalseNeg;
            this.tokenTruePos += sd.tokenTruePos;
            this.spanFalsePos += sd.spanFalsePos;
            this.spanFalseNeg += sd.spanFalseNeg;
            this.spanTruePos += sd.spanTruePos;
        }
        this.diffedSpans = new ArrayList<DiffedSpan>(accum.size());
        Iterator i = accum.iterator();
        while (i.hasNext()) {
            this.diffedSpans.add((DiffedSpan)i.next());
        }
        this.performanceCacheIsValid = true;
    }

    public SpanDifference(Iterator<Span> guess, Iterator<Span> truth) {
        this(guess, truth, null);
    }

    public SpanDifference(Iterator<Span> guess, Iterator<Span> truth, Iterator<Span> closures) {
        Span s;
        this.guessSet = new TreeSet<Span>();
        this.truthSet = new TreeSet<Span>();
        this.closureMap = new TreeMap<String, Set<Span>>();
        TreeSet<ChangeBoundary> changes = new TreeSet<ChangeBoundary>();
        while (guess.hasNext()) {
            s = guess.next();
            changes.add(new ChangeBoundary(s.getLeftBoundary(), 1, 1, s));
            changes.add(new ChangeBoundary(s.getRightBoundary(), 2, 1, s));
            this.guessSet.add(s);
        }
        while (truth.hasNext()) {
            s = truth.next();
            changes.add(new ChangeBoundary(s.getLeftBoundary(), 1, 2, null));
            changes.add(new ChangeBoundary(s.getRightBoundary(), 2, 2, null));
            this.truthSet.add(s);
        }
        while (closures != null && closures.hasNext()) {
            s = closures.next();
            changes.add(new ChangeBoundary(s.getLeftBoundary(), 1, 3, null));
            changes.add(new ChangeBoundary(s.getRightBoundary(), 2, 3, null));
            TreeSet<Span> closuresForId = (TreeSet<Span>)this.closureMap.get(s.getDocumentId());
            if (closuresForId == null) {
                closuresForId = new TreeSet<Span>();
                this.closureMap.put(s.getDocumentId(), closuresForId);
            }
            closuresForId.add(s);
        }
        this.diffedSpans = new ArrayList<DiffedSpan>();
        this.performanceCacheIsValid = false;
        int state = 0;
        boolean insideClosure = closures == null;
        ChangeBoundary fpLeft = null;
        ChangeBoundary tpLeft = null;
        ChangeBoundary fnLeft = null;
        for (ChangeBoundary cb : changes) {
            if (cb.guessTruthClosure == 3) {
                insideClosure = cb.isLeft;
                continue;
            }
            if (state == 0 && cb.isLeft && cb.guessTruthClosure == 2) {
                state = 2;
                fnLeft = cb;
                continue;
            }
            if (state == 0 && cb.isLeft && cb.guessTruthClosure == 1) {
                state = 1;
                fpLeft = cb;
                continue;
            }
            if (state == 1 && cb.isLeft && cb.guessTruthClosure == 2) {
                state = 3;
                if (cb.point.compareTo(fpLeft.point) != 0) {
                    this.diffedSpans.add(new DiffedSpan(insideClosure, 1, fpLeft, cb));
                }
                tpLeft = cb;
                continue;
            }
            if (state == 1 && !cb.isLeft && cb.guessTruthClosure == 1) {
                state = 0;
                if (cb.point.compareTo(fpLeft.point) != 0) {
                    this.diffedSpans.add(new DiffedSpan(insideClosure, 1, fpLeft, cb));
                }
                fpLeft = null;
                continue;
            }
            if (state == 2 && cb.isLeft && cb.guessTruthClosure == 1) {
                state = 3;
                if (cb.point.compareTo(fnLeft.point) != 0) {
                    this.diffedSpans.add(new DiffedSpan(insideClosure, 2, fnLeft, cb));
                }
                tpLeft = cb;
                continue;
            }
            if (state == 2 && !cb.isLeft && cb.guessTruthClosure == 2) {
                state = 0;
                if (cb.point.compareTo(fnLeft.point) != 0) {
                    this.diffedSpans.add(new DiffedSpan(insideClosure, 2, fnLeft, cb));
                }
                fnLeft = null;
                continue;
            }
            if (state == 3 && !cb.isLeft && cb.guessTruthClosure == 2) {
                state = 1;
                if (cb.point.compareTo(tpLeft.point) != 0) {
                    this.diffedSpans.add(new DiffedSpan(insideClosure, 3, tpLeft, cb));
                }
                fpLeft = cb;
                continue;
            }
            if (state != 3 || cb.isLeft || cb.guessTruthClosure != 1) continue;
            state = 2;
            if (cb.point.compareTo(tpLeft.point) != 0) {
                this.diffedSpans.add(new DiffedSpan(insideClosure, 3, tpLeft, cb));
            }
            fnLeft = cb;
        }
    }

    public Looper differenceIterator() {
        return new Looper(this.diffedSpans);
    }

    public double tokenPrecision() {
        if (!this.performanceCacheIsValid) {
            this.cachePerformance();
        }
        if (this.tokenTruePos + this.tokenFalsePos == 0.0) {
            return 0.0;
        }
        return this.tokenTruePos / (this.tokenTruePos + this.tokenFalsePos);
    }

    public double tokenRecall() {
        if (!this.performanceCacheIsValid) {
            this.cachePerformance();
        }
        if (this.tokenTruePos + this.tokenFalseNeg == 0.0) {
            return 0.0;
        }
        return this.tokenTruePos / (this.tokenTruePos + this.tokenFalseNeg);
    }

    public double spanPrecision() {
        if (!this.performanceCacheIsValid) {
            this.cachePerformance();
        }
        if (this.spanTruePos + this.spanFalsePos == 0.0) {
            return 0.0;
        }
        return this.spanTruePos / (this.spanTruePos + this.spanFalsePos);
    }

    public double spanRecall() {
        if (!this.performanceCacheIsValid) {
            this.cachePerformance();
        }
        if (this.spanTruePos + this.spanFalseNeg == 0.0) {
            return 0.0;
        }
        return this.spanTruePos / (this.spanTruePos + this.spanFalseNeg);
    }

    private void cachePerformance() {
        this.tokenTruePos = 0.0;
        this.tokenFalseNeg = 0.0;
        this.tokenFalsePos = 0.0;
        for (DiffedSpan diffedSpan : this.diffedSpans) {
            int numTokens = diffedSpan.diffSpan.size();
            int status = diffedSpan.status;
            if (status == 1) {
                this.tokenFalsePos += (double)numTokens;
                continue;
            }
            if (status == 2) {
                this.tokenFalseNeg += (double)numTokens;
                continue;
            }
            if (status != 3) continue;
            this.tokenTruePos += (double)numTokens;
        }
        this.spanTruePos = 0.0;
        this.spanFalseNeg = 0.0;
        this.spanFalsePos = 0.0;
        for (Span span : this.truthSet) {
            if (this.guessSet.contains(span)) continue;
            this.spanFalseNeg += 1.0;
            log.debug("fn: " + span);
        }
        block2: for (Span span : this.guessSet) {
            if (this.truthSet.contains(span)) {
                this.spanTruePos += 1.0;
                log.debug("tp: " + span);
                continue;
            }
            Set closuresForId = (Set)this.closureMap.get(span.getDocumentId());
            if (closuresForId == null) continue;
            for (Span t : closuresForId) {
                if (!t.contains(span)) continue;
                log.debug("fp: " + span);
                this.spanFalsePos += 1.0;
                continue block2;
            }
        }
        this.performanceCacheIsValid = true;
    }

    public String toString() {
        return "[SpanDiff: token p/r=" + this.tokenPrecision() + "/" + this.tokenRecall() + " span p/r=" + this.spanPrecision() + "/" + this.spanRecall() + "]";
    }

    public String toSummary() {
        double tokenF = 2.0 * this.tokenPrecision() * this.tokenRecall() / (this.tokenPrecision() + this.tokenRecall());
        double spanF = 2.0 * this.spanPrecision() * this.spanRecall() / (this.spanPrecision() + this.spanRecall());
        return "TokenPrecision: " + this.fmt(this.tokenPrecision()) + " TokenRecall: " + this.fmt(this.tokenRecall()) + " F: " + this.fmt(tokenF) + "\n" + "SpanPrecision:  " + this.fmt(this.spanPrecision()) + " SpanRecall:  " + this.fmt(this.spanRecall()) + " F: " + this.fmt(spanF);
    }

    private String fmt(double d) {
        if (Double.isNaN(d)) {
            return this.fmt(0.0);
        }
        return new DecimalFormat("0.0000").format(d);
    }

    public static void main(String[] args) {
        Invoker inv = new Invoker();
        inv.processArguments(args);
        if (inv.textLabels == null) {
            throw new IllegalArgumentException("-labels must be set");
        }
        if (inv.actualType == null) {
            throw new IllegalArgumentException("-actual must be set");
        }
        Iterator<Span> guess = inv.textLabels.instanceIterator(inv.predictedType);
        Iterator<Span> truth = inv.textLabels.instanceIterator(inv.actualType);
        Iterator<Span> closure = inv.textLabels.closureIterator(inv.actualType);
        if (guess == null) {
            throw new IllegalArgumentException("spanType '" + inv.predictedType + "' not found");
        }
        if (truth == null) {
            throw new IllegalArgumentException("spanType '" + inv.actualType + "' not found");
        }
        SpanDifference sd = new SpanDifference(guess, truth, closure);
        System.out.println(sd.toString());
        System.out.println(sd.toSummary());
    }

    public static class Invoker
    extends BasicCommandLineProcessor {
        public TextLabels textLabels;
        public String predictedType = "_predicted";
        public String actualType = null;

        public void labels(String s) {
            this.textLabels = FancyLoader.loadTextLabels(s);
        }

        public void predicted(String s) {
            this.predictedType = s;
        }

        public void actual(String s) {
            this.actualType = s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DiffedSpan
    implements Comparable<DiffedSpan> {
        private Span diffSpan;
        private int status;
        private Span originalGuessSpan;

        public DiffedSpan(boolean insideClosure, int statusCWA, ChangeBoundary leftBoundary, ChangeBoundary rightBoundary) {
            this.status = !insideClosure & statusCWA == 1 ? 4 : statusCWA;
            if (!leftBoundary.point.getDocumentId().equals(rightBoundary.point.getDocumentId())) {
                throw new IllegalArgumentException("error diffing " + leftBoundary.point + " to " + rightBoundary.point);
            }
            int lo = leftBoundary.point.documentSpanStartIndex();
            int len = rightBoundary.point.documentSpanStartIndex() - lo;
            this.diffSpan = leftBoundary.point.documentSpan().subSpan(lo, len);
            this.originalGuessSpan = leftBoundary.originalGuessSpan;
            if (this.originalGuessSpan == null) {
                this.originalGuessSpan = rightBoundary.originalGuessSpan;
            }
        }

        public String toString() {
            return "[Diff " + this.status + " " + this.diffSpan + "]";
        }

        @Override
        public int compareTo(DiffedSpan o) {
            return this.diffSpan.compareTo(o.diffSpan);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChangeBoundary
    implements Comparable<ChangeBoundary> {
        public Span point;
        public boolean isLeft;
        public int guessTruthClosure;
        public Span originalGuessSpan;

        public ChangeBoundary(Span point2, int leftRight, int guessTruthClosure, Span originalGuessSpan) {
            this.point = point2;
            this.isLeft = leftRight == 1;
            this.guessTruthClosure = guessTruthClosure;
            this.originalGuessSpan = originalGuessSpan;
        }

        public String toString() {
            return "[" + this.point.toString() + ";" + (this.isLeft ? "L" : "R") + ";" + strCode[this.guessTruthClosure] + "]";
        }

        @Override
        public int compareTo(ChangeBoundary cb) {
            int tmp = this.point.compareTo(cb.point);
            if (tmp != 0) {
                return tmp;
            }
            if (this.originalGuessSpan != null && cb.originalGuessSpan == null) {
                return -1;
            }
            if (this.originalGuessSpan == null && cb.originalGuessSpan != null) {
                return 1;
            }
            if (!this.isLeft && cb.isLeft) {
                return -1;
            }
            if (this.isLeft && !cb.isLeft) {
                return 1;
            }
            return this.guessTruthClosure - cb.guessTruthClosure;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Looper
    implements Iterator<Span> {
        private DiffedSpan last;
        private Iterator<DiffedSpan> i;
        private int estSize = -1;

        public Looper(Collection<DiffedSpan> c) {
            this.i = c.iterator();
            this.estSize = c.size();
        }

        public Looper(Iterator<DiffedSpan> i) {
            this.i = i;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public Span next() {
            this.last = this.i.next();
            return this.last.diffSpan;
        }

        public int getStatus() {
            return this.last.status;
        }

        public Span getOriginalGuessSpan() {
            return this.last.originalGuessSpan;
        }

        public int estimatedSize() {
            return this.estSize;
        }
    }
}

