/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.text.BasicTextBase;
import edu.cmu.minorthird.text.Span;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trie {
    private TrieNode root = new TrieNode();

    public ResultIterator lookup(Span span) {
        ArrayList<TrieMatch> accum = new ArrayList<TrieMatch>();
        for (int i = 0; i < span.size(); ++i) {
            this.lookup(accum, span, i);
        }
        return new MyResultIterator(span, accum);
    }

    private void lookup(List<TrieMatch> accum, Span span, int start) {
        TrieNode node = this.root;
        int depth = 0;
        while (node != null) {
            if (node.endIds != null) {
                accum.add(new TrieMatch(node.endIds, start, depth));
            }
            node = node.map != null && start + depth < span.size() ? node.map.get(span.getToken(start + depth).getValue()) : null;
            ++depth;
        }
    }

    public void addWords(String id, String[] words) {
        TrieNode node = this.root;
        for (int i = 0; i < words.length; ++i) {
            TrieNode kid;
            if (node.map == null) {
                node.map = new TreeMap<String, TrieNode>();
            }
            if ((kid = node.map.get(words[i])) == null) {
                kid = new TrieNode();
                node.map.put(words[i], kid);
            }
            node = kid;
        }
        if (node.endIds == null) {
            node.endIds = new ArrayList<String>();
        }
        node.endIds.add(id);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b, 0, this.root);
        return b.toString();
    }

    private void tab(StringBuilder b, int level) {
        for (int tab = 0; tab < level; ++tab) {
            b.append("|  ");
        }
    }

    private void toString(StringBuilder b, int level, TrieNode node) {
        if (node.map == null) {
            return;
        }
        for (String w : node.map.keySet()) {
            TrieNode kid = node.map.get(w);
            this.tab(b, level);
            b.append("'").append(w).append("'");
            if (kid.endIds != null) {
                b.append(" IDS:");
                Iterator<String> j = kid.endIds.iterator();
                while (j.hasNext()) {
                    b.append(" ").append(j.next());
                }
            }
            b.append("\n");
            this.toString(b, level + 1, node.map.get(w));
        }
    }

    public static void main(String[] argv) {
        BasicTextBase base = new BasicTextBase();
        Trie trie = new Trie();
        for (int i = 0; i < argv.length - 1; ++i) {
            trie.addWords("argv" + i, base.getTokenizer().splitIntoTokens(argv[i]));
        }
        System.out.println(trie.toString());
        base.loadDocument("span", argv[argv.length - 1]);
        ResultIterator i = trie.lookup(base.documentSpan("span"));
        while (i.hasNext()) {
            System.out.println("match: " + ((Span)i.next()).asString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyResultIterator
    implements ResultIterator {
        private Iterator<TrieMatch> i;
        private Span span;
        private List<String> lastIdList;
        private int estSize = -1;

        public MyResultIterator(Span span, Collection<TrieMatch> c) {
            this.span = span;
            this.i = c.iterator();
            this.estSize = c.size();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public List<String> getAssociatedIds() {
            return this.lastIdList;
        }

        @Override
        public Span next() {
            TrieMatch match = this.i.next();
            this.lastIdList = match.endIds;
            return this.span.subSpan(match.start, match.length);
        }

        public int estimatedSize() {
            return this.estSize;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ResultIterator
    extends Iterator<Span> {
        public List<String> getAssociatedIds();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TrieMatch {
        public List<String> endIds;
        public int start;
        public int length;

        public TrieMatch(List<String> endIds, int start, int length) {
            this.endIds = endIds;
            this.start = start;
            this.length = length;
        }
    }

    private static class TrieNode {
        public Map<String, TrieNode> map = null;
        public List<String> endIds = null;

        private TrieNode() {
        }

        public String toString() {
            return "TrieNode(ends=" + this.endIds + ",map=" + this.map + ")";
        }
    }
}

