/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.gui;

import edu.cmu.minorthird.text.BasicTextLabels;
import edu.cmu.minorthird.text.BoneheadStemmer;
import edu.cmu.minorthird.text.FancyLoader;
import edu.cmu.minorthird.text.MutableTextLabels;
import edu.cmu.minorthird.text.NestedTextLabels;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.TextBaseLoader;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.TextLabelsLoader;
import edu.cmu.minorthird.text.gui.StatusMessage;
import edu.cmu.minorthird.text.gui.TextBaseEditor;
import edu.cmu.minorthird.text.gui.TextBaseViewer;
import edu.cmu.minorthird.text.mixup.MixupInterpreter;
import edu.cmu.minorthird.text.mixup.MixupProgram;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class MixupDebugger
extends JComponent {
    static final long serialVersionUID = 20080306L;
    private TextBaseEditor editor;
    private Logger log = Logger.getLogger(this.getClass());

    public TextBaseEditor getEditor() {
        return this.editor;
    }

    public MixupDebugger(TextBase base, File groundTruthLabelsFile, File mixupProgramFile, boolean readOnly, boolean stem) throws IOException {
        this(base, new BasicTextLabels(base), groundTruthLabelsFile, mixupProgramFile, readOnly, stem);
    }

    public MixupDebugger(TextBase base, TextLabels baseLabels, File groundTruthLabelsFile, File mixupProgramFile, boolean readOnly, boolean stem) throws IOException {
        BasicTextLabels truthLabels = null;
        MixupProgram program = new MixupProgram();
        if (groundTruthLabelsFile != null && groundTruthLabelsFile.exists()) {
            this.log.info("loading textLabels from " + groundTruthLabelsFile.getName() + "...");
            truthLabels = new BasicTextLabels(base);
            TextLabelsLoader labelsLoader = new TextLabelsLoader();
            labelsLoader.setClosurePolicy(2);
            labelsLoader.importOps(truthLabels, base, groundTruthLabelsFile);
        } else if (truthLabels == null) {
            truthLabels = new BasicTextLabels(base);
        }
        if (stem) {
            new BoneheadStemmer().stem(base, truthLabels);
        }
        String errorString = "no mixup program specified";
        try {
            program = new MixupProgram(mixupProgramFile);
            errorString = "Loaded " + mixupProgramFile.getName();
        }
        catch (Exception e) {
            errorString = e.toString();
        }
        NestedTextLabels programLabels = new NestedTextLabels(new NestedTextLabels(baseLabels), truthLabels);
        System.out.println("evaluating program from " + mixupProgramFile.getName() + "...");
        if (mixupProgramFile == null) {
            throw new IllegalArgumentException("mixup program must be specified");
        }
        MixupInterpreter interp = new MixupInterpreter(program);
        interp.eval(programLabels);
        new TextLabelsLoader().saveTypesAsOps(programLabels, new File("test.labels"));
        StatusMessage statusMsg = new StatusMessage();
        JScrollPane errorPane = new JScrollPane(new JTextField(errorString));
        this.editor = new TextBaseEditor(base, programLabels, truthLabels, statusMsg, readOnly);
        JButton saveButton = null;
        if (groundTruthLabelsFile != null) {
            saveButton = new JButton(new SaveTruthLabelsAction("Save current to " + groundTruthLabelsFile.getName(), groundTruthLabelsFile, truthLabels, statusMsg));
        } else {
            saveButton = new JButton(new SaveTruthLabelsAction("Save current to [no file specified]", groundTruthLabelsFile, truthLabels, statusMsg));
            saveButton.setEnabled(false);
        }
        this.editor.getViewerTracker().setSaveAs(groundTruthLabelsFile);
        JButton refreshButton = new JButton(new RefreshProgramAction("Reload program from " + mixupProgramFile.getName(), mixupProgramFile, base, baseLabels, truthLabels, this.editor.getViewer(), errorPane));
        JTextField newTypeField = new JTextField(10);
        JButton newTypeButton = new JButton(new NewTypeAction("New type:", truthLabels, this.editor.getViewer().getTruthBox(), newTypeField));
        this.setPreferredSize(new Dimension(800, 600));
        this.setLayout(new GridBagLayout());
        JPanel top = new JPanel(new GridBagLayout());
        JPanel bottom = new JPanel(new GridBagLayout());
        int col = 0;
        int row = 0;
        ++row;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        ++col;
        gbc.gridx = col++;
        gbc.gridy = row;
        top.add((Component)refreshButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = row;
        top.add((Component)newTypeButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = row;
        top.add((Component)newTypeField, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = col;
        gbc.gridy = row++;
        top.add((Component)saveButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.gridy = row;
        gbc.gridwidth = col;
        top.add((Component)errorPane, gbc);
        col = 0;
        row = 0;
        ++row;
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.gridy = row++;
        bottom.add((Component)this.editor, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = 1;
        gbc.gridy = row;
        bottom.add((Component)statusMsg, gbc);
        top.setMinimumSize(new Dimension(100, 50));
        bottom.setMinimumSize(new Dimension(100, 100));
        JSplitPane splitPane = new JSplitPane(0, top, bottom);
        splitPane.setDividerLocation(50);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.add((Component)splitPane, gbc);
    }

    private static void updateTypeBox(TextLabels labels, JComboBox box) {
        HashSet<String> oldTypes = new HashSet<String>();
        for (int j = 0; j < box.getItemCount(); ++j) {
            oldTypes.add((String)box.getItemAt(j));
        }
        for (String t : labels.getTypes()) {
            System.out.println("checking type " + t);
            if (oldTypes.contains(t)) continue;
            box.addItem(t);
            System.out.println("adding type " + t);
        }
    }

    public static MixupDebugger debug(TextBase base, File groundTruthLabelsFile, File mixupProgramFile) {
        BasicTextLabels baseLabels = new BasicTextLabels(base);
        return MixupDebugger.debug(base, baseLabels, groundTruthLabelsFile, mixupProgramFile);
    }

    public static MixupDebugger debug(TextBase base, TextLabels baseLabels, File groundTruthLabelsFile, File mixupProgramFile) {
        try {
            JFrame frame = new JFrame("MixupDebugger");
            MixupDebugger debugger = new MixupDebugger(base, baseLabels, groundTruthLabelsFile, mixupProgramFile, false, false);
            frame.getContentPane().add((Component)debugger, "Center");
            frame.addWindowListener(new WindowAdapter(){});
            frame.pack();
            frame.setVisible(true);
            return debugger;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String textBaseId = null;
        String fileName = null;
        File groundTruthLabelsFile = null;
        File mixupProgramFile = null;
        boolean readOnly = false;
        boolean stem = false;
        if (args.length < 4) {
            System.out.println("Not enough arguments.  Must have at least {-file <dataFile> or -textBase <textBaseFile>} and -mixup <programFile>");
            MixupDebugger.usage();
        }
        for (int argp = 0; argp < args.length; ++argp) {
            if ("-textBase".equals(args[argp])) {
                textBaseId = args[++argp];
                continue;
            }
            if ("-file".equals(args[argp])) {
                fileName = args[++argp];
                continue;
            }
            if ("-truth".equals(args[argp])) {
                groundTruthLabelsFile = new File(args[++argp]);
                continue;
            }
            if ("-mixup".equals(args[argp])) {
                mixupProgramFile = new File(args[++argp]);
                continue;
            }
            if ("-readOnly".equals(args[argp])) {
                readOnly = true;
                continue;
            }
            if ("-stem".equals(args[argp])) {
                stem = true;
                continue;
            }
            System.out.println("illegal option " + args[argp]);
        }
        if (textBaseId == null && fileName == null || mixupProgramFile == null || !mixupProgramFile.exists() || !mixupProgramFile.isFile()) {
            System.out.println("Either can't data file not specified or can't find mixupProgram");
            MixupDebugger.usage();
            return;
        }
        try {
            TextBase base;
            JFrame frame = new JFrame("TextBaseEditor");
            if (textBaseId != null) {
                base = FancyLoader.loadTextLabels(textBaseId).getTextBase();
            } else {
                File data = new File(fileName);
                if (data.isDirectory()) {
                    TextBaseLoader loader = new TextBaseLoader(1, false);
                    base = loader.load(data);
                } else {
                    TextBaseLoader loader = new TextBaseLoader(0, false);
                    base = loader.load(data);
                }
            }
            MixupDebugger debugger = new MixupDebugger(base, groundTruthLabelsFile, mixupProgramFile, readOnly, stem);
            frame.getContentPane().add((Component)debugger, "Center");
            frame.addWindowListener(new WindowAdapter(){});
            frame.pack();
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("usage: MixupDebugger {-file <dataFile> or -textBase <textBaseFile>} -truth <truthLabels> -mixup <programFile> [options]");
        System.out.println("       options: -readOnly -stem");
        System.exit(0);
    }

    private static class NewTypeAction
    extends AbstractAction {
        static final long serialVersionUID = 20080306L;
        private Set<String> truthTypeSet = new HashSet<String>();
        private JComboBox truthBox;
        private JTextField newTypeField;

        public NewTypeAction(String msg, MutableTextLabels truthLabels, JComboBox truthBox, JTextField newTypeField) {
            super(msg);
            this.truthTypeSet.addAll(truthLabels.getTypes());
            this.truthBox = truthBox;
            this.newTypeField = newTypeField;
        }

        public void actionPerformed(ActionEvent e) {
            String newType = this.newTypeField.getText().trim();
            if (newType.length() > 0 && this.truthTypeSet.add(newType)) {
                this.truthBox.addItem(newType);
                this.truthBox.setSelectedItem(newType);
            }
        }
    }

    private static class RefreshProgramAction
    extends AbstractAction {
        static final long serialVersionUID = 20080306L;
        private File mixupFile;
        private TextLabels initProgramLabels;
        private TextLabels truthLabels;
        private TextBase base;
        private JScrollPane errorPane;
        private TextBaseViewer viewer;

        public RefreshProgramAction(String msg, File mixupFile, TextBase base, TextLabels initProgramLabels, TextLabels truthLabels, TextBaseViewer viewer, JScrollPane errorPane) {
            super(msg);
            this.mixupFile = mixupFile;
            this.base = base;
            this.initProgramLabels = initProgramLabels;
            this.truthLabels = truthLabels;
            this.viewer = viewer;
            this.errorPane = errorPane;
        }

        public TextBase getBase() {
            return this.base;
        }

        public void setBase(TextBase base) {
            this.base = base;
        }

        public void actionPerformed(ActionEvent event) {
            MixupProgram program = new MixupProgram();
            try {
                program = new MixupProgram(this.mixupFile);
            }
            catch (Exception e) {
                this.errorPane.getViewport().setView(new JTextField(e.toString()));
                return;
            }
            NestedTextLabels programLabels = new NestedTextLabels(new NestedTextLabels(this.initProgramLabels), this.truthLabels);
            try {
                MixupInterpreter interp = new MixupInterpreter(program);
                interp.eval(programLabels);
            }
            catch (Exception e) {
                this.errorPane.getViewport().setView(new JTextField(e.toString()));
                return;
            }
            this.viewer.updateTextLabels(programLabels);
            MixupDebugger.updateTypeBox(programLabels, this.viewer.getGuessBox());
            MixupDebugger.updateTypeBox(programLabels, this.viewer.getTruthBox());
            MixupDebugger.updateTypeBox(programLabels, this.viewer.getDisplayedTypeBox());
            this.errorPane.getViewport().setView(new JTextField("loaded " + this.mixupFile.getName()));
        }
    }

    private static class SaveTruthLabelsAction
    extends AbstractAction {
        static final long serialVersionUID = 20080306L;
        private File saveFile;
        private MutableTextLabels labels;
        private StatusMessage statusMsg;

        public SaveTruthLabelsAction(String msg, File saveFile, MutableTextLabels labels, StatusMessage statusMsg) {
            super(msg);
            this.saveFile = saveFile;
            this.labels = labels;
            this.statusMsg = statusMsg;
        }

        public void actionPerformed(ActionEvent event) {
            if (this.saveFile == null) {
                this.statusMsg.display("no save file specified?");
                return;
            }
            this.statusMsg.display("saving to " + this.saveFile.getName());
            try {
                new TextLabelsLoader().saveTypesAsOps(this.labels, this.saveFile);
                this.statusMsg.display("saved to " + this.saveFile.getName());
            }
            catch (Exception e) {
                this.statusMsg.display("can't save to " + this.saveFile.getName() + ": " + e);
            }
        }
    }
}

