/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.gui;

import edu.cmu.minorthird.text.EmptyLabels;
import edu.cmu.minorthird.text.FancyLoader;
import edu.cmu.minorthird.text.NestedTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.gui.MarkupControls;
import edu.cmu.minorthird.text.gui.SpanDocument;
import edu.cmu.minorthird.text.mixup.MixupInterpreter;
import edu.cmu.minorthird.text.mixup.MixupProgram;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.Controllable;
import edu.cmu.minorthird.util.gui.ControlledViewer;
import edu.cmu.minorthird.util.gui.ParallelViewer;
import edu.cmu.minorthird.util.gui.ViewerControls;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;

public class SpanViewer
extends ParallelViewer
implements Controllable {
    static final long serialVersionUID = 200803014L;
    private static final int DEFAULT_CONTEXT = 10;
    private TextLabels labels;
    private Span span;
    private TextViewer textViewer;

    public SpanViewer(TextLabels labels, Span span) {
        this.labels = labels;
        this.span = span;
        this.textViewer = new TextViewer(labels, span);
        this.addSubView("Text", this.textViewer);
        this.addSubView("Tokens", new TokenViewer(labels, span));
        this.addSubView("Ids", new IdViewer(labels, span));
        this.setContent(span);
    }

    public TextLabels getLabels() {
        return this.labels;
    }

    public Span getSpan() {
        return this.span;
    }

    public void applyControls(ViewerControls controls) {
        this.textViewer.applyControls(controls);
    }

    public boolean canReceive(Object obj) {
        return obj instanceof Span;
    }

    public static void main(String[] argv) {
        try {
            TextLabels labels0 = FancyLoader.loadTextLabels("demos/sampleData/seminar-subset");
            NestedTextLabels labels = new NestedTextLabels(labels0);
            MixupProgram p = new MixupProgram(new String[]{"defTokenProp entity:time =top: ... [@stime] ...", "defTokenProp entity:speaker =top: ... [@speaker] ...", "defTokenProp entity:loc =top: ... [@location] ...", "defTokenProp freeText:true =top: ... [@sentence] ..."});
            MixupInterpreter interp = new MixupInterpreter(p);
            interp.eval(labels);
            Span s = labels.getTextBase().documentSpanIterator().next();
            SpanViewer sv = new SpanViewer(labels, s);
            MarkupControls mp = new MarkupControls(labels);
            ControlledViewer v = new ControlledViewer(sv, mp);
            v.setContent(s);
            new ViewerFrame("SpanViewer", v);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class IdViewer
    extends ComponentViewer {
        static final long serialVersionUID = 200803014L;
        private TextLabels labels;
        private Span span;

        public IdViewer(TextLabels labels, Span span) {
            this.labels = labels;
            this.span = span;
        }

        public TextLabels getLabels() {
            return this.labels;
        }

        public Span getSpan() {
            return this.span;
        }

        public JComponent componentFor(Object o) {
            Span s = (Span)o;
            Object[][] table = new Object[1][2];
            table[0][0] = s.getDocumentId();
            table[0][1] = s.getDocumentGroupId();
            Object[] colNames = new String[]{"documentId", "documentGroupId"};
            return new JScrollPane(new JTable(table, colNames));
        }
    }

    public static class TokenViewer
    extends ComponentViewer {
        static final long serialVersionUID = 200803014L;
        private TextLabels labels;
        private Span span;

        public TokenViewer(TextLabels labels, Span span) {
            this.labels = labels;
            this.span = span;
        }

        public Span getSpan() {
            return this.span;
        }

        public JComponent componentFor(Object o) {
            int j;
            Span s = (Span)o;
            Set<String> propSet = this.labels.getTokenProperties();
            String[] props = propSet.toArray(new String[propSet.size()]);
            Object[][] table = new Object[s.size()][props.length + 1];
            for (int i = 0; i < s.size(); ++i) {
                table[i][0] = s.getToken(i).getValue();
                for (j = 0; j < props.length; ++j) {
                    table[i][j + 1] = this.labels.getProperty(s.getToken(i), props[j]);
                    if (table[i][j + 1] != null) continue;
                    table[i][j + 1] = "-";
                }
            }
            Object[] colNames = new String[props.length + 1];
            colNames[0] = "token";
            for (j = 0; j < props.length; ++j) {
                colNames[j + 1] = props[j];
            }
            return new JScrollPane(new JTable(table, colNames));
        }
    }

    public static class TextViewer
    extends ComponentViewer
    implements Controllable {
        static final long serialVersionUID = 200803014L;
        private TextLabels labels;
        private Span span;
        private SpanDocument doc;
        private JTextPane textPane;
        private int context = 10;

        public TextViewer(Span span) {
            this(new EmptyLabels(), span, 10);
        }

        public TextViewer(Span span, int context) {
            this(new EmptyLabels(), span, context);
        }

        public TextViewer(TextLabels labels, Span span) {
            this(labels, span, 10);
        }

        public TextViewer(TextLabels labels, Span span, int context) {
            this.labels = labels;
            this.span = span;
            this.context = context;
        }

        public void highlight(Span span, SimpleAttributeSet color) {
            if (color != null) {
                this.doc.highlight(span, color);
            }
        }

        public JComponent componentFor(Object o) {
            this.span = (Span)o;
            this.doc = new SpanDocument(this.span, this.context);
            this.textPane = new JTextPane(this.doc);
            this.textPane.setEditable(false);
            return new JScrollPane(this.textPane);
        }

        public void applyControls(ViewerControls viewerControls) {
            MarkupControls controls = (MarkupControls)viewerControls;
            this.doc.resetHighlights();
            for (String type : this.labels.getTypes()) {
                SimpleAttributeSet color = controls.getColor(type);
                if (color == null) continue;
                Iterator<Span> j = this.labels.instanceIterator(type, this.span.getDocumentId());
                while (j.hasNext()) {
                    Span typeSpan = j.next();
                    this.doc.highlight(typeSpan, color);
                }
            }
            for (String prop : controls.getColoredProperties()) {
                Iterator<Span> j = this.labels.getSpansWithProperty(prop, this.span.getDocumentId());
                while (j.hasNext()) {
                    Span span = j.next();
                    String val = this.labels.getProperty(span, prop);
                    SimpleAttributeSet color = controls.getColor(prop, val);
                    if (color == null) continue;
                    this.doc.highlight(span, color);
                }
            }
        }
    }

    public static class ControlledTextViewer
    extends ControlledViewer {
        static final long serialVersionUID = 200803014L;
        private Span span;

        public ControlledTextViewer(Span span) {
            this.span = span;
            TextControls controls = new TextControls();
            MyViewer viewer = new MyViewer();
            this.setComponents(viewer, controls);
            this.setContent(span);
        }

        public Span getSpan() {
            return this.span;
        }

        private class TextControls
        extends ViewerControls {
            static final long serialVersionUID = 200803014L;
            public JSlider contextSlider;

            private TextControls() {
            }

            public void initialize() {
                this.contextSlider = new JSlider(0, 100, 10);
                this.add(new JLabel("Context:"));
                this.add(this.contextSlider);
                this.addApplyButton();
            }
        }

        private class MyViewer
        extends ComponentViewer
        implements Controllable {
            static final long serialVersionUID = 200803014L;
            public TextControls controls;
            public Span span;

            private MyViewer() {
            }

            public JComponent componentFor(Object o) {
                this.span = (Span)o;
                int contextWidth = this.controls == null ? 10 : this.controls.contextSlider.getValue();
                SpanDocument doc = new SpanDocument(this.span, contextWidth);
                JTextPane textPane = new JTextPane(doc);
                return new JScrollPane(textPane);
            }

            public void applyControls(ViewerControls controls) {
                this.controls = (TextControls)controls;
                this.setContent(this.span, true);
                this.revalidate();
            }
        }
    }
}

