/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.gui;

import edu.cmu.minorthird.text.FancyLoader;
import edu.cmu.minorthird.text.MutableTextLabels;
import edu.cmu.minorthird.text.SampleTextBases;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.TextLabelsLoader;
import edu.cmu.minorthird.text.gui.SpanEditor;
import edu.cmu.minorthird.text.gui.StatusMessage;
import edu.cmu.minorthird.text.gui.TextBaseViewer;
import edu.cmu.minorthird.text.gui.TrackedTextBaseComponent;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;

public class TextBaseEditor
extends TrackedTextBaseComponent {
    static final long serialVersionUID = 200803014L;
    private SpanEditor spanEditor;

    public SpanEditor getSpanEditor() {
        return this.spanEditor;
    }

    protected TextBaseEditor(String[] args) {
        this.log.debug("construct");
        try {
            this.setLabels(args);
        }
        catch (IOException e) {
            this.log.fatal(e, e);
        }
    }

    public TextBaseEditor(TextBase base, TextLabels viewLabels, MutableTextLabels editLabels, StatusMessage statusMsg, boolean readOnly) {
        this.init(base, viewLabels, statusMsg, editLabels, readOnly);
    }

    private void init(TextBase base, TextLabels viewLabels, StatusMessage statusMsg, MutableTextLabels editLabels, boolean readOnly) {
        super.init(base, viewLabels, editLabels, statusMsg);
        this.viewer = new TextBaseViewer(base, viewLabels, statusMsg);
        this.createSpanEditor(viewLabels, editLabels, statusMsg);
        this.spanEditor = (SpanEditor)this.viewerTracker;
        this.viewer.getTruthBox().addActionListener(new EditTypeAction(this.viewer.getGuessBox(), this.viewer.getTruthBox(), this.spanEditor));
        this.viewer.getGuessBox().addActionListener(new EditTypeAction(this.viewer.getGuessBox(), this.viewer.getTruthBox(), this.spanEditor));
        this.viewer.getDocumentList().addListSelectionListener(this.spanEditor);
        this.spanEditor.setReadOnly(readOnly);
        this.initializeLayout();
    }

    protected void createSpanEditor(TextLabels viewLabels, MutableTextLabels editLabels, StatusMessage statusMsg) {
        this.viewerTracker = new SpanEditor(viewLabels, editLabels, this.viewer.getDocumentList(), this.viewer.getSpanPainter(), statusMsg);
    }

    public static TextBaseEditor edit(MutableTextLabels labels, File file) {
        TextBase base = labels.getTextBase();
        StatusMessage statusMsg = new StatusMessage();
        TextBaseEditor editor = new TextBaseEditor(base, labels, labels, statusMsg, false);
        if (file != null) {
            editor.setSaveAs(file);
        }
        editor.initializeLayout();
        editor.buildFrame();
        return editor;
    }

    private void setLabels(String[] args) throws IOException {
        boolean readOnly = TextBaseEditor.checkReadOnly(args);
        TextBase base = null;
        MutableTextLabels labels = null;
        File saveFile = null;
        if (args.length == 0) {
            base = SampleTextBases.getTextBase();
            labels = SampleTextBases.getTruthLabels();
            this.log.info("Sample Text Bases");
        } else {
            this.log.debug("load from " + args[0]);
            labels = (MutableTextLabels)FancyLoader.loadTextLabels(args[0]);
            base = labels.getTextBase();
            if (args.length > 1) {
                saveFile = new File(args[1]);
                if (saveFile.exists()) {
                    labels = new TextLabelsLoader().loadOps(base, saveFile);
                }
                this.log.info("load text bases");
            }
        }
        this.init(base, labels, new StatusMessage(), labels, readOnly);
        this.setSaveAs(saveFile);
    }

    private static boolean checkReadOnly(String[] args) {
        boolean readOnly = false;
        for (int argp = 0; argp < args.length; ++argp) {
            if (!"-readOnly".equals(args[argp])) continue;
            readOnly = true;
            ++argp;
        }
        return readOnly;
    }

    public static void main(String[] args) {
        try {
            MutableTextLabels labels = (MutableTextLabels)FancyLoader.loadTextLabels(args[0]);
            File saveFile = new File(args[1]);
            TextBaseEditor.edit(labels, saveFile);
        }
        catch (Exception e) {
            System.out.println("usage repositoryKey outputFile");
        }
    }

    public static class EditTypeAction
    extends AbstractAction {
        static final long serialVersionUID = 200803014L;
        private JComboBox guessBox;
        private JComboBox truthBox;
        private SpanEditor spanEditor;

        public EditTypeAction(JComboBox guessBox, JComboBox truthBox, SpanEditor spanEditor) {
            this.guessBox = guessBox;
            this.truthBox = truthBox;
            this.spanEditor = spanEditor;
        }

        public void actionPerformed(ActionEvent event) {
            String truthType = (String)this.truthBox.getSelectedItem();
            String guessType = (String)this.guessBox.getSelectedItem();
            if (!"-compare to-".equals(truthType)) {
                this.spanEditor.setTypesBeingEdited(guessType, truthType);
            } else {
                this.spanEditor.setTypesBeingEdited(guessType, guessType);
            }
        }
    }
}

