/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.gui;

import edu.cmu.minorthird.text.MutableTextLabels;
import edu.cmu.minorthird.text.SampleTextBases;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.gui.SpanEditor;
import edu.cmu.minorthird.text.gui.SpanLabeler;
import edu.cmu.minorthird.text.gui.StatusMessage;
import edu.cmu.minorthird.text.gui.StatusMessagePanel;
import edu.cmu.minorthird.text.gui.TextBaseEditor;
import edu.cmu.minorthird.text.gui.TextBaseViewer;
import edu.cmu.minorthird.text.gui.TrackedTextBaseComponent;
import edu.cmu.minorthird.text.gui.ViewerTracker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class TextBaseEditorPlusLabeler
extends TrackedTextBaseComponent {
    static final long serialVersionUID = 200803014L;
    ViewerTracker viewerTracker2;

    public TextBaseEditorPlusLabeler(TextBase base, TextLabels viewLabels, MutableTextLabels editLabels, StatusMessage statusMsg) {
        super(base, viewLabels, editLabels, statusMsg);
        this.viewer = new TextBaseViewer(base, viewLabels, statusMsg);
        this.viewerTracker = new SpanLabeler(viewLabels, editLabels, this.viewer.getDocumentList(), this.viewer.getSpanPainter(), statusMsg);
        ((SpanLabeler)this.viewerTracker).addViewer(this.viewer);
        this.viewerTracker2 = new SpanEditor(viewLabels, editLabels, this.viewer.getDocumentList(), this.viewer.getSpanPainter(), statusMsg);
        this.viewer.getDocumentList().addListSelectionListener(this.viewerTracker);
        this.viewer.getDocumentList().addListSelectionListener(this.viewerTracker2);
        this.viewer.getTruthBox().addActionListener(new TextBaseEditor.EditTypeAction(this.viewer.getGuessBox(), this.viewer.getTruthBox(), (SpanEditor)this.viewerTracker2));
        this.viewer.getGuessBox().addActionListener(new TextBaseEditor.EditTypeAction(this.viewer.getGuessBox(), this.viewer.getTruthBox(), (SpanEditor)this.viewerTracker2));
        this.initializeTwoTrackerLayout();
    }

    private void initializeTwoTrackerLayout() {
        this.setPreferredSize(new Dimension(800, 600));
        this.setLayout(new GridBagLayout());
        this.viewer.setMinimumSize(new Dimension(200, 200));
        JTabbedPane tabbed = new JTabbedPane();
        this.viewerTracker.setMinimumSize(new Dimension(200, 50));
        this.viewerTracker2.setMinimumSize(new Dimension(200, 50));
        tabbed.add("Label parts", this.viewerTracker2);
        tabbed.add("Label whole", this.viewerTracker);
        JSplitPane splitPane = new JSplitPane(0, this.viewer, tabbed);
        splitPane.setDividerLocation(400);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.add((Component)splitPane, gbc);
    }

    public void setSaveAs(File file) {
        this.viewerTracker.setSaveAs(file);
        this.viewerTracker2.setSaveAs(file);
    }

    public static TextBaseEditorPlusLabeler editAndLabel(MutableTextLabels labels, File file) {
        JFrame frame = new JFrame("TextBaseEditorPlusLabeler");
        TextBase base = labels.getTextBase();
        StatusMessage statusMsg = new StatusMessage();
        TextBaseEditorPlusLabeler labeler = new TextBaseEditorPlusLabeler(base, labels, labels, statusMsg);
        if (file != null) {
            labeler.setSaveAs(file);
        }
        StatusMessagePanel main = new StatusMessagePanel(labeler, statusMsg);
        frame.getContentPane().add((Component)main, "Center");
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
        return labeler;
    }

    public static void main(String[] args) {
        try {
            MutableTextLabels guessLabels = SampleTextBases.getTruthLabels();
            TextBaseEditorPlusLabeler.editAndLabel(guessLabels, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

