/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.gui;

import edu.cmu.minorthird.text.FancyLoader;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.SpanDifference;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.gui.HiliteColors;
import edu.cmu.minorthird.text.gui.SpanDocument;
import edu.cmu.minorthird.text.gui.SpanPainter;
import edu.cmu.minorthird.text.gui.StatusMessage;
import edu.cmu.minorthird.text.gui.StatusMessagePanel;
import edu.cmu.minorthird.text.mixup.MixupInterpreter;
import edu.cmu.minorthird.text.mixup.MixupProgram;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import org.apache.log4j.Logger;

public class TextBaseViewer
extends JComponent {
    static final long serialVersionUID = 200803014L;
    public static final String NULL_TRUTH_ENTRY = "-compare to-";
    public static final String NULL_DISPLAY_TYPE = "-top-";
    private final StatusMessage statusMsg;
    private final TextBase base;
    private TextLabels labels;
    private JList documentList;
    private JSlider documentCellHeightSlider;
    private JComboBox displayedTypeBox;
    private JCheckBox editedOnlyCheckBox;
    private JComboBox guessBox;
    private JComboBox truthBox;
    public HighlightAction highlightAction;
    private static Logger log = Logger.getLogger(TextBaseViewer.class);

    public JList getDocumentList() {
        return this.documentList;
    }

    public JComboBox getGuessBox() {
        return this.guessBox;
    }

    public JComboBox getTruthBox() {
        return this.truthBox;
    }

    public JComboBox getDisplayedTypeBox() {
        return this.displayedTypeBox;
    }

    public SpanPainter getSpanPainter() {
        return this.highlightAction;
    }

    public void updateTextLabels(TextLabels newLabels) {
        this.labels = newLabels;
        this.highlightAction.paintDocument(null);
        for (String label : this.labels.getTypes()) {
            boolean contains = false;
            for (int j = 0; j < this.truthBox.getItemCount(); ++j) {
                String item = (String)this.truthBox.getItemAt(j);
                if (!item.equals(label)) continue;
                contains = true;
            }
            if (contains) continue;
            this.truthBox.addItem(label);
        }
    }

    public TextBaseViewer(TextBase base, TextLabels labels, StatusMessage statusMsg) {
        this(base, labels, null, statusMsg);
    }

    public TextBaseViewer(TextBase base, TextLabels labels, String displayType, StatusMessage statusMsg) {
        this.base = base;
        this.labels = labels;
        this.statusMsg = statusMsg;
        this.initializeLayout(displayType);
    }

    private void initializeLayout(String displayType) {
        this.documentList = new JList();
        this.documentList.setFixedCellWidth(760);
        this.resetDocumentList(this.labels, displayType, false);
        this.guessBox = new JComboBox();
        this.guessBox.setEditable(false);
        for (String type : this.labels.getTypes()) {
            this.guessBox.addItem(type);
        }
        this.truthBox = new JComboBox();
        this.truthBox.addItem(NULL_TRUTH_ENTRY);
        log.debug("types: " + this.labels.getTypes());
        Iterator<String> i = this.labels.getTypes().iterator();
        while (i.hasNext()) {
            this.truthBox.addItem(i.next());
        }
        this.displayedTypeBox = new JComboBox();
        this.displayedTypeBox.setEditable(false);
        this.displayedTypeBox.addItem(NULL_DISPLAY_TYPE);
        i = this.labels.getTypes().iterator();
        while (i.hasNext()) {
            this.displayedTypeBox.addItem(i.next().toString());
            if (displayType == null) continue;
            this.displayedTypeBox.setSelectedItem(displayType);
        }
        ResetDocumentListAction resetDocumentListAction = new ResetDocumentListAction();
        this.displayedTypeBox.addActionListener(resetDocumentListAction);
        this.editedOnlyCheckBox = new JCheckBox("Unlabeled");
        this.editedOnlyCheckBox.addActionListener(resetDocumentListAction);
        this.highlightAction = new HighlightAction("Highlight", this.guessBox, this.truthBox, this.documentList);
        this.guessBox.addActionListener(this.highlightAction);
        this.truthBox.addActionListener(this.highlightAction);
        JButton highlightButton = new JButton(this.highlightAction);
        this.documentCellHeightSlider = new DocumentCellHeightSlider(this.documentList);
        this.setPreferredSize(new Dimension(800, 600));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setLayout(new GridBagLayout());
        int col = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        ++col;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)highlightButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.guessBox, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.truthBox, gbc);
        gbc = new GridBagConstraints();
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)new JLabel("H:"), gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.documentCellHeightSlider, gbc);
        gbc = new GridBagConstraints();
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)new JLabel("W:"), gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)new DocumentCellWidthSlider(this.documentList), gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)new JButton(new ZoomAction("Font-2", -2, this.documentList)), gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)new JButton(new ZoomAction("Font+2", 2, this.documentList)), gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.displayedTypeBox, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.editedOnlyCheckBox, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = col;
        gbc.gridy = 2;
        this.add((Component)new ContextWidthSlider(this.documentList), gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weighty = 2.0;
        gbc.weightx = 2.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = col;
        this.add((Component)new JScrollPane(this.documentList), gbc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void resetDocumentList(TextLabels labels, String displayType, boolean onlyEditedSpans) {
        log.debug("reset for type " + displayType);
        ArrayList<Span> spans = new ArrayList<Span>();
        Iterator<Span> i = null;
        i = displayType == null || NULL_DISPLAY_TYPE.equals(displayType) ? this.base.documentSpanIterator() : labels.instanceIterator(displayType);
        String truthType = NULL_TRUTH_ENTRY;
        if (this.truthBox != null) {
            truthType = (String)this.truthBox.getSelectedItem();
        }
        if (NULL_TRUTH_ENTRY.equals(truthType)) {
            onlyEditedSpans = false;
        }
        while (i.hasNext()) {
            Span s = i.next();
            if (!onlyEditedSpans) {
                spans.add(s);
                continue;
            }
            boolean wasEdited = false;
            Iterator<Span> j = labels.closureIterator(truthType, s.getDocumentId());
            while (j.hasNext()) {
                Span t = j.next();
                if (!t.contains(s)) continue;
                wasEdited = true;
            }
            if (wasEdited) continue;
            spans.add(s);
        }
        if (spans.size() == 0) {
            this.statusMsg.display("no" + (onlyEditedSpans ? " unedited" : "") + " spans of type " + displayType);
        } else {
            JList jList = this.documentList;
            synchronized (jList) {
                this.statusMsg.display("Displaying " + spans.size() + (onlyEditedSpans ? " unedited" : "") + " spans of type " + displayType);
                Span[] spanArray = spans.toArray(new Span[spans.size()]);
                if (this.documentList == null) {
                    this.documentList = new JList();
                }
                this.documentList.setVisible(false);
                this.documentList.setListData(spanArray);
                SpanRenderer renderer = new SpanRenderer(spanArray);
                this.documentList.setCellRenderer(renderer);
                this.documentList.setVisible(true);
                this.documentList.repaint();
                if (this.highlightAction != null) {
                    this.highlightAction.paintDocument(null);
                }
                this.statusMsg.display("Displaying " + spans.size() + (onlyEditedSpans ? " unedited" : "") + " spans of type " + displayType);
            }
        }
    }

    public static void view(TextLabels labels) {
        JFrame frame = new JFrame("TextBaseViewer");
        TextBase base = labels.getTextBase();
        StatusMessage statusMsg = new StatusMessage();
        TextBaseViewer viewer = new TextBaseViewer(base, labels, statusMsg);
        StatusMessagePanel main = new StatusMessagePanel(viewer, statusMsg);
        frame.getContentPane().add((Component)main, "Center");
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            TextLabels labels = FancyLoader.loadTextLabels(args[0]);
            if (args.length > 1) {
                MixupProgram p = new MixupProgram(new File(args[1]));
                MixupInterpreter interp = new MixupInterpreter(p);
                interp.eval((MonotonicTextLabels)labels);
            }
            TextBaseViewer.view(labels);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("usage: TextBaseViewer key [mixupProgram]");
        }
    }

    private class SpanRenderer
    implements ListCellRenderer {
        private JComponent[] spanComponents;
        private SpanDocument[] spanDocs;
        private SortedSet<SpanMarkup>[] spanMarkups;
        private boolean[] spanIsDirty;
        private Span[] spans;
        private Map<Span, Integer> indexOfSpanMap;
        private Map<String, List<Span>> spansWithDocumentMap;
        private Font currentFont;
        private int contextWidth = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SpanRenderer(Span[] spans) {
            this.spans = spans;
            this.currentFont = new JTextPane().getFont();
            JList jList = TextBaseViewer.this.documentList;
            synchronized (jList) {
                this.spanComponents = new JComponent[spans.length];
                this.spanDocs = new SpanDocument[spans.length];
                this.spanMarkups = new TreeSet[spans.length];
                this.spanIsDirty = new boolean[spans.length];
                this.spansWithDocumentMap = new HashMap<String, List<Span>>();
                this.indexOfSpanMap = new HashMap<Span, Integer>();
                for (int i = 0; i < spans.length; ++i) {
                    this.spanDocs[i] = new SpanDocument(spans[i], this.contextWidth);
                    this.spanMarkups[i] = new TreeSet<SpanMarkup>();
                    this.spanIsDirty[i] = false;
                    this.refreshSpanComponent(i);
                    this.indexOfSpanMap.put(spans[i], new Integer(i));
                    String documentId = spans[i].getDocumentId();
                    List<Span> spansWithDocument = this.spansWithDocumentMap.get(documentId);
                    if (spansWithDocument == null) {
                        spansWithDocument = new ArrayList<Span>();
                        this.spansWithDocumentMap.put(documentId, spansWithDocument);
                    }
                    spansWithDocument.add(spans[i]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshSpanComponent(int i) {
            JList jList = TextBaseViewer.this.documentList;
            synchronized (jList) {
                JTextPane pane = new JTextPane(this.spanDocs[i]);
                pane.setFont(this.currentFont);
                this.spanComponents[i] = pane;
                this.spanComponents[i].setBorder(BorderFactory.createLineBorder(Color.black));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setContextWidth(int contextWidth) {
            JList jList = TextBaseViewer.this.documentList;
            synchronized (jList) {
                TextBaseViewer.this.documentList.setVisible(false);
                this.contextWidth = contextWidth;
                for (int i = 0; i < this.spanComponents.length; ++i) {
                    this.spanDocs[i] = new SpanDocument(this.spans[i], contextWidth);
                    this.spanIsDirty[i] = true;
                    this.refreshSpanComponent(i);
                }
                TextBaseViewer.this.documentList.setVisible(true);
                TextBaseViewer.this.documentList.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Component getListCellRendererComponent(JList el, Object v, int index, boolean sel, boolean focus) {
            if (this.spanIsDirty == null || index >= this.spanIsDirty.length) {
                return new JLabel("sync error?");
            }
            JList jList = TextBaseViewer.this.documentList;
            synchronized (jList) {
                if (this.spanIsDirty[index]) {
                    SortedSet<SpanMarkup> marks = this.spanMarkups[index];
                    this.spanDocs[index].resetHighlights();
                    for (SpanMarkup m : marks) {
                        this.spanDocs[index].highlight(m.span, m.color);
                    }
                    this.refreshSpanComponent(index);
                    this.spanIsDirty[index] = false;
                }
                if (sel) {
                    this.spanComponents[index].setBorder(BorderFactory.createLineBorder(Color.blue, 2));
                } else {
                    this.spanComponents[index].setBorder(BorderFactory.createLineBorder(Color.black, 2));
                }
                return this.spanComponents[index];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void highlightDiffs(SpanDifference.Looper i, String documentId, AttributeSet fp, AttributeSet fn, AttributeSet tp, AttributeSet mp) {
            AttributeSet[] colorByStatus = new AttributeSet[5];
            colorByStatus[1] = fp;
            colorByStatus[2] = fn;
            colorByStatus[3] = tp;
            colorByStatus[4] = mp;
            JList jList = TextBaseViewer.this.documentList;
            synchronized (jList) {
                if (documentId != null) {
                    List<Span> spansWithDocument = this.spansWithDocumentMap.get(documentId);
                    Iterator<Span> j = spansWithDocument.iterator();
                    while (j.hasNext()) {
                        int index = this.indexOfSpanMap.get(j.next());
                        this.spanDocs[index].resetHighlights();
                        this.spanMarkups[index] = new TreeSet<SpanMarkup>();
                        this.spanIsDirty[index] = true;
                    }
                } else {
                    for (int j = 0; j < this.spanDocs.length; ++j) {
                        if (this.spanMarkups[j].isEmpty()) continue;
                        this.spanDocs[j].resetHighlights();
                        this.spanMarkups[j] = new TreeSet<SpanMarkup>();
                        this.spanIsDirty[j] = true;
                    }
                }
                while (i.hasNext()) {
                    Span diffSpan = i.next();
                    int status = i.getStatus();
                    String documentIdOfS = diffSpan.getDocumentId();
                    List<Span> spansWithDocument = this.spansWithDocumentMap.get(documentIdOfS);
                    if (spansWithDocument == null) continue;
                    for (Span t : spansWithDocument) {
                        int indexOfT = this.indexOfSpanMap.get(t);
                        SortedSet<SpanMarkup> marks = this.spanMarkups[indexOfT];
                        marks.add(new SpanMarkup(diffSpan, colorByStatus[status]));
                        this.spanIsDirty[indexOfT] = true;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zoomFont(int delta) {
            JList jList = TextBaseViewer.this.documentList;
            synchronized (jList) {
                int currentSize = this.currentFont.getSize();
                String newFont = this.currentFont.getFamily() + "-plain-" + (currentSize + delta);
                this.currentFont = Font.decode(newFont);
                TextBaseViewer.this.statusMsg.display("current font is " + newFont);
                for (int i = 0; i < this.spanComponents.length; ++i) {
                    this.refreshSpanComponent(i);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SpanMarkup
        implements Comparable<SpanMarkup> {
            public Span span;
            public AttributeSet color;

            public SpanMarkup(Span span, AttributeSet color) {
                this.span = span;
                this.color = color;
            }

            @Override
            public int compareTo(SpanMarkup cspan) {
                return this.span.compareTo(cspan.span);
            }
        }
    }

    private class DocumentCellWidthSlider
    extends JSlider {
        static final long serialVersionUID = 200803014L;

        public DocumentCellWidthSlider(final JList vList) {
            super(-1, 760, 760);
            this.addChangeListener(new ChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stateChanged(ChangeEvent e) {
                    JList jList = vList;
                    synchronized (jList) {
                        DocumentCellWidthSlider slider = (DocumentCellWidthSlider)e.getSource();
                        if (!slider.getValueIsAdjusting()) {
                            vList.setFixedCellWidth(slider.getValue());
                        }
                    }
                }
            });
        }
    }

    private class DocumentCellHeightSlider
    extends JSlider {
        static final long serialVersionUID = 200803014L;

        public DocumentCellHeightSlider(final JList documentList) {
            super(-1, 100, -1);
            this.addChangeListener(new ChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stateChanged(ChangeEvent e) {
                    JList jList = documentList;
                    synchronized (jList) {
                        DocumentCellHeightSlider slider = (DocumentCellHeightSlider)e.getSource();
                        if (!slider.getValueIsAdjusting()) {
                            documentList.setFixedCellHeight(slider.getValue());
                        }
                    }
                }
            });
        }
    }

    private class ContextWidthSlider
    extends JSlider {
        static final long serialVersionUID = 200803014L;
        private final JList documentList;

        public ContextWidthSlider(final JList documentList) {
            super(0, 10, 0);
            this.documentList = documentList;
            this.addChangeListener(new ChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stateChanged(ChangeEvent e) {
                    JList jList = documentList;
                    synchronized (jList) {
                        ContextWidthSlider slider = (ContextWidthSlider)e.getSource();
                        if (!slider.getValueIsAdjusting()) {
                            int value = slider.getValue();
                            SpanRenderer renderer = (SpanRenderer)slider.documentList.getCellRenderer();
                            renderer.setContextWidth(value);
                            slider.documentList.repaint();
                        }
                    }
                }
            });
        }
    }

    private class ZoomAction
    extends AbstractAction {
        static final long serialVersionUID = 200803014L;
        private JList documentList;
        private int sizeDelta;

        public ZoomAction(String msg, int sizeDelta, JList documentList) {
            super(msg);
            this.sizeDelta = sizeDelta;
            this.documentList = documentList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent event) {
            JList jList = this.documentList;
            synchronized (jList) {
                SpanRenderer renderer = (SpanRenderer)this.documentList.getCellRenderer();
                renderer.zoomFont(this.sizeDelta);
                this.documentList.repaint();
            }
        }
    }

    private class ResetDocumentListAction
    extends AbstractAction {
        static final long serialVersionUID = 200803014L;

        public ResetDocumentListAction() {
            super("Display");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent event) {
            JList jList = TextBaseViewer.this.documentList;
            synchronized (jList) {
                String type = (String)TextBaseViewer.this.displayedTypeBox.getSelectedItem();
                TextBaseViewer.this.resetDocumentList(TextBaseViewer.this.labels, type, TextBaseViewer.this.editedOnlyCheckBox.isSelected());
                TextBaseViewer.this.documentList.repaint();
            }
        }
    }

    public class HighlightAction
    extends AbstractAction
    implements SpanPainter {
        static final long serialVersionUID = 200803014L;
        private JComboBox guessBox;
        private JComboBox truthBox;
        private JList documentList;
        private SpanDifference spanDifference;

        public HighlightAction(String msg, JComboBox guessBox, JComboBox truthBox, JList documentList) {
            super(msg);
            this.guessBox = guessBox;
            this.truthBox = truthBox;
            this.documentList = documentList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent event) {
            JList jList = this.documentList;
            synchronized (jList) {
                this.paintDocument(null);
            }
            DecimalFormat fmt = new DecimalFormat("##0.000");
            double tr = this.spanDifference.tokenRecall() * 100.0;
            double tp = this.spanDifference.tokenPrecision() * 100.0;
            double sr = this.spanDifference.spanRecall() * 100.0;
            double sp = this.spanDifference.spanPrecision() * 100.0;
            TextBaseViewer.this.statusMsg.display("Token recall: " + fmt.format(tr) + " precision: " + fmt.format(tp) + " Span recall: " + fmt.format(sr) + " precision: " + fmt.format(sp));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintDocument(String documentId) {
            JList jList = this.documentList;
            synchronized (jList) {
                try {
                    SpanRenderer renderer = (SpanRenderer)this.documentList.getCellRenderer();
                    renderer.highlightDiffs(this.differenceIterator(documentId), documentId, this.fpColor(), this.fnColor(), this.tpColor(), this.mpColor());
                    this.documentList.repaint();
                }
                catch (Exception e) {
                    System.out.println("error: " + e);
                    e.printStackTrace();
                }
            }
        }

        public AttributeSet fpColor() {
            return this.nullTruthType() ? HiliteColors.yellow : HiliteColors.red;
        }

        public AttributeSet fnColor() {
            return this.nullTruthType() ? HiliteColors.yellow : HiliteColors.blue;
        }

        public AttributeSet tpColor() {
            return this.nullTruthType() ? HiliteColors.yellow : HiliteColors.green;
        }

        public AttributeSet mpColor() {
            return HiliteColors.yellow;
        }

        public SpanDifference.Looper differenceIterator(String documentId) {
            Iterator<Span> guessLooper;
            String guessType = (String)this.guessBox.getSelectedItem();
            String truthType = (String)this.truthBox.getSelectedItem();
            Iterator<Span> iterator = guessLooper = documentId == null ? TextBaseViewer.this.labels.instanceIterator(guessType) : TextBaseViewer.this.labels.instanceIterator(guessType, documentId);
            if (this.nullTruthType()) {
                Iterator<Span> nullLooper = new HashSet().iterator();
                this.spanDifference = new SpanDifference(guessLooper, nullLooper);
                return this.spanDifference.differenceIterator();
            }
            Iterator<Span> truthSpanLooper = documentId == null ? TextBaseViewer.this.labels.instanceIterator(truthType) : TextBaseViewer.this.labels.instanceIterator(truthType, documentId);
            Iterator<Span> closureSpanLooper = documentId == null ? TextBaseViewer.this.labels.closureIterator(truthType) : TextBaseViewer.this.labels.closureIterator(truthType, documentId);
            this.spanDifference = new SpanDifference(guessLooper, truthSpanLooper, closureSpanLooper);
            return this.spanDifference.differenceIterator();
        }

        private boolean nullTruthType() {
            return TextBaseViewer.NULL_TRUTH_ENTRY.equals((String)this.truthBox.getSelectedItem());
        }
    }
}

