/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.sequential.ConfidenceReportingSequenceClassifier;
import edu.cmu.minorthird.classify.sequential.ConfidenceUtils;
import edu.cmu.minorthird.classify.sequential.SequenceClassifier;
import edu.cmu.minorthird.text.AbstractAnnotator;
import edu.cmu.minorthird.text.Annotator;
import edu.cmu.minorthird.text.Details;
import edu.cmu.minorthird.text.FancyLoader;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.NestedTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.learn.ExtractorAnnotator;
import edu.cmu.minorthird.text.learn.SequenceAnnotatorLearner;
import edu.cmu.minorthird.text.learn.experiments.MonotonicSubTextLabels;
import edu.cmu.minorthird.text.learn.experiments.SubTextBase;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.ProgressCounter;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.Visible;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ConfidenceReportingSequenceAnnotator
extends AbstractAnnotator
implements ExtractorAnnotator,
Serializable,
Visible {
    static final long serialVersionUID = 20080306L;
    private static Logger log = Logger.getLogger(ConfidenceReportingSequenceAnnotator.class);
    private static final boolean DEBUG = false;
    private SequenceAnnotatorLearner.SequenceAnnotator sequenceAnnotator;

    public ConfidenceReportingSequenceAnnotator(SequenceAnnotatorLearner.SequenceAnnotator sequenceAnnotator) {
        this.sequenceAnnotator = sequenceAnnotator;
    }

    public String getSpanType() {
        return this.sequenceAnnotator.getSpanType();
    }

    public void doAnnotate(MonotonicTextLabels labels) {
        Iterator<Span> i = labels.getTextBase().documentSpanIterator();
        ProgressCounter pc = new ProgressCounter("tagging with classifier", "document");
        while (i.hasNext()) {
            Span docSpan = i.next();
            String docId = docSpan.getDocumentId();
            log.info("extracting from doc '" + docId + "'");
            Iterator<Span> justThisDoc = Collections.singleton(docSpan).iterator();
            MonotonicSubTextLabels tmpLabels = null;
            try {
                SubTextBase tmpBase = new SubTextBase(labels.getTextBase(), justThisDoc);
                tmpLabels = new MonotonicSubTextLabels(tmpBase, new NestedTextLabels(labels));
            }
            catch (SubTextBase.UnknownDocumentException ex) {
                throw new IllegalStateException("error: " + ex);
            }
            Instance[] sequence = new Instance[docSpan.size()];
            for (int j = 0; j < docSpan.size(); ++j) {
                Span tokenSpan = docSpan.subSpan(j, 1);
                sequence[j] = this.sequenceAnnotator.getSpanFeatureExtractor().extractInstance(labels, tokenSpan);
            }
            ClassLabel[] classLabels = this.sequenceAnnotator.getSequenceClassifier().classification(sequence);
            this.sequenceAnnotator.doAnnotate(tmpLabels);
            Iterator<Span> k = tmpLabels.instanceIterator(this.sequenceAnnotator.getSpanType());
            while (k.hasNext()) {
                Span extractedSpan = k.next();
                double confidence = this.computeConfidence(this.sequenceAnnotator.getSequenceClassifier(), sequence, extractedSpan, classLabels);
                labels.addToType(extractedSpan, this.sequenceAnnotator.getSpanType(), new Details(confidence, ConfidenceReportingSequenceAnnotator.class));
            }
            pc.progress();
        }
        pc.finished();
    }

    private double computeConfidence(SequenceClassifier seqClassifier, Instance[] sequence, Span extractedSpan, ClassLabel[] predictedLabels) {
        int startIndex = extractedSpan.documentSpanStartIndex();
        int endIndex = startIndex + extractedSpan.size();
        if (seqClassifier instanceof ConfidenceReportingSequenceClassifier) {
            ConfidenceReportingSequenceClassifier crSeqClassifier = (ConfidenceReportingSequenceClassifier)seqClassifier;
            ClassLabel[] alternateLabels = new ClassLabel[predictedLabels.length];
            for (int i = startIndex; i < endIndex; ++i) {
                alternateLabels[i] = ClassLabel.negativeLabel(-1.0);
            }
            return crSeqClassifier.confidence(sequence, predictedLabels, alternateLabels, startIndex, endIndex);
        }
        return ConfidenceUtils.sumPredictedWeights(predictedLabels, startIndex, endIndex);
    }

    public String explainAnnotation(TextLabels labels, Span documentSpan) {
        return this.sequenceAnnotator.explainAnnotation(labels, documentSpan);
    }

    public Viewer toGUI() {
        return new SmartVanillaViewer(this.sequenceAnnotator);
    }

    public static void main(String[] args) {
        if (args.length == 3 && "-test".equals(args[0])) {
            File loadFile = new File(args[1]);
            NestedTextLabels labels = new NestedTextLabels(FancyLoader.loadTextLabels(args[2]));
            SequenceAnnotatorLearner.SequenceAnnotator ann = null;
            try {
                ann = (SequenceAnnotatorLearner.SequenceAnnotator)IOUtil.loadSerialized(loadFile);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("can't load annotator from " + loadFile + ": " + ex);
            }
            ConfidenceReportingSequenceAnnotator crAnn = new ConfidenceReportingSequenceAnnotator(ann);
            crAnn.annotate(labels);
            Iterator<Span> i = labels.instanceIterator(crAnn.getSpanType());
            while (i.hasNext()) {
                Span s = i.next();
                Details d = labels.getDetails(s, crAnn.getSpanType());
                System.out.println("confidence=" + d.getConfidence() + " for span " + s);
            }
            return;
        }
        if (args.length != 2) {
            throw new IllegalArgumentException("usage: previouslySavedAnnotatorFile newAnnotatorFile");
        }
        File loadFile = new File(args[0]);
        File saveFile = new File(args[1]);
        Annotator ann = null;
        try {
            ann = (Annotator)((Object)IOUtil.loadSerialized(loadFile));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("can't load annotator from " + loadFile + ": " + ex);
        }
        if (!(ann instanceof SequenceAnnotatorLearner.SequenceAnnotator)) {
            throw new IllegalArgumentException(loadFile + " does not contain an annotator learned with a SequenceAnnotatorLearner");
        }
        SequenceAnnotatorLearner.SequenceAnnotator seqAnn = (SequenceAnnotatorLearner.SequenceAnnotator)ann;
        ConfidenceReportingSequenceAnnotator newAnnotator = new ConfidenceReportingSequenceAnnotator(seqAnn);
        try {
            IOUtil.saveSerialized(newAnnotator, saveFile);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("can't save new annotator in " + saveFile + ": " + ex);
        }
    }
}

