/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn;

import com.lgc.wsh.inv.ScalarSolver;
import edu.cmu.minorthird.classify.sequential.CMM;
import edu.cmu.minorthird.classify.sequential.CMMTweaker;
import edu.cmu.minorthird.classify.sequential.SequenceClassifier;
import edu.cmu.minorthird.text.FancyLoader;
import edu.cmu.minorthird.text.SpanDifference;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.learn.ExtractorAnnotator;
import edu.cmu.minorthird.text.learn.SequenceAnnotatorLearner;
import edu.cmu.minorthird.util.BasicCommandLineProcessor;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class ExtractorTweaker {
    private CMMTweaker cmmTweaker = new CMMTweaker();
    private File fromFile = null;
    private File toFile = null;
    private TextLabels textLabels = null;
    private String spanType = null;
    private double newBias = 0.0;
    private double lo = -999.0;
    private double hi = 999.0;
    private double beta = 1.0;
    private boolean biasSpecified = false;
    private boolean loSpecified = false;
    private boolean hiSpecified = false;
    private static final String[] USAGE = new String[]{"ExtractorTweaker: modify the recall/precision of a previously-learned extractor", "", "Parameters:", " -loadFrom FILE                where to load a previously-learner extractor from", " [-saveAs FILE]                where to save the 'tweaked' version of the extractor", " [-newBias NUM]                new value that replaces the hyperplane_bias term of the NEG hyperplane", " [-loBias NUM]                 lower limit of search for best bias term", " [-hiBias NUM]                 lower limit of search for best bias term", "", "If -newBias is NOT specified, then ExtractorTweaker will try and find a 'good' value", "on its own, using bisection search, guided by the following additional parameters:", "  -labels KEY -spanType TYPE [-beta BETA]", "where -labels KEY -spanType TYPE specifies the dataset to use in opimizing the extractor", "and -beta BETA determines the function to optimize, namely token-level F_beta (default, beta=1)", "It seems to work ok to optimize performance on the dataset used for training.", ""};

    public double getOldBias() {
        return this.cmmTweaker.oldBias();
    }

    public double getNewBias() {
        return this.cmmTweaker.newBias();
    }

    public ExtractorAnnotator tweak(ExtractorAnnotator annotator, double bias) {
        if (annotator instanceof SequenceAnnotatorLearner.SequenceAnnotator) {
            SequenceAnnotatorLearner.SequenceAnnotator sa = (SequenceAnnotatorLearner.SequenceAnnotator)annotator;
            SequenceClassifier sc = sa.getSequenceClassifier();
            if (sc instanceof CMM) {
                CMM cmm = (CMM)sc;
                return new SequenceAnnotatorLearner.SequenceAnnotator(this.cmmTweaker.tweak(cmm, bias), sa.getSpanFeatureExtractor(), sa.getReduction(), sa.getSpanType());
            }
            throw new IllegalArgumentException("can't tweak annotator based on sequence classifier of type " + sc.getClass());
        }
        throw new IllegalArgumentException("can't tweak annotator of type " + annotator.getClass());
    }

    public CommandLineProcessor getCLP() {
        return new MyCLP();
    }

    private void doMain() {
        if (this.fromFile == null) {
            throw new IllegalStateException("need to specify -loadFrom");
        }
        ExtractorAnnotator annotator = null;
        try {
            System.out.println("loading from: " + this.fromFile);
            annotator = (ExtractorAnnotator)((Object)IOUtil.loadSerialized(this.fromFile));
        }
        catch (IOException ex) {
            System.out.println("can't load " + this.fromFile + ": " + ex);
        }
        ExtractorAnnotator tweaked = null;
        if (this.biasSpecified) {
            tweaked = this.tweak(annotator, this.newBias);
        } else if (!this.biasSpecified && this.textLabels != null && this.spanType != null) {
            if (!this.loSpecified || !this.hiSpecified) {
                this.tweak(annotator, 0.0);
                double v = this.getOldBias();
                if (v < 0.0) {
                    v = -v;
                }
                if (v == 0.0) {
                    v = 0.1;
                }
                if (!this.loSpecified) {
                    this.lo = -10.0 * v;
                }
                if (!this.hiSpecified) {
                    this.hi = 10.0 * v;
                }
                System.out.println("oldBias term was " + v + " testing between " + this.lo + " and " + this.hi);
            }
            System.out.println("try to maximize token F[beta] for beta=" + this.beta + " (b>1 rewards recall, b<1 precision)");
            AnnTester annTester = new AnnTester(annotator, this.beta);
            ScalarSolver solver = new ScalarSolver(annTester);
            double optBias = solver.solve(this.lo, this.hi, 0.01, 0.01, 40, null);
            tweaked = this.tweak(annotator, optBias);
        } else {
            System.out.println("illegal usage, use -help for help");
        }
        try {
            if (this.toFile != null) {
                IOUtil.saveSerialized((Serializable)((Object)tweaked), this.toFile);
            }
        }
        catch (IOException ex) {
            System.out.println("can't save to " + this.toFile + ": " + this.toFile);
        }
    }

    public static void main(String[] args) {
        try {
            ExtractorTweaker xt = new ExtractorTweaker();
            xt.getCLP().processArguments(args);
            xt.doMain();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class AnnTester
    implements ScalarSolver.Function {
        private ExtractorAnnotator ann;
        private double beta = 1.0;

        public AnnTester(ExtractorAnnotator annotator, double beta) {
            this.ann = annotator;
            this.beta = beta;
        }

        public double function(double d) {
            ExtractorAnnotator tweakedAnn = ExtractorTweaker.this.tweak(this.ann, d);
            TextLabels annLabels = tweakedAnn.annotatedCopy(ExtractorTweaker.this.textLabels);
            SpanDifference sd = new SpanDifference(annLabels.instanceIterator(this.ann.getSpanType()), annLabels.instanceIterator(ExtractorTweaker.this.spanType), annLabels.closureIterator(ExtractorTweaker.this.spanType));
            double f = 0.0;
            double p = sd.tokenPrecision();
            double r = sd.tokenRecall();
            if (p != 0.0 || p != 0.0) {
                f = (this.beta * this.beta + 1.0) * p * r / (this.beta * this.beta * p + r);
            }
            System.out.println("after testing bias " + d + " yields f[" + this.beta + "]=" + f + " for p/r of " + p + "/" + r);
            return -f;
        }
    }

    public class MyCLP
    extends BasicCommandLineProcessor {
        public void loadFrom(String s) {
            ExtractorTweaker.this.fromFile = new File(s);
        }

        public void saveAs(String s) {
            ExtractorTweaker.this.toFile = new File(s);
        }

        public void labels(String s) {
            ExtractorTweaker.this.textLabels = FancyLoader.loadTextLabels(s);
        }

        public void spanType(String s) {
            ExtractorTweaker.this.spanType = s;
        }

        public void newBias(String s) {
            ExtractorTweaker.this.newBias = StringUtil.atof(s);
            ExtractorTweaker.this.biasSpecified = true;
        }

        public void loBias(String s) {
            ExtractorTweaker.this.lo = StringUtil.atof(s);
            ExtractorTweaker.this.loSpecified = true;
        }

        public void hiBias(String s) {
            ExtractorTweaker.this.hi = StringUtil.atof(s);
            ExtractorTweaker.this.hiSpecified = true;
        }

        public void beta(String s) {
            ExtractorTweaker.this.beta = StringUtil.atof(s);
        }

        public void usage() {
            for (int i = 0; i < USAGE.length; ++i) {
                System.out.println(USAGE[i]);
            }
        }
    }
}

