/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn;

import edu.cmu.minorthird.classify.multi.MultiClassLabel;
import edu.cmu.minorthird.classify.multi.MultiClassifier;
import edu.cmu.minorthird.text.AbstractAnnotator;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.learn.SpanFeatureExtractor;
import java.io.Serializable;
import java.util.Iterator;

public class MultiClassifierAnnotator
extends AbstractAnnotator
implements Serializable {
    private static final long serialVersionUID = 20080306L;
    private SpanFeatureExtractor fe;
    private MultiClassifier mc;
    private String[] multiSpanProp = null;

    public MultiClassifierAnnotator(SpanFeatureExtractor fe, MultiClassifier mc, String[] multiSpanProp) {
        this.fe = fe;
        this.mc = mc;
        this.multiSpanProp = multiSpanProp;
    }

    public SpanFeatureExtractor getFE() {
        return this.fe;
    }

    public MultiClassifier getMultiClassifier() {
        return this.mc;
    }

    public String[] getMultiSpanProperty() {
        return this.multiSpanProp;
    }

    public void doAnnotate(MonotonicTextLabels labels) {
        Iterator<Span> candidateLooper;
        Iterator<Span> i = candidateLooper = labels.getTextBase().documentSpanIterator();
        while (i.hasNext()) {
            Span s = i.next();
            MultiClassLabel classOfS = this.mc.multiLabelClassification(this.fe.extractInstance(labels, s));
            String[] bestClassNames = classOfS.bestClassName();
            for (int j = 0; j < bestClassNames.length; ++j) {
                labels.setProperty(s, this.multiSpanProp[j], "_predicted_" + bestClassNames[j]);
            }
        }
    }

    public String explainAnnotation(TextLabels labels, Span documentSpan) {
        return this.mc.explain(this.fe.extractInstance(labels, documentSpan));
    }
}

