/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.OnlineClassifierLearner;
import edu.cmu.minorthird.text.AbstractAnnotator;
import edu.cmu.minorthird.text.BasicTextBase;
import edu.cmu.minorthird.text.BasicTextLabels;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.learn.BinaryTextClassifier;
import edu.cmu.minorthird.text.learn.ClassifierAnnotator;
import edu.cmu.minorthird.text.learn.OnlineTextClassifierLearner;
import edu.cmu.minorthird.text.learn.SpanFeatureExtractor;
import edu.cmu.minorthird.text.learn.TextClassifier;
import edu.cmu.minorthird.ui.Recommended;
import java.io.Serializable;
import java.util.Iterator;

public class OnlineBinaryTextClassifierLearner
extends AbstractAnnotator
implements OnlineTextClassifierLearner,
Serializable {
    static final long serialVersionUID = 20080306L;
    private SpanFeatureExtractor fe = null;
    public OnlineClassifierLearner learner;
    public String spanType;
    public String outputType;
    private int docNum;
    private static final String DOC = "OnlineDocument_";

    public OnlineBinaryTextClassifierLearner(OnlineClassifierLearner learner, String spanType) {
        this(learner, spanType, null, null);
    }

    public OnlineBinaryTextClassifierLearner(OnlineClassifierLearner learner, String spanType, TextLabels labeledData) {
        this(learner, spanType, labeledData, null);
    }

    public OnlineBinaryTextClassifierLearner(OnlineClassifierLearner learner, String spanType, TextLabels labeledData, SpanFeatureExtractor fe) {
        this.learner = learner;
        this.spanType = spanType;
        this.outputType = "_predicted_" + spanType;
        this.docNum = 0;
        this.fe = fe != null ? fe : new Recommended.DocumentFE();
        if (labeledData != null) {
            this.addLabeledData(labeledData);
        }
    }

    private void addLabeledData(TextLabels labels) {
        TextBase tb = labels.getTextBase();
        Iterator<Span> looper = tb.documentSpanIterator();
        while (looper.hasNext()) {
            Span s = looper.next();
            int classLabel = labels.hasType(s, this.spanType) ? 1 : -1;
            Instance i = this.fe.extractInstance(labels, s);
            Example ex = new Example(i, ClassLabel.binaryLabel(classLabel));
            this.learner.addExample(ex);
        }
    }

    public void addDocument(String label, String text) {
        BasicTextBase tb = new BasicTextBase();
        ++this.docNum;
        String docID = DOC + this.docNum;
        tb.loadDocument(docID, text);
        BasicTextLabels textLabels = new BasicTextLabels(tb);
        Span docSpan = tb.documentSpan(docID);
        textLabels.addToType(docSpan, label);
        int classLabel = textLabels.hasType(docSpan, this.spanType) ? 1 : -1;
        Instance i = this.fe.extractInstance(textLabels, docSpan);
        Example ex = new Example(i, ClassLabel.binaryLabel(classLabel));
        this.learner.addExample(ex);
    }

    public TextClassifier getTextClassifier() {
        BinaryTextClassifier tc = new BinaryTextClassifier(this.learner, this.fe);
        return tc;
    }

    public Classifier getClassifier() {
        return this.learner.getClassifier();
    }

    public void completeTraining() {
        this.learner.completeTraining();
    }

    public void reset() {
        this.learner.reset();
    }

    public String[] getTypes() {
        String[] types2 = new String[]{this.spanType, "NOT" + this.spanType};
        return types2;
    }

    public void doAnnotate(MonotonicTextLabels labels) {
        Iterator<Span> candidateLooper = labels.getTextBase().documentSpanIterator();
        Classifier c = this.learner.getClassifier();
        Iterator<Span> i = candidateLooper;
        while (i.hasNext()) {
            Span s = i.next();
            ClassLabel classOfS = c.classification(this.fe.extractInstance(labels, s));
            if (this.spanType == null || !classOfS.isPositive()) continue;
            labels.addToType(s, this.outputType);
        }
    }

    public String explainAnnotation(TextLabels labels, Span documentSpan) {
        Classifier c = this.learner.getClassifier();
        return c.explain(this.fe.extractInstance(labels, documentSpan));
    }

    public ClassifierAnnotator getAnnotator() {
        ClassifierAnnotator ann = new ClassifierAnnotator(this.fe, this.getClassifier(), this.outputType, null, null);
        return ann;
    }
}

