/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.sequential.BatchSegmenterLearner;
import edu.cmu.minorthird.classify.sequential.MutableCandidateSegmentGroup;
import edu.cmu.minorthird.classify.sequential.SegmentCollinsPerceptronLearner;
import edu.cmu.minorthird.classify.sequential.SegmentDataset;
import edu.cmu.minorthird.classify.sequential.Segmentation;
import edu.cmu.minorthird.classify.sequential.Segmenter;
import edu.cmu.minorthird.text.AbstractAnnotator;
import edu.cmu.minorthird.text.Annotator;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.learn.AnnotationExample;
import edu.cmu.minorthird.text.learn.AnnotatorLearner;
import edu.cmu.minorthird.text.learn.ExtractorAnnotator;
import edu.cmu.minorthird.text.learn.SpanFeatureExtractor;
import edu.cmu.minorthird.ui.Recommended;
import edu.cmu.minorthird.util.ProgressCounter;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import edu.cmu.minorthird.util.gui.Visible;
import java.io.Serializable;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentAnnotatorLearner
extends AnnotatorLearner {
    private static Logger log = Logger.getLogger(SegmentAnnotatorLearner.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    protected String annotationType = "_prediction";
    protected SegmentDataset dataset;
    protected BatchSegmenterLearner learner;
    protected SpanFeatureExtractor fe;
    protected int maxWindowSize;
    private boolean displayDatasetBeforeLearning = false;
    private boolean compressDataset = true;
    private Iterator<Span> documentLooper;

    public SegmentAnnotatorLearner() {
        this(new SegmentCollinsPerceptronLearner(), new Recommended.MultitokenSpanFE());
    }

    public SegmentAnnotatorLearner(BatchSegmenterLearner learner, SpanFeatureExtractor fe) {
        this(learner, fe, 4);
    }

    public SegmentAnnotatorLearner(BatchSegmenterLearner learner, SpanFeatureExtractor fe, int windowSize) {
        this.learner = learner;
        this.fe = fe;
        this.maxWindowSize = windowSize;
        this.reset();
    }

    @Override
    public void reset() {
        this.dataset = new SegmentDataset();
        this.dataset.setDataCompression(this.compressDataset);
    }

    public boolean getDisplayDatasetBeforeLearning() {
        return this.displayDatasetBeforeLearning;
    }

    public void setDisplayDatasetBeforeLearning(boolean newDisplayDatasetBeforeLearning) {
        this.displayDatasetBeforeLearning = newDisplayDatasetBeforeLearning;
    }

    public String getDisplayDatasetBeforeLearningHelp() {
        return "Pop up an interactive viewer of the sequential dataset before learning.";
    }

    public boolean getCompressDataset() {
        return this.compressDataset;
    }

    public void setCompressDataset(boolean flag) {
        this.compressDataset = flag;
    }

    public String getCompressDatasetHelp() {
        return "If set, try and compress the data. This leads to longer loading and <br>learning times but less memory usage.";
    }

    public int getHistorySize() {
        return 1;
    }

    public BatchSegmenterLearner getSemiMarkovLearner() {
        return this.learner;
    }

    public void setSemiMarkovLearner(BatchSegmenterLearner learner) {
        this.learner = learner;
    }

    public String getSemiMarkovLearnerHelp() {
        return "Set the SemiMarkowLearner to be used";
    }

    @Override
    public SpanFeatureExtractor getSpanFeatureExtractor() {
        return this.fe;
    }

    @Override
    public void setSpanFeatureExtractor(SpanFeatureExtractor fe) {
        this.fe = fe;
    }

    @Override
    public void setAnnotationType(String s) {
        this.annotationType = s;
    }

    @Override
    public String getAnnotationType() {
        return this.annotationType;
    }

    @Override
    public void setDocumentPool(Iterator<Span> documentLooper) {
        this.documentLooper = documentLooper;
    }

    @Override
    public boolean hasNextQuery() {
        return this.documentLooper.hasNext();
    }

    @Override
    public Span nextQuery() {
        return this.documentLooper.next();
    }

    @Override
    public void setAnswer(AnnotationExample answeredQuery) {
        Span document = answeredQuery.getDocumentSpan();
        MutableCandidateSegmentGroup g = new MutableCandidateSegmentGroup(this.maxWindowSize, document.size());
        for (int lo = 0; lo < document.size(); ++lo) {
            for (int len = 1; len <= this.maxWindowSize; ++len) {
                if (len + lo > document.size()) continue;
                Span span = document.subSpan(lo, len);
                Instance instance = this.fe.extractInstance(answeredQuery.getLabels(), span);
                ClassLabel label = new ClassLabel(answeredQuery.getClassName(span));
                g.setSubsequence(lo, lo + len, instance, label);
            }
        }
        this.dataset.addCandidateSegmentGroup(g);
    }

    @Override
    public Annotator getAnnotator() {
        this.learner.setSchema(ExampleSchema.BINARY_EXAMPLE_SCHEMA);
        if (this.displayDatasetBeforeLearning) {
            new ViewerFrame("Sequential Dataset", this.dataset.toGUI());
        }
        Segmenter segmenter = this.learner.batchTrain(this.dataset);
        if (DEBUG) {
            log.debug("learned segmenter: " + segmenter);
        }
        return new SegmentAnnotator(segmenter, this.fe, this.maxWindowSize, this.annotationType);
    }

    public static class SegmentAnnotator
    extends AbstractAnnotator
    implements Serializable,
    Visible,
    ExtractorAnnotator {
        private static final long serialVersionUID = 1L;
        private Segmenter segmenter;
        private SpanFeatureExtractor fe;
        private String annotationType;
        private int maxWindowSize;

        public SegmentAnnotator(Segmenter segmenter, SpanFeatureExtractor fe, int maxWindowSize, String annotationType) {
            this.segmenter = segmenter;
            this.fe = fe;
            this.maxWindowSize = maxWindowSize;
            this.annotationType = annotationType;
        }

        public String getSpanType() {
            return this.annotationType;
        }

        protected void doAnnotate(MonotonicTextLabels labels) {
            Iterator<Span> i = labels.getTextBase().documentSpanIterator();
            ProgressCounter pc = new ProgressCounter("tagging with segmenter", "document");
            while (i.hasNext()) {
                Span document = i.next();
                MutableCandidateSegmentGroup g = new MutableCandidateSegmentGroup(this.maxWindowSize, document.size());
                for (int lo = 0; lo < document.size(); ++lo) {
                    for (int len = 1; len <= this.maxWindowSize; ++len) {
                        if (len + lo > document.size()) continue;
                        Span span = document.subSpan(lo, len);
                        Instance instance = this.fe.extractInstance(labels, span);
                        g.setSubsequence(lo, lo + len, instance);
                    }
                }
                Segmentation segmentation = this.segmenter.segmentation(g);
                if (DEBUG) {
                    log.debug("slidingWindowGroup: " + g);
                }
                if (DEBUG) {
                    log.debug("segmentation: " + segmentation);
                }
                Iterator<Segmentation.Segment> j = segmentation.iterator();
                while (j.hasNext()) {
                    Segmentation.Segment seg = j.next();
                    String type = segmentation.className(seg);
                    if (type == null) continue;
                    Span span = document.subSpan(seg.lo, seg.hi - seg.lo);
                    labels.addToType(span, this.annotationType);
                    if (!DEBUG) continue;
                    log.debug("span of type: " + this.annotationType + ": " + span);
                }
                pc.progress();
            }
            pc.finished();
        }

        public String explainAnnotation(TextLabels labels, Span documentSpan) {
            return "not implemented";
        }

        public String toString() {
            return "[SegmentAnnotator " + this.annotationType + ":\n" + this.segmenter + "]";
        }

        public Viewer toGUI() {
            ComponentViewer v = new ComponentViewer(){
                static final long serialVersionUID = 20080306L;

                public JComponent componentFor(Object o) {
                    SegmentAnnotator sa = (SegmentAnnotator)o;
                    JPanel mainPanel = new JPanel();
                    mainPanel.setBorder(new TitledBorder("Segmenter Annotator"));
                    SmartVanillaViewer subView = new SmartVanillaViewer(sa.segmenter);
                    subView.setSuperView(this);
                    mainPanel.add(subView);
                    return new JScrollPane(mainPanel);
                }
            };
            v.setContent(this);
            return v;
        }
    }
}

