/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.sequential.BatchSequenceClassifierLearner;
import edu.cmu.minorthird.classify.sequential.CollinsPerceptronLearner;
import edu.cmu.minorthird.classify.sequential.SequenceClassifier;
import edu.cmu.minorthird.classify.sequential.SequenceDataset;
import edu.cmu.minorthird.text.AbstractAnnotator;
import edu.cmu.minorthird.text.Annotator;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.learn.AbstractBatchAnnotatorLearner;
import edu.cmu.minorthird.text.learn.Extraction2TaggingReduction;
import edu.cmu.minorthird.text.learn.ExtractorAnnotator;
import edu.cmu.minorthird.text.learn.InsideOutsideReduction;
import edu.cmu.minorthird.text.learn.SpanFeatureExtractor;
import edu.cmu.minorthird.text.learn.TextLabelsAnnotatorTeacher;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.ProgressCounter;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import edu.cmu.minorthird.util.gui.Visible;
import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class SequenceAnnotatorLearner
extends AbstractBatchAnnotatorLearner {
    private static Logger log = Logger.getLogger(SequenceAnnotatorLearner.class);
    private static final boolean DEBUG = false;
    protected BatchSequenceClassifierLearner seqLearner;
    private boolean displayDatasetBeforeLearning = false;

    public SequenceAnnotatorLearner() {
        this.seqLearner = new CollinsPerceptronLearner();
    }

    public SequenceAnnotatorLearner(BatchSequenceClassifierLearner seqLearner, SpanFeatureExtractor fe) {
        super(fe, new InsideOutsideReduction());
        this.seqLearner = seqLearner;
    }

    public SequenceAnnotatorLearner(BatchSequenceClassifierLearner seqLearner, SpanFeatureExtractor fe, Extraction2TaggingReduction reduction) {
        super(fe, reduction);
        this.seqLearner = seqLearner;
    }

    public boolean getDisplayDatasetBeforeLearning() {
        return this.displayDatasetBeforeLearning;
    }

    public void setDisplayDatasetBeforeLearning(boolean newDisplayDatasetBeforeLearning) {
        this.displayDatasetBeforeLearning = newDisplayDatasetBeforeLearning;
    }

    public BatchSequenceClassifierLearner getSequenceClassifierLearner() {
        return this.seqLearner;
    }

    public void setSequenceClassifierLearner(BatchSequenceClassifierLearner learner) {
        this.seqLearner = learner;
    }

    public String getDisplayDatasetBeforeLearningHelp() {
        return "Pop up an interactive viewer of the sequential dataset before learning.";
    }

    public String getSequenceClassifierLearnerHelp() {
        return "The classifierLearner used to classify each token using the <br>predictions of previous tokens as features";
    }

    public Annotator getAnnotator() {
        ExampleSchema schema = this.seqData.getSchema();
        if (schema.getNumberOfClasses() <= 1) {
            log.error("In the constructed dataset the number of classes is " + schema.getNumberOfClasses());
            log.error("Hint: this probably means that no spans of the specified type are present in your data");
        }
        this.seqLearner.setSchema(schema);
        if (this.displayDatasetBeforeLearning) {
            new ViewerFrame("Sequential Dataset", this.seqData.toGUI());
        }
        SequenceClassifier seqClassifier = this.seqLearner.batchTrain(this.seqData);
        return new SequenceAnnotator(seqClassifier, this.fe, this.reduction, this.annotationType);
    }

    public static SequenceDataset prepareSequenceData(TextLabels labels, String spanType, String spanProp, SpanFeatureExtractor fe, final int historySize, Extraction2TaggingReduction reduction) {
        BatchSequenceClassifierLearner dummy1 = new BatchSequenceClassifierLearner(){

            public void setSchema(ExampleSchema schema) {
            }

            public SequenceClassifier batchTrain(SequenceDataset dataset) {
                return null;
            }

            public int getHistorySize() {
                return historySize;
            }
        };
        SequenceAnnotatorLearner dummy2 = new SequenceAnnotatorLearner(dummy1, fe, reduction){

            public Annotator getAnnotator() {
                return null;
            }
        };
        new TextLabelsAnnotatorTeacher(labels, spanType, spanProp).train(dummy2);
        return dummy2.getSequenceDataset();
    }

    public static void main(String[] args) {
        try {
            SequenceAnnotator a = (SequenceAnnotator)IOUtil.loadSerialized(new File(args[0]));
            a.annotationType = args[1];
            IOUtil.saveSerialized(a, new File(args[2]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("usage: inputFile new-annotation-type outputfile");
        }
    }

    public static class SequenceAnnotator
    extends AbstractAnnotator
    implements Serializable,
    Visible,
    ExtractorAnnotator {
        private static final long serialVersionUID = 2L;
        private SequenceClassifier seqClassifier;
        private SpanFeatureExtractor fe;
        private Extraction2TaggingReduction reduction;
        private String annotationType;

        public SequenceAnnotator(SequenceClassifier seqClassifier, SpanFeatureExtractor fe, String annotationType) {
            this(seqClassifier, fe, new InsideOutsideReduction(), annotationType);
        }

        public SequenceAnnotator(SequenceClassifier seqClassifier, SpanFeatureExtractor fe, Extraction2TaggingReduction reduction, String annotationType) {
            this.seqClassifier = seqClassifier;
            this.fe = fe;
            this.reduction = reduction;
            this.annotationType = annotationType;
        }

        public String getSpanType() {
            return this.annotationType;
        }

        public SpanFeatureExtractor getSpanFeatureExtractor() {
            return this.fe;
        }

        public Extraction2TaggingReduction getReduction() {
            return this.reduction;
        }

        public SequenceClassifier getSequenceClassifier() {
            return this.seqClassifier;
        }

        protected void doAnnotate(MonotonicTextLabels labels) {
            Iterator<Span> i = labels.getTextBase().documentSpanIterator();
            ProgressCounter pc = new ProgressCounter("tagging with classifier", "document");
            while (i.hasNext()) {
                Span s = i.next();
                Instance[] sequence = new Instance[s.size()];
                for (int j = 0; j < s.size(); ++j) {
                    Span tokenSpan = s.subSpan(j, 1);
                    sequence[j] = this.fe.extractInstance(labels, tokenSpan);
                }
                ClassLabel[] classLabels = this.seqClassifier.classification(sequence);
                for (int j = 0; j < classLabels.length; ++j) {
                    labels.setProperty(s.getToken(j), this.reduction.getTokenProp(), classLabels[j].bestClassName());
                }
                pc.progress();
            }
            pc.finished();
            this.reduction.extractFromTags(this.annotationType, labels);
        }

        public String explainAnnotation(TextLabels labels, Span documentSpan) {
            return "not implemented";
        }

        public String toString() {
            return "[SequenceAnnotator " + this.annotationType + ":\n" + this.seqClassifier + "]";
        }

        public Viewer toGUI() {
            ComponentViewer v = new ComponentViewer(){
                static final long serialVersionUID = 20080306L;

                public JComponent componentFor(Object o) {
                    SequenceAnnotator sa = (SequenceAnnotator)o;
                    JPanel mainPanel = new JPanel();
                    mainPanel.setBorder(new TitledBorder("Sequence Annotator"));
                    SmartVanillaViewer subView = new SmartVanillaViewer(sa.seqClassifier);
                    subView.setSuperView(this);
                    mainPanel.add(subView);
                    return new JScrollPane(mainPanel);
                }
            };
            v.setContent(this);
            return v;
        }
    }
}

