/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn;

import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.MutableInstance;
import edu.cmu.minorthird.text.AnnotatorLoader;
import edu.cmu.minorthird.text.EmptyLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.StopWords;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.Token;
import edu.cmu.minorthird.text.learn.Bag;
import edu.cmu.minorthird.text.learn.FeatureBuffer;
import edu.cmu.minorthird.text.learn.MixupCompatible;
import edu.cmu.minorthird.text.learn.SpanFeatureExtractor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SpanFE
implements SpanFeatureExtractor,
MixupCompatible,
Serializable {
    private static final long serialVersionUID = 20080306L;
    public static final int STORE_AS_BINARY = 1;
    public static final int STORE_AS_COUNTS = 2;
    public static final int STORE_COMPACTLY = 3;
    private int featureStoragePolicy = 2;
    protected transient MutableInstance instance;
    private transient TextLabels textLabels = new EmptyLabels();
    protected String requiredAnnotation = null;
    protected String requiredAnnotationFileToLoad = null;
    protected AnnotatorLoader annotatorLoader = null;

    public void setFeatureStoragePolicy(int p) {
        this.featureStoragePolicy = p;
    }

    public void setRequiredAnnotation(String requiredAnnotation, String annotationProvider) {
        this.setRequiredAnnotation(requiredAnnotation);
        this.setAnnotationProvider(annotationProvider);
    }

    public void setRequiredAnnotation(String requiredAnnotation) {
        this.requiredAnnotation = requiredAnnotation;
    }

    public String getRequiredAnnotation() {
        return this.requiredAnnotation == null ? "" : this.requiredAnnotation;
    }

    public void setAnnotationProvider(String classNameOrMixupFileName) {
        this.requiredAnnotationFileToLoad = classNameOrMixupFileName;
    }

    public String getAnnotationProvider() {
        return this.requiredAnnotationFileToLoad == null ? "" : this.requiredAnnotationFileToLoad;
    }

    public void setAnnotatorLoader(AnnotatorLoader newLoader) {
        this.annotatorLoader = newLoader;
    }

    public void requireMyAnnotation(TextLabels labels) {
        labels.require(this.requiredAnnotation, this.requiredAnnotationFileToLoad, this.annotatorLoader);
    }

    public final Instance extractInstance(Span span) {
        this.instance = new MutableInstance(span, span.getDocumentGroupId());
        this.extractFeatures(span);
        return this.instance;
    }

    public final Instance extractInstance(TextLabels labels, Span span) {
        this.instance = new MutableInstance(span, span.getDocumentGroupId());
        this.textLabels = labels;
        this.extractFeatures(labels, span);
        return this.instance;
    }

    public final SpanResult from(Span s) {
        return new SpanResult(new String[0], this, s);
    }

    public static final SpanResult from(Span s, FeatureBuffer buffer) {
        return new SpanResult(new String[0], buffer, s);
    }

    public void emit(StringBagResult result) {
        Iterator<String> i = result.asBag().iterator();
        while (i.hasNext()) {
            String s = i.next();
            Feature f = new Feature(result.extend(s));
            if (this.featureStoragePolicy == 1) {
                this.instance.addBinary(f);
                continue;
            }
            int c = result.asBag().getCount(s);
            if (this.featureStoragePolicy == 3 && c == 1) {
                this.instance.addBinary(f);
                continue;
            }
            this.instance.addNumeric(f, c);
        }
    }

    public void emit(TokenSetResult result) {
        this.emit(result.eq());
    }

    public void emit(SpanSetResult result) {
        this.emit(result.tokens());
    }

    public void emit(SpanResult result) {
        this.emit(result.tokens());
    }

    public void extractFeatures(Span span) {
        throw new IllegalStateException("you probably meant to use extractFeatures(labels,span) instead");
    }

    public abstract void extractFeatures(TextLabels var1, Span var2);

    public void trace(Result result) {
        String[] name = result.getName();
        for (int i = 0; i < name.length; ++i) {
            System.out.print(" " + name[i]);
        }
        System.out.println(" -> " + result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Function {
        public abstract String getName();

        public abstract <T> T apply(T var1);
    }

    public static abstract class Filter {
        public abstract String getName();

        public abstract boolean match(Object var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringBagResult
    extends SetResult<String> {
        private Bag<String> bag;

        public StringBagResult(String[] name, SpanFE fe, Bag<String> bag) {
            super(name, fe, bag.asSet());
            this.bag = bag;
        }

        @Override
        public void emit() {
            this.fe.emit(this);
        }

        public StringBagResult trace() {
            return (StringBagResult)this.doTrace();
        }

        public String toString() {
            return "[StringBagResult: " + this.bag + "]";
        }

        public Bag<String> asBag() {
            return this.bag;
        }

        public StringBagResult lc() {
            Bag<String> lcBag = new Bag<String>();
            Iterator<String> i = this.bag.iterator();
            while (i.hasNext()) {
                String str = i.next();
                int n = this.bag.getCount(str);
                lcBag.add(str.toLowerCase(), n);
            }
            return new StringBagResult(this.extend("lc"), this.fe, lcBag);
        }

        public StringBagResult toConst(String replacement) {
            Bag<String> trBag = new Bag<String>();
            Iterator<String> i = this.bag.iterator();
            while (i.hasNext()) {
                String str = i.next();
                int n = this.bag.getCount(str);
                trBag.add(replacement, n);
            }
            return new StringBagResult(this.extend("toConst"), this.fe, trBag);
        }

        public StringBagResult tr(String regex, String replacement) {
            Bag<String> trBag = new Bag<String>();
            Iterator<String> i = this.bag.iterator();
            while (i.hasNext()) {
                String str = i.next();
                int n = this.bag.getCount(str);
                trBag.add(str.replaceAll(regex, replacement), n);
            }
            return new StringBagResult(this.extend("tr/" + regex + "/" + replacement), this.fe, trBag);
        }

        public StringBagResult charTypes() {
            Bag<String> trBag = new Bag<String>();
            Iterator<String> i = this.bag.iterator();
            while (i.hasNext()) {
                String str = i.next();
                String charTypes = str.replaceAll("[A-Z]", "A").replaceAll("[a-z]", "a").replaceAll("[0-9]", "0");
                int n = this.bag.getCount(str);
                trBag.add(charTypes, n);
            }
            return new StringBagResult(this.extend("charTypes"), this.fe, trBag);
        }

        public StringBagResult charTypePattern() {
            Bag<String> trBag = new Bag<String>();
            Iterator<String> i = this.bag.iterator();
            while (i.hasNext()) {
                String str = i.next();
                String pattern = str.replaceAll("[A-Z]+", "X+").replaceAll("[a-z]+", "x+").replaceAll("[0-9]+", "9+");
                int n = this.bag.getCount(str);
                trBag.add(pattern, n);
            }
            return new StringBagResult(this.extend("charTypePattern"), this.fe, trBag);
        }

        public StringBagResult punk() {
            Bag<String> punkBag = new Bag<String>();
            Iterator<String> i = this.bag.iterator();
            while (i.hasNext()) {
                String str = i.next();
                int n = this.bag.getCount(str);
                Pattern p = Pattern.compile("[\\W\\d]+");
                Matcher m = p.matcher(str);
                if (m.find()) continue;
                punkBag.add(str, n);
            }
            return new StringBagResult(this.extend("punk"), this.fe, punkBag);
        }

        public StringBagResult stopwords(String action) {
            String[] wordArray = StopWords.LONG;
            Bag<String> swBag = new Bag<String>();
            Iterator<String> i = this.bag.iterator();
            while (i.hasNext()) {
                String str = i.next();
                int n = this.bag.getCount(str);
                if (action.equalsIgnoreCase("use")) {
                    for (int j = 0; j < wordArray.length; ++j) {
                        if (!wordArray[j].equals(str)) continue;
                        swBag.add(str, n);
                    }
                    continue;
                }
                if (action.equalsIgnoreCase("remove")) {
                    boolean isAbsent = true;
                    for (int j = 0; j < wordArray.length; ++j) {
                        if (!wordArray[j].equals(str)) continue;
                        isAbsent = false;
                    }
                    if (!isAbsent) continue;
                    swBag.add(str, n);
                    continue;
                }
                throw new IllegalArgumentException("Error: action is missing!");
            }
            return new StringBagResult(this.extend("stopwords-" + action), this.fe, swBag);
        }

        public StringBagResult usewords(String filename) throws IOException {
            Bag<String> uwBag = new Bag<String>();
            Iterator<String> i = this.bag.iterator();
            while (i.hasNext()) {
                String line;
                String str = i.next();
                int n = this.bag.getCount(str);
                File dictFile = new File(filename);
                FileReader fr = new FileReader(dictFile);
                BufferedReader in = new BufferedReader(fr);
                while ((line = in.readLine()) != null) {
                    if (!(line = line.trim()).equals(str)) continue;
                    uwBag.add(str, n);
                }
            }
            return new StringBagResult(this.extend("usewords"), this.fe, uwBag);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TokenSetResult
    extends SetResult<Token> {
        public TokenSetResult(String[] name, SpanFE fe, SortedSet<Token> set) {
            super(name, fe, set);
        }

        public TokenSetResult trace() {
            return (TokenSetResult)this.doTrace();
        }

        @Override
        public void emit() {
            this.fe.emit(this);
        }

        public String toString() {
            return "[TokenSetResult: " + this.set + "]";
        }

        public StringBagResult eq() {
            Bag<String> stringBag = new Bag<String>();
            for (Token token : this.set) {
                stringBag.add(token.getValue());
            }
            return new StringBagResult(this.extend("eq"), this.fe, stringBag);
        }

        public StringBagResult prop(String property) {
            Bag<String> stringBag = new Bag<String>();
            for (Token token : this.set) {
                String value = this.fe.textLabels.getProperty(token, property);
                if (value == null) continue;
                stringBag.add(value);
            }
            return new StringBagResult(this.extend(property), this.fe, stringBag);
        }

        public TokenSetResult hasProp(String property) {
            TreeSet<Token> filteredSet = new TreeSet<Token>();
            for (Token token : this.set) {
                String value = this.fe.textLabels.getProperty(token, property);
                if (value == null) continue;
                filteredSet.add(token);
            }
            return new TokenSetResult(this.extend("hasProp_" + property), this.fe, (SortedSet<Token>)filteredSet);
        }

        public TokenSetResult hasProp(String property, String targetValue) {
            TreeSet<Token> filteredSet = new TreeSet<Token>();
            for (Token token : this.set) {
                String value = this.fe.textLabels.getProperty(token, property);
                if ((targetValue != null || value != null) && (targetValue == null || !targetValue.equals(value))) continue;
                filteredSet.add(token);
            }
            String targetValueTag = targetValue == null ? "NULL" : targetValue;
            return new TokenSetResult(this.extend("hasProp_" + property + "_" + targetValueTag), this.fe, (SortedSet<Token>)filteredSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SpanSetResult
    extends SetResult<Span> {
        public SpanSetResult(String[] name, SpanFE fe, SortedSet<Span> set) {
            super(name, fe, set);
        }

        public SpanSetResult trace() {
            return (SpanSetResult)this.doTrace();
        }

        @Override
        public void emit() {
            this.fe.emit(this);
        }

        public String toString() {
            return "[SpanSetResult: " + this.set + "]";
        }

        public SpanSetResult first() {
            TreeSet<Span> newSet = new TreeSet<Span>();
            if (this.set.size() > 0) {
                newSet.add((Span)this.set.first());
            }
            return new SpanSetResult(this.extend("first"), this.fe, (SortedSet<Span>)newSet);
        }

        public SpanSetResult last() {
            TreeSet<Span> newSet = new TreeSet<Span>();
            if (this.set.size() > 0) {
                newSet.add((Span)this.set.last());
            }
            return new SpanSetResult(this.extend("last"), this.fe, (SortedSet<Span>)newSet);
        }

        public TokenSetResult tokens() {
            TreeSet<Token> accum = new TreeSet<Token>();
            Iterator i = this.set.iterator();
            while (i.hasNext()) {
                SpanResult r = new SpanResult(this.name, this.fe, (Span)i.next());
                accum.addAll(r.tokens().asSet());
            }
            return new TokenSetResult(this.extend("tokens"), this.fe, (SortedSet<Token>)accum);
        }

        public StringBagResult eq() {
            Bag<String> stringBag = new Bag<String>();
            Iterator i = this.set.iterator();
            while (i.hasNext()) {
                stringBag.add(((Span)i.next()).asString());
            }
            return new StringBagResult(this.extend("eq"), this.fe, stringBag);
        }

        public SpanSetResult filter(Filter f) {
            return new SpanSetResult(this.extend("filter_" + f.getName()), this.fe, this.applyFilter(f));
        }

        public SpanSetResult map(Function f) {
            return new SpanSetResult(this.extend("map_" + f.getName()), this.fe, this.mapFunction(f));
        }
    }

    public static class SpanResult
    extends Result {
        private Span s;

        public SpanResult(String[] name, SpanFE fe, Span s) {
            super(name, fe);
            this.s = s;
        }

        public SpanResult trace() {
            return (SpanResult)this.doTrace();
        }

        public void emit() {
            this.fe.emit(this);
        }

        public String toString() {
            return "[SpanResult: " + this.s + "]";
        }

        public Span getSpan() {
            return this.s;
        }

        public SpanResult left() {
            Span lSpan = this.s.documentSpan().subSpan(0, this.s.documentSpanStartIndex());
            return new SpanResult(this.extend("left"), this.fe, lSpan);
        }

        public SpanResult right() {
            Span rSpan = this.s.documentSpan().subSpan(this.s.documentSpanStartIndex() + this.s.size(), this.s.documentSpan().size() - this.s.documentSpanStartIndex() - this.s.size());
            return new SpanResult(this.extend("right"), this.fe, rSpan);
        }

        public SpanResult doc() {
            Span docSpan = this.s.documentSpan();
            return new SpanResult(this.extend("doc"), this.fe, docSpan);
        }

        public SpanSetResult contains(String type) {
            TreeSet<Span> set = new TreeSet<Span>();
            Iterator<Span> i = this.fe.textLabels.instanceIterator(type, this.s.getDocumentId());
            while (i.hasNext()) {
                Span other = i.next();
                if (!this.s.contains(other)) continue;
                set.add(other);
            }
            return new SpanSetResult(this.extend("contains_" + type), this.fe, (SortedSet<Span>)set);
        }

        public SpanResult subSpan(int lo, int len) {
            if (this.s.size() == 0) {
                return this;
            }
            if (lo >= 0) {
                lo = Math.min(lo, this.s.size() - 1);
                len = Math.min(this.s.size() - lo, len);
                return new SpanResult(this.extend("subspan_" + lo + "_" + len), this.fe, this.s.subSpan(lo, len));
            }
            if (lo < 0) {
                lo = Math.max(this.s.size() + lo, 0);
                len = Math.min(this.s.size() - lo, len);
                return new SpanResult(this.extend("subspanNeg_" + lo + "_" + len), this.fe, this.s.subSpan(lo, len));
            }
            throw new IllegalArgumentException("illegal subSpan indices " + lo + ", " + len);
        }

        public TokenSetResult tokens() {
            TreeSet<Token> set = new TreeSet<Token>();
            for (int i = 0; i < this.s.size(); ++i) {
                set.add(this.s.getToken(i));
            }
            return new TokenSetResult(this.extend("tokens"), this.fe, (SortedSet<Token>)set);
        }

        public TokenSetResult token(int index) {
            String namex;
            int index1;
            if (index < 0) {
                index1 = this.s.size() + index;
                namex = "tokenNeg_" + -index;
            } else {
                index1 = index;
                namex = "token_" + index;
            }
            TreeSet<Token> set = new TreeSet<Token>();
            if (index1 >= 0 && index1 < this.s.size()) {
                set.add(this.s.getToken(index1));
            }
            return new TokenSetResult(this.extend(namex), this.fe, (SortedSet<Token>)set);
        }

        public StringBagResult eq() {
            Bag<String> stringBag = new Bag<String>();
            stringBag.add(this.s.asString());
            return new StringBagResult(this.extend("eq"), this.fe, stringBag);
        }

        public StringBagResult size() {
            Bag<String> stringBag = new Bag<String>();
            stringBag.add("#tokens", this.s.size());
            return new StringBagResult(this.name, this.fe, stringBag);
        }

        public StringBagResult exactSize() {
            Bag<String> stringBag = new Bag<String>();
            stringBag.add("#tokens_" + this.s.size());
            return new StringBagResult(this.name, this.fe, stringBag);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class SetResult<T>
    extends Result {
        protected SortedSet<T> set;

        public SetResult(String[] name, SpanFE fe, SortedSet<T> set) {
            super(name, fe);
            this.set = set;
            if (this.set == null) {
                throw new IllegalArgumentException("null set");
            }
        }

        public Set<T> asSet() {
            return this.set;
        }

        protected SortedSet<T> applyFilter(Filter f) {
            TreeSet s = new TreeSet();
            for (Object o : this.set) {
                if (!f.match(o)) continue;
                s.add(o);
            }
            return s;
        }

        protected SortedSet<T> mapFunction(Function f) {
            TreeSet s = new TreeSet();
            Iterator i = this.set.iterator();
            while (i.hasNext()) {
                s.add(f.apply(i.next()));
            }
            return s;
        }
    }

    public static abstract class Result {
        protected String[] name;
        protected SpanFE fe;

        public Result(String[] name, SpanFE fe) {
            this.name = name;
            this.fe = fe;
            if (fe == null) {
                throw new IllegalArgumentException("null fe");
            }
        }

        public String[] extend(String addition) {
            return this.extend(this.name, addition);
        }

        public String[] extend(String[] partial, String addition) {
            String[] extension = new String[partial.length + 1];
            for (int i = 0; i < partial.length; ++i) {
                extension[i] = partial[i];
            }
            extension[partial.length] = addition;
            return extension;
        }

        protected Result doTrace() {
            this.fe.trace(this);
            return this;
        }

        public String[] getName() {
            return this.name;
        }

        public abstract void emit();
    }
}

