/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.ui;

import edu.cmu.minorthird.text.MutableTextLabels;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.TextLabelsLoader;
import edu.cmu.minorthird.text.gui.TextBaseEditor;
import edu.cmu.minorthird.ui.CommandLineUtil;
import edu.cmu.minorthird.ui.UIMain;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.JointCommandLineProcessor;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.io.IOException;

public class EditLabels
extends UIMain {
    private CommandLineUtil.EditParams edit = new CommandLineUtil.EditParams();
    public MutableTextLabels editorOutputLabels = null;

    public CommandLineUtil.EditParams getEditParameters() {
        return this.edit;
    }

    public void setEditParameters(CommandLineUtil.EditParams p) {
        this.edit = p;
    }

    public String getEditLabelsHelp() {
        return "<A HREF=\"http://minorthird.sourceforge.net/tutorials/EditLabels%20Tutorial.htm\">EditLabels Tutorial</A></html>";
    }

    public CommandLineProcessor getCLP() {
        return new JointCommandLineProcessor(new CommandLineProcessor[]{this.gui, this.base, this.edit});
    }

    public void doMain() {
        if (this.edit.editFile == null) {
            throw new IllegalArgumentException("need to specify -edit");
        }
        TextBase textBase = this.base.labels.getTextBase();
        try {
            this.editorOutputLabels = new TextLabelsLoader().loadOps(textBase, this.edit.editFile);
        }
        catch (IOException ex) {
            System.out.println("Can't load from " + this.edit.editFile + ": " + ex);
            return;
        }
        if (this.edit.trueType != null) {
            this.editorOutputLabels.declareType(this.edit.trueType);
        }
        TextBaseEditor editor = TextBaseEditor.edit(this.editorOutputLabels, this.edit.editFile);
        if (this.edit.extractedType != null) {
            editor.getViewer().getGuessBox().setSelectedItem(this.edit.extractedType);
        }
        if (this.edit.trueType != null) {
            editor.getViewer().getTruthBox().setSelectedItem(this.edit.trueType);
        }
        if (this.base.showResult) {
            new ViewerFrame("Output of editing", new SmartVanillaViewer(this.editorOutputLabels));
        }
    }

    public Object getMainResult() {
        return this.editorOutputLabels;
    }

    public static void main(String[] args) {
        new EditLabels().callMain(args);
    }
}

